//
//   File : kvi_colorwin.cpp (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_colorwin.cpp)
//   Last major modification : Wed Jan 6 1999 04:30:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_colorwin.h"
#include "kvi_app.h"
#include "kvi_options.h"

#include "kvi_xutils.h"

#include <qnamespace.h>

#ifdef COMPILE_USE_AA_FONTS
	extern XftFont        * g_pXftFont;
	extern XftDraw        * g_pXftDraw;
	extern int qt_use_xft (void); // qpainter_x11.cpp
	extern void *qt_ft_font (const QFont *f); // qfont_x11.cpp
	extern XftDraw * qt_lookup_ft_draw (Drawable draw, bool paintEventClipOn, QRegion *crgn);
#endif

KviColorWindow::KviColorWindow()
:QWidget(0,"KviColorWindow",Qt::WType_Popup)
{
	setFocusPolicy(QWidget::NoFocus);
	setBackgroundMode(NoBackground);
	setFixedSize(146,38);
	m_pOwner = 0;
	QFont fnt("fixed",10);
	setFont(fnt);
}

KviColorWindow::~KviColorWindow()
{
	killTimers();
//	if(m_pOwner)m_pOwner->setFocus();
}

void KviColorWindow::popup(QWidget *owner)
{
	m_pOwner = owner;
	show();
}

void KviColorWindow::paintEvent(QPaintEvent *)
{
	static int clrIdx[16]={ 1,0,0,0,0,0,0,0,1,1,1,1,0,0,0,1 };
	Display *dpy          = x11Display();
	GC gc_aux             = XCreateGC(dpy,handle(),0,0);
	XSetLineAttributes(dpy,gc_aux,1,LineSolid,CapButt,JoinMiter);
#ifdef COMPILE_USE_AA_FONTS
	if(qt_use_xft())
	{
		g_pXftFont = (XftFont *)qt_ft_font(&(font()));
		g_pXftDraw = qt_lookup_ft_draw (handle(),false,0);
		if(!g_pXftDraw)
		{
			XSetFont(dpy,gc_aux,font().handle());
			g_pXftFont = 0;
		}
		
	} else {
#endif
		XSetFont(dpy,gc_aux,font().handle());
#ifdef COMPILE_USE_AA_FONTS
		g_pXftFont = 0;
		g_pXftDraw = 0;
	}
#endif
	kvi_xDraw3dRect(dpy,gc_aux,handle(),colorGroup(),0,0,width()-1,height()-1,false);
	int curX=1;
	for(int i=0;i<8;i++){
		kvi_xDraw3dRect(dpy,gc_aux,handle(),colorGroup(),curX,1,curX+17,18,true);
		XSetForeground(dpy,gc_aux,g_pOptions->m_pMircColor[i]->pixel());
		XFillRectangle(dpy,handle(),gc_aux,curX+1,2,16,16);
		XSetForeground(dpy,gc_aux,g_pOptions->m_pMircColor[clrIdx[i]]->pixel());
		char c='0'+i;
#ifdef COMPILE_USE_AA_FONTS
		if(g_pXftFont){
			XftColor color;
			QColor * clr = g_pOptions->m_pMircColor[clrIdx[i]];
			color.color.red = clr->red() | clr->red() << 8;
			color.color.green = clr->green() | clr->green() << 8;
			color.color.blue = clr->blue() | clr->blue() << 8;
			color.color.alpha = 0xffff;
			color.pixel = clr->pixel();
			XftDrawString8(g_pXftDraw,&color,g_pXftFont,curX+5,14,(unsigned char *)&c,1);
		} else
#endif
			XDrawString(dpy,handle(),gc_aux,curX+5,14,&c,1);
		curX+=18;
	}
	curX=1;
	for(int i=8;i<16;i++){
		kvi_xDraw3dRect(dpy,gc_aux,handle(),colorGroup(),curX,19,curX+17,36,true);
		XSetForeground(dpy,gc_aux,g_pOptions->m_pMircColor[i]->pixel());
		XFillRectangle(dpy,handle(),gc_aux,curX+1,20,16,16);
		XSetForeground(dpy,gc_aux,g_pOptions->m_pMircColor[clrIdx[i]]->pixel());
		char c[2];
		if(i<10){
			c[0]='0'+i;
#ifdef COMPILE_USE_AA_FONTS
			if(g_pXftFont){
				XftColor color;
				QColor * clr = g_pOptions->m_pMircColor[clrIdx[i]];
				color.color.red = clr->red() | clr->red() << 8;
				color.color.green = clr->green() | clr->green() << 8;
				color.color.blue = clr->blue() | clr->blue() << 8;
				color.color.alpha = 0xffff;
				color.pixel = clr->pixel();
				XftDrawString8(g_pXftDraw,&color,g_pXftFont,curX+5,33,
					(unsigned char *)c,1);
			} else
#endif
				XDrawString(dpy,handle(),gc_aux,curX+5,33,c,1);
		} else {
			c[0]='1';
			c[1]='0'+(i-10);
#ifdef COMPILE_USE_AA_FONTS
			if(g_pXftFont){
				XftColor color;
				QColor * clr = g_pOptions->m_pMircColor[clrIdx[i]];
				color.color.red = clr->red() | clr->red() << 8;
				color.color.green = clr->green() | clr->green() << 8;
				color.color.blue = clr->blue() | clr->blue() << 8;
				color.color.alpha = 0xffff;
				color.pixel = clr->pixel();
				XftDrawString8(g_pXftDraw,&color,g_pXftFont,curX+2,33,
					(unsigned char *)c,2);
			} else
#endif
				XDrawString(dpy,handle(),gc_aux,curX+2,33,c,2);
		}
		curX+=18;
	}
	XFreeGC(dpy,gc_aux);
}

void KviColorWindow::keyPressEvent(QKeyEvent *e)
{
	killTimers();
	hide();
	if(m_pOwner)g_pApp->sendEvent(m_pOwner,e);
}

void KviColorWindow::mousePressEvent(QMouseEvent *)
{
	killTimers();
	hide();
}

void KviColorWindow::show()
{
	startTimer(10000); //10 sec ...seems enough
	QWidget::show();
}

void KviColorWindow::timerEvent(QTimerEvent *)
{
	killTimers();
	hide();
}

#include "m_kvi_colorwin.moc"
