#ifndef _KVI_DLGLOADSCRIPT_H_INCLUDED_
#define _KVI_DLGLOADSCRIPT_H_INCLUDED_

//
//   File : kvi_dlgloadscript.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dlgloadscript.h)
//   Last major modification : Thu Jun 24 1999 17:50:42 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"

#include <qdialog.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qmultilineedit.h>
#include <qcheckbox.h>

typedef struct _KviScriptDefinition
{
	KviStr szName;
	KviStr szVersion;
	KviStr szAuthor;
	KviStr szEMail;
	KviStr szDate;
	KviStr szGenerator;
	KviStr szLanguageTag;
	KviStr szDescription;
	KviStr szWarnings;
	KviStr szKvsFileName;
} KviScriptDefinition;

class KviDlgLoadScript : public QDialog
{
	Q_OBJECT
public:
	KviDlgLoadScript(QWidget *parent);
	~KviDlgLoadScript();
public:
	QPushButton * m_pOkButton;
	QListBox    * m_pListBox;
	QList<KviScriptDefinition> * m_pScriptList;

	QLabel         * m_pScriptName;
	QLabel         * m_pScriptAuthor;
	QLabel         * m_pScriptEMail;
	QLabel         * m_pScriptVersion;
	QLabel         * m_pScriptDate;
	QLabel         * m_pScriptGenerator;
	QLabel         * m_pScriptLanguageTag;
	QMultiLineEdit * m_pScriptDescription;
	QMultiLineEdit * m_pScriptWarnings;

	QCheckBox      * m_pRemoveEventsCheck;
	QCheckBox      * m_pRemoveAliasesCheck;
	QCheckBox      * m_pRemovePopupsCheck;

public:
	void getSelectedScriptFileName(KviStr &buffer,bool &bRemoveAliases,bool &bRemovePopups,bool &bRemoveEvents);
protected:
	void scanScriptDirectory();
signals:
	void finished(bool bAccepted);
protected slots:
//	virtual void done(int r);
	void okPressed();
	void cancelPressed();
	void scriptSelected(int idx);
	virtual void closeEvent(QCloseEvent *);
};

#endif //!_KVI_DLGLOADSCRIPT_H_INCLUDED_
