//
//   File : kvi_scriptwizard.cpp (/usr/build/KVICVS/kvirc/src/kvirc/kvi_scriptwizard.cpp)
//   Last major modification : Sun Aug 1 1999 13:53:20 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_scriptwizard.h"

#include "kvi_app.h"
#include "kvi_locale.h"

#include "kvi_scripteditor.h"
#include "kvi_fileutils.h"
#include "kvi_options.h"
#include "kvi_opaquelabel.h"

#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>
#include <qpixmap.h>

/*
	@quickhelp: KviScriptWizard
	@widget: Script wizard
		This is the wizard that guides you through the script
		creation process.
*/

KviScriptWizard::KviScriptWizard()
: QWizard()
{
	setCaption("KVIrc: Script Wizard");

/*
	@quickhelp: QWidget_ScriptWizardPage1
	@widget: Script wizard page 1
		Here starts the script creation.<br>
		In the 'name' edit box you should insert the name of your script.<br>
		It will be displayed to the user while loading it.<br>
		In the 'version' edit goes...ehm...yes , the version number of your script.<br>
		The 'subdirectory' field needs more explaination:<br>
		KVIrc scripts are made of multiple files that are stored
		in a subdirectory of the <a href="s_kvircscriptdir.kvihelp">$KVircScriptDir</a>.<br>
		The subdirectory name should remind the name and the version of
		your script , but MUST be a valid directory name (for example can not contain spaces).<br>
		Example:<br>
		If your script name is 'Killer Script' and the version is '4.5.44',
		the subdirectory should be something as 'KillerScript-4.5.44'.<br>
*/

	m_pPage1 = new QWidget(this,"ScriptWizardPage1");
	QGridLayout * g = new QGridLayout(m_pPage1,5,3,10,4);

	KviOpaqueLabel * ol = new KviOpaqueLabel(m_pPage1);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,3,0,0);


	KviStr szRetPath;

	if(g_pApp->findImage(szRetPath,"kvi_wizard_1.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	QLabel *l = new QLabel(_CHAR_2_QSTRING(
		__tr("Welcome to the KVIrc Script Wizard.\n"\
			"To begin exporting your script, enter a name and directory for\n"\
			"the script.\n"\
			"The name may contain any characters, and will be displayed when\n"\
			"the script is loaded.\n"\
			"The script directory will be created under the KVIrc script\n"\
			"directory, and the script will be saved there.\n"\
			"The script subdirectory should contain the name and version\n"\
			"of your script, but may contain only letters, digits, hypens,\n"\
			"points (fullstops), and underscores; something like\n"\
			"'Script-1.0' would be ok.\n"\
			"If the subdirectory already exists on your machine, KVIrc\n"\
			"will rename the existing directory by adding a '.bak' suffix.")
		),m_pPage1
	);
	l->setAlignment(AlignTop | AlignLeft);
	g->addMultiCellWidget(l,0,0,1,2);

	l = new QLabel(__tr("Name:"),m_pPage1);
	g->addWidget(l,1,1);

	m_pNameEdit = new QLineEdit(m_pPage1);
	m_pNameEdit->setText(__tr("My Script"));
	connect(m_pNameEdit,SIGNAL(textChanged(const QString &)),this,SLOT(page1TextChanged(const QString &)));
	g->addWidget(m_pNameEdit,1,2);

	l = new QLabel(__tr("Version:"),m_pPage1);
	g->addWidget(l,2,1);

	m_pVersionEdit = new QLineEdit(m_pPage1);
	m_pVersionEdit->setText(__tr("1.0.0"));
	connect(m_pVersionEdit,SIGNAL(textChanged(const QString &)),this,SLOT(page1TextChanged(const QString &)));
	g->addWidget(m_pVersionEdit,2,2);

	KviStr szPath;
	g_pApp->getLocalKVircDirectory(szPath,KviApp::Scripts);
	szPath.prepend(__tr("Script directory: "));
	l = new QLabel(szPath.ptr(),m_pPage1);
	g->addMultiCellWidget(l,3,3,1,2);
	
	l = new QLabel(__tr("Subdirectory:"),m_pPage1);
	g->addWidget(l,4,1);

	m_pSubdirEdit = new QLineEdit(m_pPage1);
	m_pSubdirEdit->setText(__tr("MyScript-1.0.0"));
	connect(m_pSubdirEdit,SIGNAL(textChanged(const QString &)),this,SLOT(page1TextChanged(const QString &)));
	g->addWidget(m_pSubdirEdit,4,2);

	g->setRowStretch(0,1);

	addPage(m_pPage1,_CHAR_2_QSTRING(__tr("Step 1: Script Basics")));

/*
	@quickhelp: QWidget_ScriptWizardPage2
	@widget: Script wizard page 2
		Here you can insert some basic informations about your script:<br>
		The author name , the author e-mail and a short description.<br>
		You should clearly describe what your script does ,
		the look , the purposes and features.<br>
*/

	m_pPage2 = new QWidget(this,"ScriptWizardPage2");
	g = new QGridLayout(m_pPage2,7,2,10,4);

	ol = new KviOpaqueLabel(m_pPage2);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,6,0,0);

	if(g_pApp->findImage(szRetPath,"kvi_wizard_2.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	l = new QLabel(_CHAR_2_QSTRING(
		__tr("Now, you can enter some descriptive information about your\n"\
			"script.\n"\
			"This section is optional, but it never hurts to have a good\n"\
			"description to help users evaluate your script.\n"\
			"Author information is recommended if you want users to be able\n"\
			"to contact you regarding the script.")
		),m_pPage2
	);
	l->setAlignment(AlignTop | AlignLeft);
	g->addWidget(l,0,1);

	l = new QLabel(__tr("Author:"),m_pPage2);
	g->addWidget(l,1,1);

	m_pAuthorEdit = new QLineEdit(m_pPage2);
	g->addWidget(m_pAuthorEdit,2,1);

	l = new QLabel(__tr("E-Mail:"),m_pPage2);
	g->addWidget(l,3,1);

	m_pEMailEdit = new QLineEdit(m_pPage2);
	g->addWidget(m_pEMailEdit,4,1);

	l = new QLabel(__tr("Description:"),m_pPage2);
	g->addWidget(l,5,1);

	m_pDescriptionEdit = new QMultiLineEdit(m_pPage2);
	m_pDescriptionEdit->setText(__tr("My script is simply great!"));
	g->addWidget(m_pDescriptionEdit,6,1);

	g->setRowStretch(6,1);

	addPage(m_pPage2,_CHAR_2_QSTRING(__tr("Step 2: Script Description")));

/*
	@quickhelp: QWidget_ScriptWizardPage3
	@widget: Script wizard page 3
		Here you choose if the Graphic User Interface options should be saved.<br>
		The 'save colors and style settings' option allows saving the colors of
		all the widgets inside KVirc (foregrounds , bacgrounds...).<br>
		If you choose to 'save the background images' , KVIrc will
		store also the images that you have currently set as backgrounds
		for the view , listbox , input , labels and the main mdi window.<br>
		The images will be saved in the PNG (Portable Network Graphics)
		format (natively supported by the Qt library), and referenced
		in the script with directories relative to <a href="s_kvircscriptdir.kvihelp">$KVircScriptDir</a>.<br>
		Take care with the font settings: not all users have the same fonts as you
		and with uncommon typefaces the final results on the users machine may look really ugly.<br>
		If you absolutely need to use an uncommon typeface , it is a good idea to
		distribute the font file with the script (see <a href="qh_qwidget_scriptwizardpage6.kvihelp">page 6</a>)
		and ask the user to install it (maybe providing a script for the installation (and <a href="qh_qwidget_scriptwizardpage7.kvihelp">auto-running</a> it ?)).<br>
		It is a good idea to save all the "color" options (colors , backgrounds and text colors)
		or not save them at all , since each setting depends visually on the others.<br>
*/

	m_pPage3 = new QWidget(this,"ScriptWizardPage3");
	g = new QGridLayout(m_pPage3,5,2,10,4);

	ol = new KviOpaqueLabel(m_pPage3);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,4,0,0);

	if(g_pApp->findImage(szRetPath,"kvi_wizard_3.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	l = new QLabel(_CHAR_2_QSTRING(__tr("You can choose to include all or part of your appearance\n"\
		"settings with the script.\n"\
		"If you're going to distribute the script, it is recommended to\n"\
		"either save ALL of the options or NOT to save them at all.\n"\
		"Be careful with the font settings; other users may not have the\n"\
		"same typefaces installed.")),m_pPage3);

	g->addWidget(l,0,1);

	m_pSaveColorsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save color and style settings")),m_pPage3);
	m_pSaveColorsCheck->setChecked(true);
	g->addWidget(m_pSaveColorsCheck,1,1);

	m_pSaveBackgroundsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save background images")),m_pPage3);
	m_pSaveBackgroundsCheck->setChecked(true);
	g->addWidget(m_pSaveBackgroundsCheck,2,1);

	m_pSaveFontsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save font settings")),m_pPage3);
	m_pSaveFontsCheck->setChecked(true);
	g->addWidget(m_pSaveFontsCheck,3,1);

	m_pSaveTextColorsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save text colors")),m_pPage3);
	m_pSaveTextColorsCheck->setChecked(true);
	g->addWidget(m_pSaveTextColorsCheck,4,1);

	g->setRowStretch(0,1);

	addPage(m_pPage3,_CHAR_2_QSTRING(__tr("Step 3: Included Settings")));
/*
	@quickhelp: QWidget_ScriptWizardPage4
	@widget: Script wizard page 4
		Here you choose to save or not the aliases , event handlers , popup menus and toolbar settings.<br>
		These settings will be shipped in config files equal to the ones
		that KVIrc uses to save the options (aliases.conf , popups.conf , events.conf , toolbar.conf),
		and then loaded with the <a href="loadconf.kvihelp">LOADCONF</a> command.<br>
*/

	m_pPage4 = new QWidget(this,"ScriptWizardPage4");
	g = new QGridLayout(m_pPage4,6,2,10,4);

	ol = new KviOpaqueLabel(m_pPage4);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,5,0,0);

	if(g_pApp->findImage(szRetPath,"kvi_wizard_4.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	l = new QLabel(_CHAR_2_QSTRING(__tr("Select the options below to save current aliases, event\n"\
		"handlers, popup menus or user toolbar items. \n")),m_pPage4);

	g->addWidget(l,0,1);

	m_pSaveAliasesCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save aliases")),m_pPage4);
	m_pSaveAliasesCheck->setChecked(true);
	g->addWidget(m_pSaveAliasesCheck,1,1);

	m_pSaveEventsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save event handlers")),m_pPage4);
	m_pSaveEventsCheck->setChecked(true);
	g->addWidget(m_pSaveEventsCheck,2,1);

	m_pSavePopupsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save popups")),m_pPage4);
	m_pSavePopupsCheck->setChecked(true);
	g->addWidget(m_pSavePopupsCheck,3,1);

	m_pSaveToolbarCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save user toolbar")),m_pPage4);
	m_pSaveToolbarCheck->setChecked(true);
	g->addWidget(m_pSaveToolbarCheck,4,1);

	m_pSaveRawEventsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save raw event handlers")),m_pPage4);
	m_pSaveRawEventsCheck->setChecked(true);
	g->addWidget(m_pSaveRawEventsCheck,5,1);


	g->setRowStretch(0,1);

	addPage(m_pPage4,_CHAR_2_QSTRING(__tr("Step 4: Script Elements")));

/*
	@quickhelp: QWidget_ScriptWizardPage5
	@widget: Script wizard page 5
		TODO		
*/

	m_pPage5 = new QWidget(this,"ScriptWizardPage5");
	g = new QGridLayout(m_pPage5,5,2,10,4);

	ol = new KviOpaqueLabel(m_pPage5);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,4,0,0);

	if(g_pApp->findImage(szRetPath,"kvi_wizard_3.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	l = new QLabel(_CHAR_2_QSTRING(__tr("Select the options below for more settings to include\n"\
		"with your script.")),m_pPage5);

	g->addWidget(l,0,1);

	m_pSaveMessagesCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save default messages")),m_pPage5);
	m_pSaveMessagesCheck->setChecked(true);
	g->addWidget(m_pSaveMessagesCheck,1,1);

	m_pSaveOutputRedirectionCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save output redirection options")),m_pPage5);
	m_pSaveOutputRedirectionCheck->setChecked(true);
	g->addWidget(m_pSaveOutputRedirectionCheck,2,1);

	m_pSaveCTCPOptionsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save CTCP options")),m_pPage5);
	m_pSaveCTCPOptionsCheck->setChecked(true);
	g->addWidget(m_pSaveCTCPOptionsCheck,3,1);

	m_pSaveIrcEngineOptionsCheck = new QCheckBox(_CHAR_2_QSTRING(__tr("Save IRC engine options")),m_pPage5);
	m_pSaveIrcEngineOptionsCheck->setChecked(true);
	g->addWidget(m_pSaveIrcEngineOptionsCheck,4,1);

	g->setRowStretch(0,1);

	addPage(m_pPage5,_CHAR_2_QSTRING(__tr("Step 5: More Settings")));
/*
	@quickhelp: QWidget_ScriptWizardPage6
	@widget: Script wizard page 6
		TODO		
*/
	m_pPage6 = new QWidget(this,"ScriptWizardPage6");
	g = new QGridLayout(m_pPage6,3,3,10,4);

	ol = new KviOpaqueLabel(m_pPage6);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,2,0,0);

	if(g_pApp->findImage(szRetPath,"kvi_wizard_3.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	l = new QLabel(_CHAR_2_QSTRING(__tr("Add the additional files that you wish to be distributed\n"\
		"with your script.\n")),m_pPage6);

	g->addMultiCellWidget(l,0,0,1,2);

	m_pExtraFilesBox = new QListBox(m_pPage6);
	g->addMultiCellWidget(m_pExtraFilesBox,1,1,1,2);

	QPushButton * b = new QPushButton(__tr("&Add..."),m_pPage6);
	connect(b,SIGNAL(clicked()),this,SLOT(addExtraFile()));
	g->addWidget(b,2,1);

	m_pRemoveExtra = new QPushButton(__tr("&Remove"),m_pPage6);
	m_pRemoveExtra->setEnabled(false);
	connect(m_pRemoveExtra,SIGNAL(clicked()),this,SLOT(removeSelectedExtraFiles()));
	g->addWidget(m_pRemoveExtra,2,2);

//	g->setRowStretch(1,1);

	addPage(m_pPage6,_CHAR_2_QSTRING(__tr("Step 6: Additional Files")));

/*
	@quickhelp: QWidget_ScriptWizardPage7
	@widget: Script wizard page 7
		TODO		
*/

	m_pPage7 = new QWidget(this,"ScriptWizardPage7");
	g = new QGridLayout(m_pPage7,2,2,10,4);

	ol = new KviOpaqueLabel(m_pPage7);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,1,0,0);

	if(g_pApp->findImage(szRetPath,"kvi_wizard_3.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	l = new QLabel(_CHAR_2_QSTRING(__tr("Enter the KVI++ code that you wish to be executed immediately\n"\
		"after your script has been completely loaded. If your script \n"\
		"requires KVIrc to be restarted, this is a good place to ask\n"\
		"the user to do it (or do it yourself, but at least warn the\n"\
		"user beforehand).\n")),m_pPage7);

	g->addWidget(l,0,1);

	m_pEpilogue = new KviScriptEditor(m_pPage7);
	m_pEpilogue->setText("echo -w=$console Script successfully loaded.");
	g->addWidget(m_pEpilogue,1,1);

	g->setRowStretch(1,1);

	addPage(m_pPage7,_CHAR_2_QSTRING(__tr("Step 7: Code Epilogue")));

	m_pPage8 = new QWidget(this,"ScriptWizardPage8");
	g = new QGridLayout(m_pPage8,2,2,10,4);

	ol = new KviOpaqueLabel(m_pPage8);
	ol->setFixedSize(150,200);
	ol->setFrameStyle(QFrame::Panel|QFrame::Sunken);
	ol->setBackgroundColor(Qt::black);
	g->addMultiCellWidget(ol,0,1,0,0);

	if(g_pApp->findImage(szRetPath,"kvi_wizard_3.png"))
	{
		QPixmap pix(szRetPath.ptr());
		if(!pix.isNull())ol->setBackgroundPixmap(pix);
	}

	l = new QLabel(_CHAR_2_QSTRING(__tr("Check the following option if you want a tar.gz archive of\n"\
		"your script distribution to be automatically created.\n")),m_pPage8);

	g->addWidget(l,0,1);

	m_pCreateTarball = new QCheckBox(__tr("Create tar.gz distribution package"),m_pPage8);
	m_pCreateTarball->setChecked(true);
	g->addWidget(m_pCreateTarball,1,1);

	g->setRowStretch(0,1);

	addPage(m_pPage8,_CHAR_2_QSTRING(__tr("Step 8: Script Packaging")));

	connect(this,SIGNAL(helpClicked()),g_pApp,SLOT(slot_whatIsThisRequest()));
	setFinishEnabled(m_pPage8,true);

}

KviScriptWizard::~KviScriptWizard()
{
}

void KviScriptWizard::done(int r)
{
	QWizard::done(r);
	emit finished(r == Accepted);
}

void KviScriptWizard::closeEvent(QCloseEvent *)
{
	// Finished without committing
	emit finished(false);
}

void KviScriptWizard::page1TextChanged(const QString &newText)
{
	KviStr tmp = newText;
	if(nextButton()){
		if(nextButton()->isEnabled() != tmp.hasData())setNextEnabled(m_pPage1,tmp.hasData());
	}
}

void KviScriptWizard::addExtraFile()
{
//	KviStr tmp = kvi_askForOpenFileName(g_pOptions->m_szLastBrowsedDirectory.ptr(),"*");
	QStringList l(kvi_askForOpenFileNames(g_pOptions->m_szLastBrowsedDirectory.ptr(),"*"));
	for(QStringList::Iterator it = l.begin(); it != l.end(); ++it ){
		m_pExtraFilesBox->insertItem(*it);
	}
	m_pRemoveExtra->setEnabled(m_pExtraFilesBox->count() > 0);
}

void KviScriptWizard::removeSelectedExtraFiles()
{
	int cur = m_pExtraFilesBox->currentItem();
	if((cur >= 0) && (cur < (int)m_pExtraFilesBox->count())){
		m_pExtraFilesBox->removeItem(cur);
	}
	m_pRemoveExtra->setEnabled(m_pExtraFilesBox->count() > 0);
}

void KviScriptWizard::fillSaveScriptStruct(KviSaveScriptStruct *s)
{
	s->szName                 = m_pNameEdit->text();
	s->szVersion              = m_pVersionEdit->text();
	s->szSubdir               = m_pSubdirEdit->text();
	s->szAuthor               = m_pAuthorEdit->text();
	s->szEMail                = m_pEMailEdit->text();
	s->szDescription          = m_pDescriptionEdit->text();
	s->bSaveColors            = m_pSaveColorsCheck->isChecked();
	s->bSaveFonts             = m_pSaveFontsCheck->isChecked();
	s->bSaveBackgrounds       = m_pSaveBackgroundsCheck->isChecked();
	s->bSaveTextColors        = m_pSaveTextColorsCheck->isChecked();
	s->bSaveMessages          = m_pSaveMessagesCheck->isChecked();
	s->bSaveOutputRedirection = m_pSaveOutputRedirectionCheck->isChecked();
	s->bSaveCTCPOptions       = m_pSaveCTCPOptionsCheck->isChecked();
	s->bSaveIrcEngineOptions  = m_pSaveIrcEngineOptionsCheck->isChecked();
	s->bSaveAliases           = m_pSaveAliasesCheck->isChecked();
	s->bSaveEvents            = m_pSaveEventsCheck->isChecked();
	s->bSaveRawEvents         = m_pSaveRawEventsCheck->isChecked();
	s->bSavePopups            = m_pSavePopupsCheck->isChecked();
	s->bSaveToolbar           = m_pSaveToolbarCheck->isChecked();
	s->szEpilogue             = m_pEpilogue->text();
	if(m_pExtraFilesBox->count() > 0){
		s->pExtraFilesList = new QList<KviStr>;
		s->pExtraFilesList->setAutoDelete(true);
		for(uint i=0;i < m_pExtraFilesBox->count();i++){
			KviStr * str = new KviStr(m_pExtraFilesBox->text(i));
			s->pExtraFilesList->append(str);
		}
	} else s->pExtraFilesList = 0;
	s->bCreateTarball         = m_pCreateTarball->isChecked();
}

#include "m_kvi_scriptwizard.moc"
