//
//   File : kvi_toolbar.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_toolbar.cpp)
//   Last major modification : Tue Jul 6 1999 14:51:31 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//


#define _KVI_DEBUG_THIS_FILE_
#define _KVI_DEBUG_CLASS_NAME_ "KviToolBar"
#include "kvi_debug.h"

#include "kvi_app.h"
#include "kvi_toolbar.h"
#include "kvi_frame.h"

#include "kvi_imagelib.h"
#include "kvi_string.h"
#include "kvi_locale.h"
//#include "kvi_systray.h"

#include "kvi_style.h"

#include <qpixmap.h>
#include <qpainter.h>

//Images managed by KviApp class
extern QPixmap *g_pReadyStatePixmap;
extern QPixmap *g_pBusyStatePixmap;
extern QPixmap *g_pConnectedStatePixmap;

#include <qimage.h>
#include <qcolor.h>

//============ KviToolBar ============//

KviToolBar::KviToolBar(KviFrame *parent,QMainWindow::ToolBarDock dock)
:QToolBar("MainToolBar",parent,dock,false,"main_tool_bar")
{
	//32x32 or 16x16 pixmaps
	m_pConnectButton=new KviToolBarButton(*g_pReadyStatePixmap,_i18n_("Connect"),
		_i18n_("Start or stop an IRC connection"),parent,SLOT(slot_connectToServer()),this,"connect_btn");
	m_pConnectButton->setFocusPolicy(QWidget::NoFocus);

	KviStr szP1;
	KviStr szP2;
	g_pApp->getLocalKVircDirectory(szP1,KviApp::Pics,KVI_TOOLBAR_BIG_IMAGE_LIBRARY_NAME);
	g_pApp->getGlobalKVircDirectory(szP2,KviApp::Pics,KVI_TOOLBAR_BIG_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib(szP1.ptr(),szP2.ptr(),32,32);
	__range_valid(lib.libraryLoaded());

	KviGuiSeparator * sep = new KviGuiSeparator(this);
	(void) sep;


	KviToolBarButton *b=new KviToolBarButton(lib.getImage(0),__tr("User Configuration"),
		__tr("Display the user configuration dialog"),g_pApp,SLOT(slot_doUserOptionsDialog()),this,"user_options_btn");
	b=new KviToolBarButton(lib.getImage(1),__tr("Server Options"),
		__tr("Display the server options dialog"),g_pApp,SLOT(slot_doServerOptionsDialog()),this,"server_options_btn");
	b=new KviToolBarButton(lib.getImage(2),__tr("General Options"),
		__tr("Display the general options dialog"),g_pApp,SLOT(slot_generalOptionsDialog()),this,"misc_options_btn");
	b=new KviToolBarButton(lib.getImage(3),__tr("Registered Users"),
		__tr("Display the registered users dialog"),g_pApp,SLOT(slot_doRegUsersDialog()),this,"regusers_dialog_btn");
	b=new KviToolBarButton(lib.getImage(4),__tr("Script Center"),
		__tr("Display the script center"),parent,SLOT(slot_showScriptCenter()),this,"script_center_button");
	
	sep = new KviGuiSeparator(this);
	(void)sep;


	b=new KviToolBarButton(lib.getImage(5),__tr("Directory Browser"),
		__tr("Show or hide the directory browser"),parent,SLOT(toggleDirBrowser()),this,"dirbrowser_btn");
	b=new KviToolBarButton(lib.getImage(6),__tr("Help Browser"),
		__tr("Show or hide the help browser"),parent,SLOT(toggleHelpWindow()),this,"helpwin_btn");
	b=new KviToolBarButton(lib.getImage(7),__tr("What's This?"),
		__tr("Enter mode to display help on a clicked item"),parent,SLOT(slot_whatIsThisRequest()),this,"whatisthis_btn");

	setHorizontalStretchable(false);
	setVerticalStretchable(false);

	setBackgroundMode(QWidget::PaletteBackground);
}

//============ ~KviToolBar ============//

KviToolBar::~KviToolBar()
{
}

//============= setConnectButtonState ===========//

void KviToolBar::setConnectButtonState(int state)
{
	switch(state){
		case KVI_CONNECT_BUTTON_STATE_BUSY:
			m_pConnectButton->setPixmap(*g_pBusyStatePixmap);
			//Qt has problems with the text labels here!
			//It removes the global toolTip (the one that is initiallhy shown in the statusBar)
			m_pConnectButton->setTextLabel(_i18n_("Abort Connection"),true);
			break;
		case KVI_CONNECT_BUTTON_STATE_CONNECTED:
			m_pConnectButton->setPixmap(*g_pConnectedStatePixmap);
			m_pConnectButton->setTextLabel(_i18n_("Disconnect"),true);
			break;
		default: //KVI_CONNECT_BUTTON_STATE_READY
			m_pConnectButton->setPixmap(*g_pReadyStatePixmap);
			m_pConnectButton->setTextLabel(_i18n_("Connect"),true);
			break;
	}
}


//============ KviToolBar ============//

KviMdiToolBar::KviMdiToolBar(KviFrame *parent,QMainWindow::ToolBarDock dock)
:QToolBar("MdiToolBar",parent,dock,false,"mdi_tool_bar")
{
	KviStr szP1;
	KviStr szP2;
	g_pApp->getLocalKVircDirectory(szP1,KviApp::Pics,KVI_TOOLBAR_BIG_IMAGE_LIBRARY_NAME);
	g_pApp->getGlobalKVircDirectory(szP2,KviApp::Pics,KVI_TOOLBAR_BIG_IMAGE_LIBRARY_NAME);
	KviImageLibrary lib(szP1.ptr(),szP2.ptr(),32,32);

	KviToolBarButton * b=new KviToolBarButton(lib.getImage(8),__tr("Pragma's Tile (Horizontal)"),
			__tr("Tile windows horizontally"),(QObject *)parent->m_pMdi,SLOT(tilePragmaHorizontal()),this,"pragma_tile_btn");
	b=new KviToolBarButton(lib.getImage(9),__tr("Anodine's Tile (Horizontal)"),
			__tr("Tile windows horizontally"),(QObject *)parent->m_pMdi,SLOT(tileAnodine()),this,"anodine_tile_btn");
	b=new KviToolBarButton(lib.getImage(10),__tr("Pragma's Tile (Vertical)"),
			__tr("Tile windows horizontally"),(QObject *)parent->m_pMdi,SLOT(tilePragmaVertical()),this,"pragma_tile_vertical_btn");
	b=new KviToolBarButton(lib.getImage(11),__tr("Cascade Maximized"),	
			__tr("Tile windows horizontally"),(QObject *)parent->m_pMdi,SLOT(cascadeMaximized()),this,"cascade_btn");
	
	setHorizontalStretchable(false);
	setVerticalStretchable(false);

	setBackgroundMode(QWidget::PaletteBackground);
}

//============ ~KviToolBar ============//

KviMdiToolBar::~KviMdiToolBar()
{
}


#include "m_kvi_toolbar.moc"
