//
//   File : kvi_uwindow.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_uwindow.cpp)
//   Last major modification : Sat Apr 17 1999 18:54:50 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_debug.h"


#include "kvi_uwindow.h"
#include "kvi_app.h"
#include "kvi_ircview.h"
#include "kvi_input.h"
#include "kvi_frame.h"
#include "kvi_options.h"
#include "kvi_uparser.h"
#include "kvi_event.h"
#include "kvi_popupmenu.h"
#include "kvi_statusbar.h"
#include "kvi_locale.h"
#include "kvi_mdi.h"

extern KviEventManager * g_pEventManager;

//Declared in kvi_app.cpp and managed by KviApp class
extern QPixmap * g_pixViewOut[KVI_OUT_NUM_IMAGES];
//extern QPixmap * g_pWindowIcon[KVI_WND_NUM_ICONS];
//extern KviPopupMenu *g_pQueryPopup;

//============ KviQuery ============//

KviUWindow::KviUWindow(KviFrame *lpFrm,const char *name)
:KviWindow(name,KVI_WND_TYPE_UWINDOW,lpFrm)
{
	m_pSplitter  = new QSplitter(QSplitter::Horizontal,this);
	m_pView      = new KviIrcView(m_pSplitter,lpFrm,this);
//	m_bHasView  = true;
	m_pView->enableDnd(true);
	connect(m_pView,SIGNAL(fileDropped(const char *)),this,SLOT(fileDroppedOnView(const char *)));
	connect(m_pView,SIGNAL(dndEntered()),this,SLOT(dndEnteredView()));

	m_pListBox   = new QListBox(m_pSplitter);
	m_pListBox->setHScrollBarMode(QScrollView::AlwaysOff);
//	m_bHasList  = true;
	connect(m_pListBox,SIGNAL(selected(int)),this,SLOT(listBoxDoubleClicked(int)));
	connect(m_pListBox,SIGNAL(highlighted(int)),this,SLOT(listBoxHighlighted(int)));

	m_pInput     = new KviInput(this,lpFrm->m_pUserParser);
	m_bHasInput  = true;
	connect(m_pView,SIGNAL(contextPopupRequested(KviIrcView *)),this,SLOT(viewRightClicked(KviIrcView *)));

	// reasonable default for the splitter
	QValueList<int> l;
	l.append(80); //%
	l.append(20); //%
	m_pSplitter->setSizes(l);

	setFocusHandler(m_pInput);
	m_bCloseEnabled = true;
}

//============ ~KviUWindow ============//

KviUWindow::~KviUWindow()
{
}

void KviUWindow::saveProperties()
{
	KviWindowProperty p;
	p.rect = externalGeometry();
	p.isDocked = isAttached();
	KviWindow * w = m_pFrm->activeWindow();
	p.isMaximized = isAttached() && w ? w->isMaximized() : isMaximized();
	p.topSplitWidth1 = 0;
	p.topSplitWidth2 = 0;
	p.topSplitWidth3 = 0;
	g_pOptions->m_pWinPropertiesList->setProperty(caption(),&p);
}

void KviUWindow::dndEnteredView()
{
	m_pFrm->m_pStatusBar->tempText(__tr("Drop the file to start the DCC Send"),5000);
}

void KviUWindow::fileDroppedOnView(const char *fileName)
{
/*	KviStr tmp(fileName);
	tmp.prepend(" ");
	tmp.prepend(caption());
	tmp.prepend("/DCC SEND ");
	m_pFrm->m_pUserParser->parseUserCommand(tmp,this);
*/
	if(g_pEventManager->eventEnabled(KviEvent_OnUserWindowFileDrop)){
		KviStr eventparms(KviStr::Format,"%s %s",m_szCaption.ptr(),fileName);
		m_pFrm->m_pUserParser->callEvent(KviEvent_OnUserWindowFileDrop,this,eventparms);
	}
}

void KviUWindow::viewRightClicked(KviIrcView *)
{
//  Make a UWindow - Popup ?????????
//
//	g_pQueryPopup->doPopup(this,SLOT(viewPopupClicked(const KviStr &)));
}

void KviUWindow::viewPopupClicked(const KviStr &dataBuffer)
{
//	m_pFrm->m_pUserParser->parseCommand(dataBuffer.ptr(),this);
}

//================= listAdd ============//

void KviUWindow::listAdd(const char *name)
{
	m_pListBox->insertItem(name);
}

//================= listRemove ============//

void KviUWindow::listRemove(const int item)
{
	m_pListBox->removeItem(item);
}

//================= listClear ============//

void KviUWindow::listClear()
{
	m_pListBox->clear();
}

//================= itemCount ==============//
int KviUWindow::itemCount()
{
	return m_pListBox->count();
}

//=========== listBoxDoubleClicked ============//

void KviUWindow::listBoxDoubleClicked(int index)
{	// WARNING: fix qt-doubleclick bug --> workaroud?
	if(g_pEventManager->eventEnabled(KviEvent_OnUserWindowSelected)){
		KviStr tmp = m_pListBox->text(index);
		KviStr eventparms(KviStr::Format,"%s %c %d %s",m_szCaption.ptr(),'1',index,tmp.ptr());
		m_pFrm->m_pUserParser->callEvent(KviEvent_OnUserWindowSelected,this,eventparms);
	}
}

//============ listBoxHighlighted ============//

void KviUWindow::listBoxHighlighted(int index)
{
	if(g_pEventManager->eventEnabled(KviEvent_OnUserWindowSelected)){
		KviStr tmp = m_pListBox->text(index);
		KviStr eventparms(KviStr::Format,"%s %c %d %s",m_szCaption.ptr(),'0',index,tmp.ptr());
		m_pFrm->m_pUserParser->callEvent(KviEvent_OnUserWindowSelected,this,eventparms);
	}
}


//================ myIconPtr =================//

QPixmap * KviUWindow::myIconPtr()
{
	return g_pixViewOut[KVI_OUT_WND_UWINDOW];
}

//=============== applyOptions ================//

void KviUWindow::applyOptions()
{
	m_pView->setFont(g_pOptions->m_fntView);
	m_pView->setShowImages(g_pOptions->m_bShowImages,false);
	m_pView->setTimestamp(g_pOptions->m_bTimestamp);
	m_pView->setMaxBufferSize(g_pOptions->m_iViewMaxBufferSize);
}

//=============== hasInput ================//

void KviUWindow::hasInput(bool i)
{
	if(i){
		if(!m_bHasInput){
			int inputSize = m_pInput->heightHint();
			m_pSplitter->setGeometry(0,0,width(),height() - inputSize);
			m_pInput->setGeometry(0,height() - inputSize,width(),inputSize);
//			m_pInput->show();
		}
	} else {
		if(m_bHasInput){
			m_pSplitter->setGeometry(0,0,width(),height());
			m_pInput->setGeometry(0,0,width(),0);
//			m_pInput->hide();
		}
	}
	m_bHasInput = i;
}

//=============== hasList ================//

void KviUWindow::hasList(bool i)
{
	if(i){
		if(!m_pListBox->isVisible()){
			m_pListBox->show();
			m_pListBox->setEnabled(true);
//			m_bHasList = true;
		}
	} else {
		if(m_pView->isVisible() && m_pListBox->isVisible()){
			m_pListBox->hide();
			m_pListBox->setEnabled(false);
//			m_bHasList = false;
		}
	}
}

//=============== hasView ================//

void KviUWindow::hasView(bool i)
{
	if(i){
		if(!m_pView->isVisible()){
			m_pView->show();
			m_pView->setEnabled(true);
//			m_bHasView = true;
		}
	} else {
		if(m_pListBox->isVisible() && m_pView->isVisible()){
			m_pView->hide();
			m_pView->setEnabled(false);
//			m_bHasView = false;
		}
	}
//	m_bHasView = i;
}

//================ resizeEvent ===============//

void KviUWindow::resizeEvent(QResizeEvent *)
{
	int inputSize = (m_bHasInput ? m_pInput->heightHint() : 0);
	m_pSplitter->setGeometry(0,0,width(),height() - inputSize);
	if(m_bHasInput)m_pInput->setGeometry(0,height() - inputSize,width(),inputSize);
}

void KviUWindow::youAreAttached(KviMdiChild *lpC)
{
	KviWindow::youAreAttached(lpC);
	lpC->enableClose(m_bCloseEnabled);
}

void KviUWindow::enableClose(bool bEnable)
{
	m_bCloseEnabled = bEnable;
	if(mdiParent())mdiParent()->enableClose(m_bCloseEnabled);
}


#include "m_kvi_uwindow.moc"
