#ifndef _KVI_UWINDOW_H_INCLUDED_
#define _KVI_UWINDOW_H_INCLUDED_

//
//   File : kvi_uwindow.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_uwindow.h)
//   Last major modification : Thu Feb 11 1999 20:06:34 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include <qsplitter.h>
#include <qlistbox.h>
class KviUWindow : public KviWindow
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviUWindow(KviFrame *lpFrm,const char *name);
	~KviUWindow();

	void hasInput(bool i);
	void hasList(bool i);
	void hasView(bool i);
	QSplitter  *m_pSplitter;
	void listAdd(const char *name);
	void listRemove(const int item);
	void listClear();
	int  itemCount();
	void enableClose(bool bEnable); // FIXME : move it to KviWindow implementation ?
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual void saveProperties();
	virtual void youAreAttached(KviMdiChild *lpC);
	bool m_bHasInput;
//	bool m_bHasList;
//	bool m_bHasView;
	bool m_bCloseEnabled;
	QListBox * m_pListBox;
protected slots:
	void listBoxDoubleClicked(int index);
	void listBoxHighlighted(int index);
	void viewRightClicked(KviIrcView *);
	void viewPopupClicked(const KviStr &dataBuffer);
	void fileDroppedOnView(const char *fileName);
	void dndEnteredView();
};

#endif //_KVI_QUERY_H_INCLUDED_
