//
//   SPEAK plugin for KVirc 1.1 Phoenix.
//
//   This plugin enables you to use IBM's ViaVoiceOutloud to speak
//   messages to you.  Messages that are directed to you, over the
//   Relay Chat, can be spoken outloud or sentences spoken by specific
//   people can also heard outloud.
//
//   To use the plugin, one needs to have a working IBM ViaVoice
//   Outloud, which can be retrieved from IBM's site.  For information
//   about IBM ViaVoice http://www-4.ibm.com/software/speech/dev/
//
//   Copyright (C) rn E. Hansen (oe.hansen@gamma.telenordia.se)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef SPEAK_TREES_H
#define SPEAK_TREES_H

#include <strstream.h>
#include <iostream.h>

class Node {
private:
  Node *left, *right;
public:
  Node();
  virtual ~Node();

  Node *Left()         { return left;      };
  Node *Left(Node *);
  Node *Right()        { return right;     };
  Node *Right(Node *);

  virtual int Compare(Node *ref) { return 0; };
  virtual int Compare(void *ref) { return 0; };

  virtual void Debug() { cout << "Debug" << endl; };

  static Node null;
};

class BasicTree {
private:
  Node *head;
public:
  BasicTree();
  ~BasicTree();

  int  Length();
  int  Length(Node *ref);

  void Insert(Node *ref);
  void Unlink(Node *ref);

  Node *Delete(Node *ref);

  Node *Head()          { return head; };
  Node *Head(Node *s)   { return head = s; };

  Node *operator () (int n);

  Node *Down(Node *base, Node *ref);
  Node *Lookup(void *key);
  Node *Parent(Node *ref);
};

#endif


