//////////////////////////////////////////////////////////////////////////
//   File : libkvitkjb.cpp
//   Last major modification : Mon Oct 9 17:03:43 1999 by Jason Cohen
//
//   Copyright (C) 1999-2000 Jason A. Cohen (timekepr@excite.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifdef QT_NO_ASCII_CAST
#undef QT_NO_ASCII_CAST
#endif

#define __KVIRC_PLUGIN__

#include "kvirc_plugin.h"
#include "kvi_event.h"
#include "kvi_channel.h"
#include "libkvitkjb.h"
#include "tkjbmp3file.h"

#include <stdlib.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>

//////////////////////////////////////////////////////////////////
// Global Vars
TkJbConfig *dlg=0;
// State Saved
static bool g_bTkjbActivateOnStartup;
static bool g_bTkjbAutoVoiceServers;
static KviStr g_szTkjbRelativeRootPath; //Set in tkjbActivate
static QString g_szTkjbHumanMP3FileList;
static KviStr g_szTkjbDefaultListenNick;
static bool g_bTkjbSendCompressedFile;
static QString g_szTkjbCompressedHumanMP3FileList;
static QList<QString> g_ActiveChanList;

// Volitile State
static KviStr g_szMyNick; // Set in tkjbActivate();
static bool g_bTkjbActive = false;
static TkjbMP3FileList g_TkjbMP3List;




///////////////////////////////////////////////////////////////////
//  Housekeeping

// Load Plugin state
void tkjbLoadState(void)
{
	KviStr fName,tmp,chan;
	kvirc_plugin_get_config_file_path(fName,"TkJb");
	KviConfig cfg(fName.ptr());
	
	
	g_bTkjbActivateOnStartup			      =cfg.readBoolEntry("TkjbActivateOnStartup",false);
	g_bTkjbAutoVoiceServers				      =cfg.readBoolEntry("TkjbAutoVoiceServers",false);
	g_szTkjbRelativeRootPath			      =cfg.readEntry("TkjbRelativeRootPath","mp3");
	g_szTkjbHumanMP3FileList			      =cfg.readEntry("TkjbHumanMP3FileList","");
	g_szTkjbCompressedHumanMP3FileList	=cfg.readEntry("TkjbCompressedHumanMP3FileList","");
	g_szTkjbDefaultListenNick			      =cfg.readEntry("TkjbDefaultListenNick","");
	g_bTkjbSendCompressedFile 			    =cfg.readBoolEntry("TkjbSendCompressedFile",true);
	
	tmp = cfg.readEntry("TkjbActiveChanList","");
	while (tmp.hasData())
	{
		tmp.getToken(chan,',');
		chan.stripWhiteSpace();
		if (chan.hasData()){
			g_ActiveChanList.append(new QString(chan.ptr()));
		}
	}
	
}

// Save Plugin State
void tkjbSaveState(void)
{
	KviStr fName,tmp;
	kvirc_plugin_get_config_file_path(fName,"TkJb");
	KviConfig cfg(fName.ptr());
	
	
	cfg.writeEntry("TkjbActivateOnStartup",g_bTkjbActivateOnStartup);
	cfg.writeEntry("TkjbAutoVoiceServers",g_bTkjbAutoVoiceServers);
	cfg.writeEntry("TkjbRelativeRootPath",g_szTkjbRelativeRootPath.ptr());
	cfg.writeEntry("TkjbHumanMP3FileList",(const char *)g_szTkjbHumanMP3FileList);
	cfg.writeEntry("TkjbCompressedHumanMP3FileList",(const char *)g_szTkjbCompressedHumanMP3FileList);
	cfg.writeEntry("TkjbDefaultListenNick",g_szTkjbDefaultListenNick.ptr());
	cfg.writeEntry("TkjbSendCompressedFile",g_bTkjbSendCompressedFile);
	
	tmp="";
	for(QString * s = g_ActiveChanList.first();s;s=g_ActiveChanList.next()){
		if(tmp.hasData())tmp.append(',');
		tmp.append((const char *)*s);
	}
	cfg.writeEntry("TkjbActiveChanList",tmp.ptr());

}

// Make the File List
void tkjbMakeList(KviPluginCommandStruct *cmd)
{
	QDir d = QDir::home();
	
	QString cdir(g_szTkjbRelativeRootPath.ptr());
	if (!d.cd(cdir)) {
		// Failed changing directory...
		// do something meaninful
	}
	else {
		tkjbEnumFilesToList(&d,cmd);
	}
	
	g_TkjbMP3List.sort();
	cmd->console->output(KVI_OUT_INTERNAL,"TkJb: Done making list! %d files were added to the list",
											 g_TkjbMP3List.count());
											
	QString fn;
	QDate dt(QDate::currentDate());
	fn.sprintf("%s/%s/%s[%d-%d-%d]-mm.",(const char *)QDir::homeDirPath(),
						 g_szTkjbRelativeRootPath.ptr(),
						 g_szTkjbDefaultListenNick.ptr(),
						 dt.month(),dt.day(),dt.year());

	g_TkjbMP3List.makeHumanList(fn,g_szTkjbDefaultListenNick.ptr());
	g_szTkjbHumanMP3FileList = fn + "txt";
	g_szTkjbCompressedHumanMP3FileList = fn + "zip";
}


/////////////////////////////////////////////////////////////////////
// Registered Commands

// tkjb
bool tkjb_plugin_command_tkjb(KviPluginCommandStruct *c)
{
//#warning "Set error for bad command. And display usage"
	// return false if failed and set the error code.  See plugin.h
	
	if (c->params->count() != 2) {
		return false;
	}
	else if (stricmp(pp(c,1),"on") == 0){
		tkjbActivate(c);
	}
	else if (stricmp(pp(c,1),"off") == 0){
		//deactivate
	}
	else if (stricmp(pp(c,1),"list") == 0){
		tkjbMakeList(c);
	}
	
	return true;
}


/////////////////////////////////////////////////////////////////////
// Event Hooks

// CTCP
bool tkjb_plugin_event_onctcp(KviPluginCommandStruct *cmd)
{
	if (qstricmp(pp(cmd,4),"MP3") == 0) {
		if (!g_bTkjbActive) return true;
		KviChannel * chan = cmd->frame->findChannel(pp(cmd,3));
		if (chan->isVoice(pp(cmd,1)) || chan->isOp(pp(cmd,1)));
		else {
			cmd->sock->sendFmtData("NOTICE %s :Thank you, %s for playing your tunes here in %s!!! Thank You for sharing !",
									pp(cmd,1),pp(cmd,1),pp(cmd,3));
			if (g_bTkjbAutoVoiceServers && chan->isMeOp()) {
				cmd->sock->sendFmtData("MODE %s +v %s",pp(cmd,3),pp(cmd,1));
			}
		}
		return true;	
	}
	else if (qstricmp(pp(cmd,4),"SLOTS") == 0) {
		// Don't forget to do something meaningful here.
		return true;
	}
			
	return false;
}

// OnMeNick
bool tkjb_plugin_event_onmenick(KviPluginCommandStruct *cmd)
{
	g_szMyNick = pp(cmd,3);
	return false;
}

// OnChannelMessage
bool tkjb_plugin_event_onchannelmessage(KviPluginCommandStruct *cmd)
{
	if (g_bTkjbActive && isActiveChannel(cmd)){
		if (qstrncmp(pp(cmd,3),"!",1) == 0){
      if (qstricmp(pp(cmd,3)+1,g_szTkjbDefaultListenNick.ptr())== 0 || qstricmp(pp(cmd,3)+1,g_szMyNick.ptr()) == 0){
        QString s;
        for (int i=4;i < ((int)cmd->params->count());i++){
          s += pp(cmd,i);
          s += " ";
        }
        s.stripWhiteSpace();
        cmd->sock->sendFmtData("NOTICE %s :Under normal circumstances I would send you %s, but I am under development!",
        pp(cmd,1),(const char *)s);
      }    
    }
	
	}
	return false; // never block channel messages!
}

//#warning "Hook OnIRC - Activate if necessary"

/////////////////////////////////////////////////////////////////////
// Required Plugin Interface stuff

// init routine: Registers the command MYDIALOG
bool tkjb_plugin_init(KviPluginCommandStruct *cmd)
{
	tkjbLoadState();
	
	kvirc_plugin_add_hook(cmd->handle,KviEvent_OnCTCP,tkjb_plugin_event_onctcp);
	kvirc_plugin_add_hook(cmd->handle,KviEvent_OnMeNick,tkjb_plugin_event_onmenick);
	kvirc_plugin_add_hook(cmd->handle,KviEvent_OnChannelMessage,
						  tkjb_plugin_event_onchannelmessage);
	kvirc_plugin_register_command(cmd->handle,"tkjb",tkjb_plugin_command_tkjb);
	return true; // success
}

// cleanup routine: don't forget to delete the objects you have created :)
void tkjb_plugin_cleanup()
{
	// Do necessary deactivation.
	tkjbSaveState();
	g_TkjbMP3List.clear();
	if(dlg) {
		delete (dlg);
		dlg =0;
	}

	kvirc_plugin_unregister_meta_object("TkJbConfig");
}


//Documentation help page
//#warning "Make some real documentation would ya!"
/*
	@document: doc_plugin_tkjb.kvihelp
	@title: The TkJb plugin
		This plugin is an MP3 JukeBox.<br>
		<docsubtitle>Note</docsubtitle>
		
		Hooks the CTCP event.  If it is of type <b>MP3</b> it will Voice the nick.<br>
		Exports the <b>tkjb</b> command with the following options:
		<ul>
			<li><i>on</i> will activates ther server</li>
			<li><i>off</i> will deactivate the server</li>
			<li><i>list</i> creates the list of files you have available for download</li>
		</ul>
		ToDo : Add documentation
		Thanks to <b>Pragma</b> creating such a versitile irc client.  If you have any suggestions
		or bug reports please email me Jason "<b>TimeKeeper</b>" Cohen at
		&lt;<i>timekepr@steltek.com</i>&gt;.
		
		
*/

// Tells Kvirc where to find the help page.
void tkjb_plugin_help()
{
	kvirc_plugin_show_help_page("doc_plugin_tkjb.kvihelp");
}

// Plugin definition structure
KviPlugin kvirc_plugin =
{
	"tkjb" ,									// place here the name of your plugin. (it should the same as the library name)
	"TkJb - TimeKeeper's MP3 JukeBox" ,			// place here an one line description of your plugin
	TKVERSION ,								  	// place there the version of your plugin
	"Jason A. Cohen <timekepr@steltek.com>" , 	// place here your name and e-mail
	"This program is an MP3 JukeBox" ,        	// place here a short description of what your plugin does
	tkjb_plugin_init ,                        	// init routine
	tkjb_plugin_cleanup ,                     	// cleanup routine
	tkjb_plugin_config ,                      	// configuration routine
	tkjb_plugin_help                          	// plugin help helper :)
};


//////////////////////////////////////////////////////////////////
// Internal Procedures


// Are we supposed to be listening to this channel?
static bool isActiveChannel(KviPluginCommandStruct *c)
{
	for(QString * s=g_ActiveChanList.first();s;s=g_ActiveChanList.next()){
		if(qstricmp(c->window->caption(),(const char *)*s) == 0) return true;
	}
	return false;
	
}

// bring up the config dialog
void tkjb_plugin_config(void)
{
	if (!dlg)
		dlg= new TkJbConfig();
	dlg->show();
}

// Activation..  Things to do when activated
//#warning "We need deactivation too."

void tkjbActivate(KviPluginCommandStruct *cmd)
{
//	#warning "Check to see if we are connected"
	// Set Volitile State stuff
	// Set global for nick
	g_szMyNick = cmd->frame->m_global.szCurrentNick.ptr();
	
	if (g_szTkjbDefaultListenNick.isEmpty()){
		tkjb_plugin_config();
		g_bTkjbActive = false;
		return;
	}
	if (g_szTkjbHumanMP3FileList.isEmpty() || !g_TkjbMP3List.count()){
		cmd->window->output(KVI_OUT_ERROR,"There is no file list to serve!");
		g_bTkjbActive = false;
		return;
	}
	g_bTkjbActive = true;
}

// This emumerates the params from a KviPluginCommandStruct to the console window.
// The only thing it is good for is to help while writing code.
// Maybe I should make another plugin that hooks every event and does this as a utility for people.
// Just an idea.
void enumparams(KviPluginCommandStruct *cmd,const char *from)
{
	cmd->console->output(KVI_OUT_INTERNAL,from);
	for (int i =0; i < ((int)cmd->params->count());i++) {
		cmd->console->output(KVI_OUT_INTERNAL,"Param %d is %s",i,pp(cmd,i));
	}
}

// Enumerate the files into the list

void tkjbEnumFilesToList(QDir *d,KviPluginCommandStruct *c)
{
	const QFileInfoList* fil;
	QDir nextdir;
	
	d->setFilter(QDir::Files);
	d->setNameFilter("*.mp?");
	fil = d->entryInfoList();
	QFileInfoListIterator it(*fil);
	
	for ( QFileInfo* fi = it.toFirst(); it != 0; ){
		g_TkjbMP3List.append(new TkjbMP3File(fi));
		fi = ++it;
	}
	d->setFilter(QDir::Dirs);
	d->setNameFilter("");
	fil = d->entryInfoList();
	
	for ( QFileInfo * fi = it.toFirst(); it != 0; ){
		if (fi->fileName() == "." || fi->fileName() == "..")
			; // nothing
		else if (fi->isDir()){
			nextdir = fi->absFilePath();
			tkjbEnumFilesToList(&nextdir,c);
		}
		fi = ++it;
	}
}


//----------------------------------------------------------------
// I can't ssem to get this to work as multiple file so...
// I am putting it in one for now. I have to figure this out.
// All of this stuff should be in tkjbmp3file.cpp

// Yap - This is what we talked about.


#include <qtextstream.h>

inline int TkjbMP3FileList::compareItems(QCollection::Item f1,QCollection::Item f2)
{
	return qstrcmp((const char*) ((TkjbMP3File*)f1)->m_pfi->fileName(),
								 (const char*) ((TkjbMP3File*)f2)->m_pfi->fileName());
}
//#warning "Check for existance of Human File and confirm overwrite."
//#warning "trap for errors"
bool TkjbMP3FileList::makeHumanList(QString& fn,const char * nick)
{
	QFile f;	
	QString txt,zip;
	
	txt = fn + "txt";
	zip = fn + "zip";
	
	f.setName(txt);
	f.open(IO_WriteOnly);
	QString hdr,tmp,tmp2;
	QTextStream ts(&f);
	QTextOStream h(&hdr);
	int n = 102;
	
	tmp.sprintf("-{( List of %s's MP3 files )}-",nick);
	tmp2.fill(' ',(n - tmp.length())/2);
	h << tmp2 << tmp << "\r\n\r\n";
	tmp.sprintf("Last Updated on %s by TkJb %s",
	 					 (const char *)QDateTime::currentDateTime().toString(),
	 					 TKVERSION);
	 					
	tmp2.fill(' ',(n - tmp.length())/2);
	h << tmp2 << tmp << "\r\n"; 					
	 					
	tmp="http://www.kvirc.net";
	tmp2.fill(' ',(n - tmp.length())/2);
	h << tmp2 << tmp << "\r\n\r\n";
	
	h << "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" \
	     "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\r\n\r\n" \
		   "To grab a file from me, type !Mynick Exact_Filename or copy/paste a " \
		   "corresponding line in Channel\r\n\r\n" \
		   "e.g., !" << nick << " (Rush)-2112_02_A_Passage_to_Bankok.mp3\r\n\r\n" \
			 "-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-" \
		   "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\r\n\r\n";
	ts << hdr;
	
	for (first();current();next()){
		ts << "!"
			 << nick
			 << " "
			 << current()->m_pfi->fileName()
			 << "\r\n";	
	}
	f.flush();
	f.close();
	
	if (g_bTkjbSendCompressedFile)
	{
		tmp2.sprintf("zip %s %s",(const char *)zip,(const char *)txt);
		system((const char *)tmp2);
	}
	return true;
}

// End the insanity
//------------------------------------------------------------------------------------------------


////////////////////////////////////////////////////////////////
// This is the config dialog
// We'll get to this later...  At this point it is still
// just the mydialog plugin example.
//

//#warning Actually create a config dialog!
TkJbConfig::TkJbConfig(void)
:QDialog(0,"tkjb")
{
	setCaption("TkJb");
	//m_pWin=cmd->window;
	//QGridLayout *g = new QGridLayout(this,4,2);
	//m_pE1 = new QLineEdit(this);
	//m_pE2 = new QLineEdit(this);
	//m_pE3 = new QLineEdit(this);
	//g->addMultiCellWidget(m_pE1,0,0,0,1);
	//g->addMultiCellWidget(m_pE2,1,1,0,1);
	//g->addMultiCellWidget(m_pE3,2,2,0,1);

	//QPushButton *b = new QPushButton("test",this,"Tkjb_testbutton");
	//connect(b,SIGNAL(clicked()),this,SLOT(btn_pressed()));
	//g->addWidget(b,3,0);

	//b = new QPushButton("btn2",this,"Tkjb_testbutton");
	//connect(b,SIGNAL(clicked()),this,SLOT(btn2_pressed()));
	//g->addWidget(b,3,1);
}

//void TkJbConfig::btn_pressed()/
//{
//}

//void TkJbConfig::btn2_pressed()
//{
//}


TkJbConfig::~TkJbConfig()
{
}

#include "m_libkvitkjb.moc"
