// =============================================================================
//
//      --- kvi_locale.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//                 2004 Robin Verduijn (robin@debian.org)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviLocale"

#define _KVI_LOCALE_CPP_

#include "kvi_settings.h"
#ifdef COMPILE_LOCALE_STUFF

#include <libintl.h>

#include "kvi_application.h"
#include "kvi_debug.h"
#include "kvi_locale.h"
#include "kvi_string.h"

static KviTranslator *g_pTranslator = 0;

char *kvi_getLocaleName()
{
	return setlocale(LC_MESSAGES, "");
}

bool kvi_initLocale(KviApplication *app)
{
	setlocale(LC_CTYPE, "");
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	// Unfortunately, kvirc is not completely UTF-8 enabled yet:
	bind_textdomain_codeset(PACKAGE, "LATIN1");

	g_pTranslator = new KviTranslator(app, "kvirc_translator");
	app->installTranslator(g_pTranslator);

	return true;
}

void kvi_destroyLocale(KviApplication *app)
{
	if( g_pTranslator ) {
		if( app ) app->removeTranslator(g_pTranslator);
		delete g_pTranslator;
		g_pTranslator = 0;
	}
}

KviTranslator::KviTranslator(QObject *parent, const char *name)
	: QTranslator(parent, name)
{
	// Nothing here
}

KviTranslator::~KviTranslator()
{
	// Nothing here
}

QString KviTranslator::find(const char *, const char *message) const
{
	const char *tr = gettext(message);
	return tr ? _CHAR_2_QSTRING(tr) : QString::null;
}

#include "m_kvi_locale.moc"

#else // COMPILE_LOCALE_STUFF

static const char *kvi_getLocaleName()
{
	return "en";
}

bool kvi_initLocale(KviApplication *, const char *)
{
	debug("This program was build without locale support.");
	return false;
}

void kvi_destroyLocale(KviApplication *)
{
	// Nothing here
}

#endif // COMPILE_LOCALE_STUFF
