#ifndef _KVI_OPTIONSWIDGET_H_INCLUDED_
#define _KVI_OPTIONSWIDGET_H_INCLUDED_

// =============================================================================
//
//      --- kvi_optionswidget.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qframe.h>

class KviOptionsWidget : public QFrame
{
	Q_OBJECT
public:
	KviOptionsWidget(QWidget *parent, int id);
	~KviOptionsWidget();
protected:
	int m_id;
public:
	virtual void commitChanges();

	void commitFileSelectors();
	void commitIpSelectors();
	void commitColorSelectors();
	void commitFontSelectors();
	void commitImageSelectors();
};

#define KVI_GENERAL_OPTIONS_WIDGET_ID_NONE                0
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DEFAULTMESSAGES     1
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMESSAGES        2
#define KVI_GENERAL_OPTIONS_WIDGET_ID_REDIRECTIONS        3
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPPROTECTION      4
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CTCPMULTIMEDIA      5
#define KVI_GENERAL_OPTIONS_WIDGET_ID_VIEW                6
#define KVI_GENERAL_OPTIONS_WIDGET_ID_INPUT               7
#define KVI_GENERAL_OPTIONS_WIDGET_ID_LOGGING             8
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DIRBROWSER          9
#define KVI_GENERAL_OPTIONS_WIDGET_ID_OUTPUT             10
#define KVI_GENERAL_OPTIONS_WIDGET_ID_MIMETYPES          11
#define KVI_GENERAL_OPTIONS_WIDGET_ID_PLUGINS            12
#define KVI_GENERAL_OPTIONS_WIDGET_ID_IRCMISC            13
#define KVI_GENERAL_OPTIONS_WIDGET_ID_INTERFACEMISC      14
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCGENERAL         15
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCCHAT            16
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCSEND            17
#define KVI_GENERAL_OPTIONS_WIDGET_ID_DCCVOICE           18
#define KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER       19
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMDI             20
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIINPUT           21
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUILABELS          22
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP            23
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUILISTBOX         24
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT          25
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMIRCCOLORS      26
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIMESSAGES        27
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUISYSTRAY         28
#define KVI_GENERAL_OPTIONS_WIDGET_ID_GUIGLOBAL          29
#define KVI_GENERAL_OPTIONS_WIDGET_ID_CHARSETTRANSLATION 30

#endif // _KVI_OPTIONSWIDGET_H_INCLUDED_
