#ifndef _KVI_POPUPEDITOR_H_INCLUDED_
#define _KVI_POPUPEDITOR_H_INCLUDED_

// =============================================================================
//
//      --- kvi_popupeditor.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

class KviComboBox;
class KviLineEdit;
class KviListView;
class KviListViewItem;
class KviPopupListViewItem;
class KviPopupMenu;
class KviUserPopupMenu;
class KviScriptEditor;

typedef struct _KviPopupClipboardItem KviPopupClipboardItem;

class KviPopupEditor : public QWidget
{
	Q_OBJECT
public:
	KviPopupEditor(QWidget *parent, const char *name = 0);
	~KviPopupEditor();
public:
	KviUserPopupMenu      *m_pConsolePopup;
	KviUserPopupMenu      *m_pChannelPopup;
	KviUserPopupMenu      *m_pQueryPopup;
	KviUserPopupMenu      *m_pUserlistPopup;
	KviUserPopupMenu      *m_pNotifylistPopup;
	KviUserPopupMenu      *m_pDccChatPopup;
	KviUserPopupMenu      *m_pEditedMenu;
	KviListView           *m_pPopupView;
	KviComboBox           *m_pPopupsBox;
	KviPopupMenu          *m_pPopupPopup;
	KviScriptEditor       *m_pPopupEditor;
	KviPopupMenu          *m_pIconPopup;
	KviLineEdit           *m_pPopupIconEditor;
	KviLineEdit           *m_pPopupNameEditor;
	KviPopupListViewItem  *m_pEditedPopupItem;
	KviPopupClipboardItem *m_pClipboardItem;
protected:
	KviPopupListViewItem *pasteClipboard(
		KviPopupListViewItem *parent, KviPopupListViewItem *after, KviPopupClipboardItem *, bool bNullAfter = false
	);
	void destroyClipboardItem(KviPopupClipboardItem *);
	void destroyClipboard();
	void saveMenu(KviUserPopupMenu *);
	bool selectPopupItemById(KviPopupListViewItem *parent, int id);
	void startEditPopup(KviUserPopupMenu *);
	void disablePopupEditors();
	void appendChildPopup(KviPopupListViewItem *parent, KviUserPopupMenu *);
	void savePopupItem(KviPopupListViewItem *);
	void saveSubmenu(KviUserPopupMenu *, KviPopupListViewItem *);
public:
	void commit();
	bool eventFilter(QObject *, QEvent *);
protected slots:
	void removeEditedPopupItem();
	void popupViewRightButtonPressed(KviListViewItem *, const QPoint &p, int);
	void copyItem();
	void iconPopupActivated(int id);
	void addEmptyPopupItem();
	void pasteItemBelow();
	void pasteItemInside();
	void pasteItemAbove();
	void addEmptyPopupItemAbove();
	void addSubmenuItemAbove();
	void addSeparatorItemAbove();
	void addEmptyPopupItemInside();
	void addSubmenuItemInside();
	void addSubmenuItem();
	void addSeparatorItem();
	void testCurrentPopup();
	void clearCurrentPopup();
	void testPopupSlot(int id);
	void popupComboSelectionChanged(int index);
	void popupItemSelected(KviListViewItem *);
};

#endif // _KVI_POPUPEDITOR_H_INCLUDED_
