#ifndef _MP_XMMSINTERFACE_H_
#define _MP_XMMSINTERFACE_H_
//=============================================================================
//
//   File : mp_xmmsinterface.h
//   Created on Fri 25 Mar 2005 20:04:54 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2005 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "mp_interface.h"


#ifndef COMPILE_ON_WINDOWS
	class KviXmmsInterface : public KviMediaPlayerInterface
	{
	public:
		KviXmmsInterface();
		virtual ~KviXmmsInterface();
	public:
		virtual int detect(bool bStart);
		virtual bool prev();
		virtual bool next();
		virtual bool play();
		virtual bool stop();
		virtual bool pause();
		virtual bool quit();
		virtual bool jumpTo(int &iPos);
		virtual bool setVol(int &iVol);
		virtual int getVol();
		virtual KviMediaPlayerInterface::PlayerStatus status();
		virtual QString nowPlaying();
		virtual bool playMrl(const QString &mrl);
		virtual QString mrl();
		virtual int getPlayListPos();
		virtual int position();
		virtual int length();
		virtual bool getRepeat();
		virtual bool getShuffle();
		virtual bool setRepeat(bool &bVal);
		virtual bool setShuffle(bool &bVal);
	protected:
		bool initPlayer();
	};
	
	MP_DECLARE_DESCRIPTOR(KviXmmsInterface)
	
#endif //!COMPILE_ON_WINDOWS

#endif //!_MP_XMMSINTERFACE_H_
