#ifndef _KVI_DCC_CHATMESSAGEBOX_H_INCLUDED_
#define _KVI_DCC_CHATMESSAGEBOX_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_chatmessagebox.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_messagebox.h"
#include "kvi_string.h"

class KviFrame;

class KviDccChatMessageBox : public KviMessageBox
{
	Q_OBJECT
public:
	KviDccChatMessageBox(
		KviFrame *parent, const char *nick, const char *username, const char *host,
		unsigned long int uAddress, unsigned short uPort, bool bVoice = false
	);
	~KviDccChatMessageBox();
protected:
	virtual void done(int result);

	KviStr m_nick;
	KviStr m_username;
	KviStr m_host;

	unsigned short m_uPort;
	unsigned long  m_uAddress;
signals:
	void dccRequestAccepted(const char *nick, const char *name, const char *host, unsigned long addr, unsigned short port);
};

#endif // _KVI_DCC_CHATMESSAGEBOX_H_INCLUDED_
