#ifndef _KVI_TIPOFTHEDAY_H_INCLUDED_
#define _KVI_TIPOFTHEDAY_H_INCLUDED_

// =============================================================================
//
//      --- kvi_tipoftheday.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Till Bush (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_dialog.h"
#include "kvi_string.h"

class QCheckBox;

class KviLabel;
class KviPushButton;

class KviTipOfTheDay : public KviDialog
{
	Q_OBJECT
public:
	KviTipOfTheDay();
	~KviTipOfTheDay();

	KviLabel       *m_pLabel;
	KviPushButton  *m_pNext;
	KviPushButton  *m_pClose;
	QCheckBox      *m_pCheck;
	KviStr          m_szTips;
signals:
	void closed();
public slots:
	void doNextTip();
protected:
	virtual void resizeEvent(QResizeEvent *);
	virtual void  closeEvent(QCloseEvent *);
	virtual void done(int r);
};

#endif // _KVI_TIPOFTHEDAY_H_INCLUDED_
