// =============================================================================
//
//      --- kvi_options_gui_help.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiHelp"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_colorselector.h"
#include "kvi_fontselector.h"
#include "kvi_helpqml.h"
#include "kvi_locale.h"
#include "kvi_options_gui_help.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsGuiHelp
	@widget: Help browser GUI options
*/
KviOptionsGuiHelp::KviOptionsGuiHelp(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIHELP)
{
	QGridLayout *g = new QGridLayout(this, 9, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviColorSelector *s = new KviColorSelector(this, _i18n_("Background color:"), &(g_pOptions->m_clrHelpBack));
	g->addWidget(s, 0, 0);
	s = new KviColorSelector(this, _i18n_("Foreground color:"), &(g_pOptions->m_clrHelpFore));
	g->addWidget(s, 1, 0);
	s = new KviColorSelector(this, _i18n_("Title foreground color:"), &(g_pOptions->m_clrHelpTitle));
	g->addWidget(s, 2, 0);
	s = new KviColorSelector(this, _i18n_("Subtitle foreground color:"), &(g_pOptions->m_clrHelpSubtitle));
	g->addWidget(s, 3, 0);
	s = new KviColorSelector(this, _i18n_("Example foreground color:"), &(g_pOptions->m_clrHelpExample));
	g->addWidget(s, 4, 0);
	KviFontSelector *f = new KviFontSelector(this, _i18n_("Normal font:"), &(g_pOptions->m_fntHelpNormal));
	g->addWidget(f, 6, 0);
	f = new KviFontSelector(this, _i18n_("Fixed font:"), &(g_pOptions->m_fntHelpFixed));
	g->addWidget(f, 7, 0);

	QFrame *fr = new QFrame(this);
	g->addWidget(fr, 8, 0);
	g->setRowStretch(8, 1);
}

KviOptionsGuiHelp::~KviOptionsGuiHelp()
{
	// Nothing here
}

void KviOptionsGuiHelp::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	KviHelpQML*s = new KviHelpQML(g_pApp);
	QStyleSheet::setDefaultSheet(s);
	// TODO: should trigger updating the help windows open?
}

#include "m_kvi_options_gui_help.moc"
