/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef __UTILS_H__
#define __UTILS_H__

#include <qobject.h>
#include <qprocess.h>
#include <qvaluelist.h>
#include "kvpncconfig.h"
#include "kvpnc.h"
#include "toolinfo.h"
#include <qstringlist.h>
#include <ktempfile.h>



/**
Provides various help functions.
 
@author Christoph Thielecke
*/
class Utils : public QObject
{
	Q_OBJECT
public:
	Utils(KVpncConfig* config,QObject *parent = 0, const char *name = 0);

	~Utils();

	bool isValidIPv4Address(QString Address);
	bool isValidIPv4NetworkAddress(QString Address);
	bool isValidIPv4BroadcastAddress(QString Address);
	bool tunDevExists();
	bool createTunDev();
	bool loadKernelModule(QString Name,QApplication *app);
	bool doChmod(QString file, QString mode);
	QStringList getOpenvpnCiphers();
	QPtrList<ToolInfo>* getToolList();
	ToolInfo* getToolInfo(KVpncConfig *GlobalConfig, QString name);
	QString resolveName(QString Name);
	QString removeSpecialCharsForFilename(QString filename);
	QString getNameAndPidOfProgramListen(int port);

public slots:
	void readStdOutCreateTunDev();
	void readStdErrCreateTunDev();
	void readStdOutLoadKernelModule();
	void readStdErrLoadKernelModule();
	void readStdOutToolsTest();
	void readStdErrToolsTest();
	void readStdOutRetriveOpenvpnCiphers();
	void readStdErrRetriveOpenvpnCiphers();
	void readStdOutGetNameAndPidOfProgramListen();
	void readStdErrGetNameAndPidOfProgramListen();

private:
	bool modprobeSuccess;
	bool toolsTestSuccess;
	bool retrieveOpenvpnCiphers;
	bool retrieveNameAndPidOfProgramListen;
	QString tooltest_logfile;
	QProcess *ModprobeProcess;
	QProcess *createProcess;
	QProcess *NetworkDeviceTestProcess;
	QProcess *toolsTestProcess;
	QProcess *OpenvpnCiphersProcess;
	QProcess *NameAndPidOfProgramListenProcess;
	QString resolvedIP;
	bool resolveFinished;
	QValueList<QHostAddress> list;
	QStringList *env;
	KVpncConfig *config;
	KTempFile *tmpfile;
	bool retrieveValidNetworkdevice;
	QStringList OpenvpnCiphers;
	QString NameAndPidOfProgramListen;
	int ListenPort;
};

#endif
