/***************************************************************************
                          kwcentryedit.h  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWCENTRYEDIT_H
#define KWCENTRYEDIT_H

#include <kwcentry.h>
#include <klineedit.h>
#include <qtoolbutton.h>
#include <kiconloader.h>
#include <kglobal.h>

/**
  *@author Matthias Reif
  */
class KWCEntryEdit : public KWCEntry
{
   Q_OBJECT
public: 
	KWCEntryEdit( const QString & inscr, KSingleTabWidget *parent = 0, const char *name = 0 );
	~KWCEntryEdit();

	void setValue(const QString & value);
	QString getText();
	bool hasFocus() { return valueEdit->hasFocus(); }

protected:
	KLineEdit *valueEdit;
	QToolButton *applyButton;

public slots:
	void changedSlot( const QString & text );
	void returnPressedSlot( );

signals:
	void changed( const QString & );
	void returnPressed( const QString & );
};

#endif
