/***************************************************************************
                          kwcentryselection.cpp  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentryselection.h"

/*!
	\fn KWCEntrySelection::KWCEntrySelection( const QString & inscr, bool editable, KSingleTabWidget *parent, const char *name )
 */
KWCEntrySelection::KWCEntrySelection( const QString & inscr, bool editable, KSingleTabWidget *parent, const char *name ) : KWCEntry( inscr, parent,name )
{
	valueSelect = new KComboBox( parent );
	valueSelect->setMinimumWidth( 140 );
	valueSelect->setMaximumWidth( 180 );
	valueSelect->setMaximumHeight( inscriptionLabel->height() + 4 );
	setValueWidget( valueSelect );
	
	altLabel = new QLabel( parent );
	altLabel->hide();
	setValue2Widget( altLabel );
	
	valueSelect->setEditable( editable );
	if( editable )
	{
		applyButton = new QToolButton( parent );
		applyButton->setTextLabel( "apply", true );
		KIconLoader iconLoader;
		applyButton->setIconSet( QIconSet( iconLoader.loadIcon( "ok", KIcon::Small ) ) );
		applyButton->adjustSize();
		setRightWidget( applyButton );
		connect( applyButton, SIGNAL( clicked() ), this, SLOT( textChangedSlot() ) );
	}
	connect( valueSelect, SIGNAL( activated( int ) ), this, SLOT( textChangedSlot() ) );
	connect( valueSelect, SIGNAL( activated( int ) ), this, SLOT( itemActivatedSlot(int) ) );
}


/*!
	\fn KWCEntrySelection::~KWCEntrySelection()
 */
KWCEntrySelection::~KWCEntrySelection()
{
}


/*!
	\fn KWCEntrySelection::insertItem( const QString & text, int index )
 */
void KWCEntrySelection::insertItem( const QString & text, int index )
{
	valueSelect->insertItem( text, index );
	valueSelect->adjustSize();
}


/*!
	\fn KWCEntrySelection::setCurrentItem( int index )
 */
void KWCEntrySelection::setCurrentItem( int index )
{
	valueSelect->setCurrentItem( index );
}


/*!
	\fn KWCEntrySelection::clear()
 */
void KWCEntrySelection::clear()
{
	valueSelect->clear();
}


/*!
	\fn KWCEntrySelection::itemActivatedSlot( int index )
 */
void KWCEntrySelection::itemActivatedSlot( int index )
{
	activated( index );
}


/*!
    \fn KWCEntrySelection::setValue( QString text )
 */
void KWCEntrySelection::setValue( QString text )
{
	valueSelect->setEditText( text );
}

/*!
    \fn KWCEntrySelection::setAltLabel( QString text )
 */
void KWCEntrySelection::setAltLabel( QString text )
{
	altLabel->setText( text );
	altLabel->adjustSize();
}


/*!
    \fn KWCEntrySelection::textChangedSlot( )
 */
void KWCEntrySelection::textChangedSlot( )
{
	textChanged( valueSelect->currentText() );
}


/*!
    \fn KWCEntrySelection::contains( const QString & text )
 */
bool KWCEntrySelection::contains( const QString & text )
{
	return valueSelect->contains( text );
}


/*!
    \fn KWCEntrySelection::getCurrentItem()
 */
int KWCEntrySelection::getCurrentItem()
{
	return valueSelect->currentItem();
}
