/***************************************************************************
                          dockwidget.cpp  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dockwidget.h"
#include <qtooltip.h>
#include <klocale.h>
#include <kapp.h>
#include <qpixmap.h>
#include <qfont.h>
#include <kstddirs.h>
#include <iostream.h>
#include <kdebug.h>

dockwidget::dockwidget(QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
	connect(QPushButton_1, SIGNAL( released() ), SLOT( buttonHandler() ));
	QLabel_1->setText(I18N_NOOP("No"));
  QLabel_2->setText(I18N_NOOP("data"));
  QLabel_3->setText("...");
 	//cerr<< "\nTest: " << KGlobal::dirs()->findResource("data", "kweather/sunny.png") << endl ;
  //cerr<< locate("data", "kweather/sunny.png") << endl;
}

dockwidget::~dockwidget(){
}
/** Change the button icon */
void dockwidget::changeButtonIcon(QString newIcon, QString tipText, bool smallView){
	//cerr<< locate("", "sunny.png") << endl;
// 	cerr<< "\nTest: " << KGlobal::dirs()->findResource("data", "kweather/dunno.png") << endl ;
	//cerr << newIcon << endl;
	QString theImage = "kweather/" + newIcon + ".png";
	QPushButton_1->setPixmap(QPixmap(locate("data", theImage)));
	QToolTip::remove(QPushButton_1);
	if( !smallView)
		QToolTip::add(QPushButton_1,I18N_NOOP("Press Here to \nto see a weather report..."));
	else
		QToolTip::add(QPushButton_1, tipText);
}
/** relay the button pressed to the parent widget */
void dockwidget::buttonHandler(){
	emit ( buttonEvent());
}

void  dockwidget::initDialog(){
	//cerr<< "Init Dialog " << endl;
//  this->resize(80,40);
//  this->setMinimumSize(0,0);
//  this->setFixedSize(80,40);
  QPushButton_1= new QPushButton(this,"NoName");
//  QPushButton_1->setGeometry(0,0,40,40);
//  QPushButton_1->setMinimumSize(40,40);
  QPushButton_1->setPixmap(QPixmap(locate("data", "kweather/dunno.png")));

  QLabel_1= new QLabel(this,"NoName");
//  QLabel_1->setGeometry(40,0,40,12);
  //QLabel_1->setMinimumSize(40,12);
  QLabel_1->setFont(theFont);
//  QLabel_1->setMargin(1);

  QLabel_2= new QLabel(this,"NoName");
//  QLabel_2->setGeometry(40,12,40,12);
  //QLabel_2->setMinimumSize(40,12);
  QLabel_2->setFont(theFont);
//  QLabel_2->setMargin(1);

  QLabel_3= new QLabel(this,"NoName");
//  QLabel_3->setGeometry(40,24,40,12);
  //QLabel_3->setMinimumSize(40,12);
  QLabel_3->setFont(theFont);
//  QLabel_3->setMargin(1);
}
/** Set the current wind speed and direction data. */
void dockwidget::setWind( QString s){
	//cerr<< "Set wind" << endl;
	QLabel_1->setText(s);
}
/** Set the current temperature. */
void dockwidget::setTemperature( QString s){
	//cerr<< "Set temp" << endl;
	QLabel_2->setText(s);
}
/** Set the current pressure. */
void dockwidget::setPressure( QString s){
	//cerr<< "Set pressure " << endl;
	QLabel_3->setText(s);
}
  /** resize the view **/
void dockwidget::resizeView( int x, int y, bool iconOnly)
{
	kdDebug() << "Changeing to size " << x << "," << y << endl;
	this->resize (y,x);

	kdDebug() << "x+2 " << int(x+2) << endl;
	kdDebug() << "x/3 " << int(x/3) << endl;
	kdDebug() << "y/2 " << int(y/2) << endl;
	kdDebug() << "2*x/3 " << int(2*x/3) <<  endl;
	int x1 = int(x+2);
	int y1 = 0;
	int y2 = y;
	int x2 = x;
	if (y < 80)
	{
		x1 = 0;
		x2 = y;
		y1 = y;
		y2 = x;
	}
	QPushButton_1->resize(x2,x2);
	QLabel_1->setGeometry(x1,y1,int(y2/2),int(x2/3));
	QLabel_2->setGeometry(x1,y1+int(x2/3),int(y2/2),int(x2/3));
	QLabel_3->setGeometry(x1,y1+int(2*x2/3),int(y2/2),int(x2/3));

	if( !iconOnly )
	{	
		this->resize(x,x);
		QLabel_1->hide();
		QLabel_2->hide();
		QLabel_3->hide();
	}
	else
	{
		QLabel_1->show();
		QLabel_2->show();
		QLabel_3->show();		
	}
}
void dockwidget::updateFont(QFont newFont)
{
	theFont = newFont;
  QLabel_1->setFont(theFont);
  QLabel_2->setFont(theFont);
  QLabel_3->setFont(theFont);
} 
#include "dockwidget.moc"
