/***************************************************************************
                          kweather.cpp  -  description
                             -------------------
    begin                : Wed Jul  5 23:09:02 CDT 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kweather.h"
#include <qmessagebox.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qdatetime.h>
#include <kglobal.h>
#include <klocale.h>
#include <kurl.h>
#include <kapp.h>
#include <kaboutdialog.h>
#include <kdebug.h>
#include "reportview.h"
extern "C"
{
     KPanelApplet* init(QWidget *parent, const QString& configFile)
    {
         KGlobal::locale()->insertCatalogue("kweather");
         kweather *theApplet = new kweather(configFile, KPanelApplet::Normal,
                       KPanelApplet::About | KPanelApplet::Help | KPanelApplet::Preferences,
                       parent, "kweather");
				 return theApplet;
    }
}

kweather::kweather(const QString& configFile, Type t, int actions, QWidget *parent, const char *name):
									 KPanelApplet(configFile, t, actions, parent, name)
									#ifdef dcop_iface
									,DCOPObject("weatherIface")
									#endif
	
{
		kdDebug() << "Constructor " << endl;
		firstrun = false;
	  p = new dockwidget(this, "test");
		p->show();
		weather = new weatherlib();
		connect(p, SIGNAL( buttonEvent() ), SLOT( getButtonEvent() ));
		loadPrefs();
		kdDebug() << "Setting Timer..." << endl;
		timeOut = new QTimer(this, "timeOut" );
    timeOut->changeInterval(LCD_Value*60000);
		connect(timeOut, SIGNAL( timeout()), this, SLOT( timeout()));
#ifdef dcop_iface
    theClient = new DCOPClient();
		theClient->registerAs(name);
#endif
	emit (updateLayout());
	  if(firstrun)
	  	preferences();
		else
			timeout();

}

kweather::~kweather()
{
}
/** about box */
void kweather::about(){
	kdDebug() << "Telling about" << endl;
	KAboutDialog *about = new KAboutDialog();
	about->setAuthor("Ian Reinhart Geiser",
										"geiseri@users.sourceforge.net",
									  "http://kweather.sourceforge.net",
										"Weather Applet for the kicker");
	about->addContributor("Will Andrews",
										"wca@users.sourceforge.net",
									  "http://kweather.sourceforge.net",
										"Fixed for BSD port");
	about->addContributor("Ben Burton", "benb@acm.org","","Debian fixes");
	about->setLogo(QPixmap(locate("data", "kweather/sunny.png")));
	about->setVersion( "2.99" );

	about->show();
	delete about;
	
}
/** prefs */
void kweather::preferences(){
	kdDebug() << "prefs" << endl;
	prefsDialog *prefs = new prefsDialog();
	prefs->setLocation(reportLocation );
	prefs->setFileName( FileName );
	prefs->setGMT_Offset(GMT_Offset);
	prefs->setLCD_Value(LCD_Value);
	prefs->setMetricMode(MetricMode);
	prefs->setOffLineMode(OffLineMode);
	prefs->setSmallView(smallviewMode);	
	prefs->setFont(theFont);
	if (prefs->exec())
	{
		timeOut->stop();
		kdDebug() << prefs->getReportLocation() << endl;
		kdDebug() << prefs->getGMT_Offset() << endl;
		kdDebug() << prefs->getLCD_Value() << endl;
		kdDebug() << prefs->getFileName() << endl;
		kdDebug() << prefs->getMetricMode() << endl;
		kdDebug() << prefs->getOffLineMode() << endl;
		reportLocation = prefs->getReportLocation();
		GMT_Offset = (prefs->getGMT_Offset()).toInt();
		LCD_Value = prefs->getLCD_Value();
		FileName = prefs->getFileName();
		MetricMode = prefs->getMetricMode();
		OffLineMode = prefs->getOffLineMode();
		smallviewMode = (bool)prefs->getSmallView();
		theFont = prefs->getFont();
        emit (updateLayout()); 
	p->updateFont(theFont);
    timeOut->start(100);
	}
	delete prefs;
	savePrefs();
}
/** Get the button event from the child widget */
void kweather::getButtonEvent(){
	kdDebug() << "Button was pressed" << endl;
	doReport();
}
/** The help handler */
void kweather::help(){

  kapp->invokeHelp(QString::null, QString::fromLatin1("kweather"));
	//kapp->invokeHTMLHelp (locate("HTML", "kweather/index.html") );
}
/** Display the current weather report. */
void kweather::doReport(){

	kdDebug() << "Printing out the report" << endl;
	reportView *theReport = new reportView(0, "Current Weather Report");
        theReport->setTemp(weather->getTemp());
				theReport->setPressure( weather->getPressure());
				theReport->setWindData( weather->getWindData());
				theReport->setTime( weather->getTime());
				theReport->setDate( weather->getDate(GMT_Offset));
				theReport->setCurrent( weather->getWeatherText());
				theReport->setIcon( weather->getCurrent());
				//theReport->setOffset( GMT_Offset );
	theReport->render();
	if (theReport->exec()){
		kdDebug() << "looks good" << endl;
		delete theReport;
	}
}
/** load the application prefs */
void kweather::loadPrefs(){
	kdDebug() << "Loading Prefs" << endl;
	kcConfig = config();
	if (!kcConfig->hasGroup ("General Options") )
		firstrun = true;	
	kcConfig->setGroup("General Options");
	FileName = kcConfig->readEntry("log_file_name", "");
	reportLocation = kcConfig->readEntry("report_location", "none");
	GMT_Offset = kcConfig->readNumEntry("gmt_offset", 0);
  LCD_Value = kcConfig->readNumEntry("timout_value", 60);
	MetricMode = kcConfig->readNumEntry("metric_mode", 0);
	OffLineMode = kcConfig->readNumEntry("offline_mode", 1);
	smallviewMode = kcConfig->readNumEntry("smallview_mode", 0);
	theFont = kcConfig->readFontEntry("dock_font", new QFont("helvetica", 8, 50));
	emit (updateLayout()); 
	p->updateFont(theFont);
}
/** Save the application prefs. */
void kweather::savePrefs(){
	   kdDebug() << "Saving Prefs..." << endl;
		 kcConfig->setGroup("General Options");
     kcConfig->writeEntry( "report_location", reportLocation);
		 kcConfig->writeEntry( "gmt_offset", GMT_Offset);
		 kcConfig->writeEntry( "timout_value", LCD_Value);
		 kcConfig->writeEntry( "metric_mode", MetricMode);
	   kcConfig->writeEntry( "offline_mode", OffLineMode);
		 kcConfig->writeEntry( "smallview_mode", smallviewMode);
		 kcConfig->writeEntry( "log_file_name", FileName );
		 kcConfig->writeEntry( "dock_font", theFont);
		 kcConfig->sync();
}	

void kweather::downloadData( KIO::Job *, const QByteArray &data)
{
	metarData += data;
}

/** Load the data into the current memory */
void kweather::loadFile( KIO::Job *aJob){
 // data
 if (!aJob->error())
 {
	  weather->processData(metarData, MetricMode);
    p->setPressure(weather->getPressure());
    p->setWind(weather->getWindData());
    p->setTemperature(weather->getTemp());
    curTemp = weather->getTemp();
		QString weatherData = "Wind Speed & Direction: " + weather->getWindData();
		weatherData += "\nTemperature: " + weather->getTemp();
		weatherData += "\nAir Pressure: " + weather->getPressure();
    p->changeButtonIcon( weather->getCurrent(), weatherData, smallviewMode);
		if (FileName != "")
    {
  		kdDebug()<< "Try log file..." << FileName << endl;
      QFile logFile(FileName);
      QTextStream logFileStream( &logFile );
      if ( !logFile.exists ())
      {
       if ( logFile.open(IO_WriteOnly) )
       {
        logFileStream << endl;
        logFileStream << "Date,Wind Speed & Wind Direction,Temperature,Pressure,Cover,Visability,Current Weather" << endl;
				logFileStream << weather->getDate(GMT_Offset);
        logFileStream << " ";
				//logFileStream << weather->getTime();
				//logFileStream << ",";
        logFileStream << weather->getWindData();
        logFileStream << ",";
        logFileStream << weather->getTemp();
        logFileStream << ",";
        logFileStream << weather->getPressure();
        logFileStream << ",";
        logFileStream << weather->getCover();
        logFileStream << ",";
        logFileStream << weather->getVisability();
        logFileStream << ",";
        logFileStream << weather->getCurrentText();
        logFileStream << endl;

            logFile.close(); //jwc
            QMessageBox::critical( this, "KWeather Message:",
               "Just opened logFile mode IO_WriteOnly,\n"
               "wrote to log file, and closed.");
       }
       else
       {
               kdDebug()<< "There was an error opening the file...." << endl;
               QMessageBox::critical( this, "KWeather Error:",
               "For some reason I could not create a new log file\n"
               "Please check to see if your disk is full or if you\n"
               "have write access to the location you are trying to\n"
               "write to.");
       }
      }
      else if ( logFile.open(IO_Append | IO_ReadWrite ) )
      {
        //	we got the csv file so lets try to write out data...
				logFileStream << weather->getDate(GMT_Offset);
        //logFileStream << " ";
				//logFileStream << weather->getTime();
				logFileStream << ",";
        logFileStream << weather->getWindData();
        logFileStream << ",";
        logFileStream << weather->getTemp();
        logFileStream << ",";
        logFileStream << weather->getPressure();
        logFileStream << ",";
        logFileStream << weather->getCover();
        logFileStream << ",";
        logFileStream << weather->getVisability();
        logFileStream << ",";
        logFileStream << weather->getCurrentText();
        logFileStream << endl;

      }
			else
			{
        QMessageBox::critical( this, "KWeather Error:",
        "For some reason I could not write to the log file\n"
        "Please check to see if your disk is full or if you\n"
        "have write access to the location you are trying to\n"
        "write to.");
			}
			logFile.close();
		}
 }
 else
 {
  aJob->showErrorDialog();
 }
// disconnect(loadFile());
// delete theJob;
	kdDebug() << "Finished loadfile, restarting the clock" << endl;
 timeOut->start(LCD_Value*60000);
}
/** get new data */
void kweather::timeout(){
	kdDebug()<< "Times up..." << endl;
        timeOut->stop();
	QString url;

  if ( !OffLineMode )
        {
                url = "ftp://weather.noaa.gov/data/observations/metar/stations/";
                url += reportLocation;
                url += ".TXT";
		metarData = QString::null;
		theJob = KIO::get(url, true, false);
		connect(theJob, SIGNAL(data(KIO::Job *, const QByteArray &)), SLOT(downloadData(KIO::Job *, const QByteArray &)));
		connect( theJob, SIGNAL( result( KIO::Job *)), this, SLOT( loadFile( KIO::Job *)));
        }
}


int kweather::widthForHeight(int i) const {
	kdDebug()<< "W4H Resize: " << i << endl;
	kdDebug() << "got " << smallviewMode << endl;
	if( smallviewMode )
	{
		
		p->resizeView(i, i, false);		
		return i;
	}
	else
	{
		p->resizeView(i, (i*2), true);
		return (i*2);
	}
}
/**  */
int kweather::heightForWidth(int i) const{
        kdDebug()<< "H4W Resize: " << i << endl;
        kdDebug() << "got " << smallviewMode << endl;
        if( smallviewMode )
        {
 
                p->resizeView(i, i, false);
                return i;
        }
        else
        {
                p->resizeView((i*2), i, true);
                return (i*2);
        }
}
/** This will return the current temperature.  This is only ment to be used through the DCOP interface. */
QString kweather::get_temperature(){   ;
	kdDebug()<< "Getting Temp" << endl;
	return weather->getTemp();
}
/** This will return the current pressure. This is only ment for the DCOP interface */
QString kweather::get_pressure(){
	kdDebug()<< "Getting PRessure" << endl;
	return weather->getPressure();
}
/** return wind info */
QString kweather::get_wind(){
	return weather->getWindData();
}
/** return current weather */
QString kweather::get_weather(){
	return weather->getCurrent();
}

void kweather::refresh()
{
	timeout();
}
#include "kweather.moc"
