#include "prefsDialog.h"
#include <qpixmap.h>
#include <kfiledialog.h>
#include <kapp.h>
#include <kdebug.h>
#include <kfontdialog.h>
prefsDialog::prefsDialog (QWidget* parent, const char* name)
	:prefsDialogData(parent, name, true)
{
    kdDebug() << "Showing GUI" << endl;
    setCaption( "KWeather Preferences" );
    ICAOlink->setText("Lookup Your ICAO Code");
    ICAOlink->setURL("http://www.nws.noaa.gov/oso/siteloc.shtml");
    connect(fileselect, SIGNAL(released()), this, SLOT(selectFile()));
    connect(time_slider, SIGNAL(valueChanged(int)), LCD_Value, SLOT(display(int)));
    connect(ICAOlink, SIGNAL(leftClickedURL(const QString&)), this, SLOT(processURL(const QString&)));
    connect(cancelbutton, SIGNAL(released()), SLOT(reject()));
    connect(okaybutton, SIGNAL(released()), SLOT(accept()));
    connect(fontbutton, SIGNAL(released()), SLOT(font()));

//    QPixmap pixmap;
//    pixmap.load("file:/opt/kde2/share/icons/lowcolor/22x22/actions/fileopen.png");
//    fileselect->setPixmap(pixmap);
}

prefsDialog::~prefsDialog()
{
}
/** handle the Okay key */
void prefsDialog::okayPressed(){

}
/** Handel the cancel button. */
void prefsDialog::cancelPressed(){

}
/** Get the report location string. */
QString prefsDialog::getReportLocation(){
	return Report_Location->text();
}
QString prefsDialog::getGMT_Offset(){
  return GMT_Offset->cleanText();
}
int prefsDialog::getLCD_Value(){
	return LCD_Value->intValue();
}
bool prefsDialog::getMetricMode(){
  return metricMode->isChecked();
}
bool prefsDialog::getOffLineMode(){
  return offlineMode->isChecked();
}
bool prefsDialog::getSmallView(){
  return smallview->isChecked();
}
QString prefsDialog::getFileName(){
  return file_name->text();
}/** Set the pref box file name to the current prefs file name. */
void prefsDialog::setFileName( QString s ){
	file_name->setText(s);
}
/** Set the GMT offset */
void prefsDialog::setGMT_Offset(int i){
	GMT_Offset->setValue( i);
}
/** Set the LCD and Slider value */
void prefsDialog::setLCD_Value(int i){
	time_slider->setValue ( i );
	LCD_Value->display(i);
}
/** Set the metric mode check box */
void prefsDialog::setMetricMode( bool b ){
		metricMode->setChecked (b);
}
/** Set the small view mode checkbox */
void prefsDialog::setSmallView( bool b){
		smallview->setChecked (b);
}
/** Set the offline mode checkbox */
void prefsDialog::setOffLineMode( bool b ){
	  offlineMode->setChecked (b);
}
/** The current report location */
void prefsDialog::setLocation( QString s ){
	Report_Location->setText( s );
}
/** Select a file from the filesystem */
void prefsDialog::selectFile(){
	 QString theName = KFileDialog::getSaveFileName ("",
		"*.csv|Comma Separated Variable Text File\n*.txt|Raw Text File\n*.*|All Files",
	 	0, "Select your log file..."); 	
	if (!theName.isEmpty())
		file_name->setText( theName );
}
/** Open Konqueror to this link. */
void prefsDialog::processURL(const QString& url){
	kapp->invokeBrowser ( url );	
}

void prefsDialog::font()
{
      int result = KFontDialog::getFont( theFont );
      samplefont->setFont(theFont); 
}

QFont prefsDialog::getFont()
{
	return theFont;
}
void prefsDialog::setFont(QFont newFont)
{
	theFont = newFont;
        samplefont->setFont(theFont); 
}
#include "prefsDialog.moc"
