#ifndef KDIALUPCONFIGDLG_H
#define KDIALUPCONFIGDLG_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kdialupconfig.h"


#define CONNECT_ISDN "ISDN"
#define CONNECT_PPPOE "PPPOE (DSL)"
#define CONNECT_ANALOG "Analog"

class SuProcessBase;
class dialupClass;

class KDialupConfigDlg : public dialupConfig
{
    Q_OBJECT

    public:
        KDialupConfigDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~KDialupConfigDlg();
        bool init(QString profile);
        dialupClass* getData()
        {
            return m_data;
        }
        /*$PUBLIC_FUNCTIONS$*/
    public slots:
        /*$PUBLIC_SLOTS$*/
        virtual void          cancel();
        virtual void          ok();
        virtual void          fillInterfaces(const QString& networkType);
        void slotNetworksChanged();
    
    signals:
        void dialupNetworksUpdated();
  

    private:
        void setData();
        dialupClass *m_data;
        QString m_profile;
        bool m_newProfile;
        
    protected:
        /*$PROTECTED_FUNCTIONS$*/

    protected slots:
        /*$PROTECTED_SLOTS$*/

};

#endif

