#ifndef KSCANDLG_H
#define KSCANDLG_H
/** KWlan
 *
 *  This File is part of KWlan, a network Manager for KDE.
 *  KWlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kscan.h"


class KWlanInterface;
class QString;
class KProcess;
class QTimer;

class KScanDlg : public KScan
{
  Q_OBJECT

public:
  KScanDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
  ~KScanDlg();
  /*$PUBLIC_FUNCTIONS$*/

public slots:
  /*$PUBLIC_SLOTS$*/
  virtual void          closeScanWindow();
  virtual void          addSelected();
  virtual void          bssSelected( QListViewItem * sel );
  virtual void          getResults();
  virtual void          scanRequest();
  virtual void          updateResults();
  virtual void          setInterface( KWlanInterface *interface );
  void iwconfigProcessExited( KProcess* process );
  void iwconfigProcessStdout( KProcess*, char* buffer, int buflen );
  void scanNonWpa();

protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/
    
private:
    KWlanInterface *m_interface;
    QTimer *m_timer;
    QString m_iwconfigStdout;
    KProcess *m_iwconfigProcess;
    void parseIwconfigOutput();
    void addScannedNetwork(QString config);

};

#endif


