/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kwlanmainsettingsdlg.h"
#include "configuration.h"

#include "qspinbox.h"
#include "qcheckbox.h"

#include <kmessagebox.h>

KwlanMainSettingsDlg::KwlanMainSettingsDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: KwlanMainSettings(parent,name, modal,fl)
{
    int res;
    KMessageBox::setDontShowAskAgainConfig(mainConfiguration().m_configuration);
    cbMinimized->setChecked(mainConfiguration().readStartMinimized());
    cbShowAvailableOnly->setChecked(mainConfiguration().readShowAvailableOnly());
    cbShowCommands->setChecked(mainConfiguration().readShowCommands());
    res = KMessageBox::shouldBeShownContinue("newinterfacewizard");
    if (res) cbNewInterfaceWizard->setEnabled(FALSE);
    res = KMessageBox::shouldBeShownContinue("dontwarnnowpa");
    if (res) cbWpaWarning->setEnabled(FALSE);
    res = KMessageBox::shouldBeShownContinue("nodialupuserwarning");
    if (res) cbDialupUserWarning->setEnabled(FALSE);
}

KwlanMainSettingsDlg::~KwlanMainSettingsDlg()
{
}


/*$SPECIALIZATION$*/
void KwlanMainSettingsDlg::Cancel()
{
    QWidget::close(true);
}

void KwlanMainSettingsDlg::Ok()
{
    mainConfiguration().writeStartMinimized(cbMinimized->isChecked());
    mainConfiguration().writeShowAvailableOnly(cbShowAvailableOnly->isChecked());
    mainConfiguration().writeShowCommands(cbShowCommands->isChecked());
    if (cbNewInterfaceWizard->isChecked())
    {
        KMessageBox::enableMessage("newinterfacewizard");
    }
    if (cbWpaWarning->isChecked())
    {
        KMessageBox::enableMessage("dontwarnnowpa");
    }
    if (cbDialupUserWarning->isChecked())
    {
        KMessageBox::enableMessage("nodialupuserwarning");
    }
    QWidget::close(true);

}



#include "kwlanmainsettingsdlg.moc"

