/***************************************************************************
                          kxe_treeview.cpp  -  description
                             -------------------
    begin                : Thu Sep 20 2001
    copyright            : (C) 2001 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kxe_treeview.h"
#include "xml_base.h"
#include "searchdlg.h"

#include <klocale.h>
#include <kdebug.h>
#include <kxmlgui.h>
#include <kxmlguiclient.h>
#include <kpopupmenu.h>

KXE_TreeView::KXE_TreeView( KXMLGUIClient * pGUIClient, QWidget * pParent, const char * pszName )
	: KListView(pParent,pszName),
	  m_pGUIClient(pGUIClient),
	  m_pDlgSearch(0),
	  m_nBookmarkCount(0)
{
	setSorting(-1); // no sorting

	addColumn(i18n("Qualified name"));
	addColumn(i18n("Namespace"));

	setSelectionMode(QListView::Single);

	connect( this, SIGNAL(selectionChanged(QListViewItem*)), this, SLOT(slotSelectionChanged(QListViewItem*)) );

	setReadWrite(false);
}

void KXE_TreeView::setReadWrite( bool fReadWrite )
{
	setItemsRenameable( fReadWrite );
	setRenameable( 0, fReadWrite );
}

//////////////////////////////////////////////////////////////
// configuration slots
//////////////////////////////////////////////////////////////

void KXE_TreeView::slotConfigRootDecorated( bool isDecorated )
{
	setRootIsDecorated(isDecorated);
}

void KXE_TreeView::slotConfigElemDisplayMode( unsigned int iMode )
{
	if ( iMode == 0 )
	{
		if ( columns() == 3 )
			removeColumn(2);
	}
	else
	{
		if ( columns() == 2 )
			addColumn( i18n("Attributes") );

		// update all XML element tree items
		XmlTreeItem * pTreeItem = 0;
		XmlElement * pXmlElement = 0;
		QListViewItemIterator it(this);
		while (it.current())
		{
			pTreeItem = static_cast <XmlTreeItem*> (it.current());
			if ( pTreeItem->itemType() == XmlTreeItem::itemElement )
			{
				pXmlElement = static_cast <XmlElement*> (pTreeItem);
				pXmlElement->updateStringAttrList();
			}

			++it;
		}

	}
}

void KXE_TreeView::slotConfigDragDrop( bool bEnable )
{
	// setAcceptDrops(bEnable); TODO later, when read/write KPart
	// viewport()->setAcceptDrops(bEnable);
}

//////////////////////////////////////////////////////////////
// action slots
//////////////////////////////////////////////////////////////

void KXE_TreeView::slotEditFind()
{
	if ( ! m_pDlgSearch )
	{
		m_pDlgSearch = new SearchDlg( this, "search dialog", true );
	}

	if ( m_pDlgSearch->exec() == SearchDlg::Accepted )
		slotEditFindNext();
}

void KXE_TreeView::slotEditFindNext()
{
	if ( ! m_pDlgSearch )
	{
		kdDebug() << "KXE_TreeView::slotEditFindNext implementation error - no search dialog" << endl;
		return;
	}

	// get selected item from tree view to start search here
	QListViewItem * pTmpItem = selectedItem();
	if ( ! pTmpItem )
	{
		// no item selected -> start with first item in this treeview
		pTmpItem = firstChild();
		if ( ! pTmpItem )
			// no items in this treeview -> return
			return;
	}

	XmlTreeItem * pTmpTreeItem = static_cast <XmlTreeItem*> (pTmpItem);

	while ( (pTmpTreeItem = pTmpTreeItem->nextItem()) != 0 )
	{
		if ( pTmpTreeItem->match(m_pDlgSearch) )
		{
			setSelected( pTmpTreeItem, true );
			setCurrentItem( pTmpTreeItem );
			ensureItemVisible( pTmpTreeItem );
			return;
		}
	}
}

void KXE_TreeView::slotEditDeselect()
{
	clearSelection();
}

void KXE_TreeView::slotViewNodeUp()
{
	// get selected item from tree view
	QListViewItem * pSelItem = selectedItem();
	if ( ! pSelItem )
	{
		kdDebug() << "KXE_TreeView::slotViewNodeUp no item selected" << endl;
		return;
	}

	// get parent item
	QListViewItem * pParentItem = pSelItem->parent();

	// select parent item in tree view
	if (pParentItem)
	{
		setCurrentItem(pParentItem);
		ensureItemVisible(pParentItem);
	}
}

void KXE_TreeView::slotViewExpNode( int nLevel )
{
	// get selected item from tree view
	QListViewItem * pSelItem = selectedItem();
	if ( ! pSelItem )
	{
		kdDebug() << "KXE_TreeView::slotViewExpNode no item selected" << endl;
		return;
	}

	// expand node
	XmlTreeItem * pSelTreeItem = static_cast <XmlTreeItem *> (pSelItem);
	pSelTreeItem->expandNode(nLevel);
}

void KXE_TreeView::slotViewColNode( int nLevel )
{
	// get selected item from tree view
	QListViewItem * pSelItem = selectedItem();
	if ( ! pSelItem )
	{
		kdDebug() << "KXE_TreeView::slotViewColNode no item selected" << endl;
		return;
	}

	// expand node
	XmlTreeItem * pSelTreeItem = static_cast <XmlTreeItem *> (pSelItem);
	pSelTreeItem->collapseNode(nLevel);
}

void KXE_TreeView::slotBookmarksToggle()
{
	// get selected item from tree view
	QListViewItem * pSelItem = selectedItem();
	if ( ! pSelItem )
	{
		kdDebug() << "KXE_TreeView::slotBookmarksToggle no item selected" << endl;
		return;
	}

	bool fTmp = (m_nBookmarkCount == 0);

	// toggle bookmark on selected item
	XmlTreeItem* pSelTreeItem = static_cast <XmlTreeItem *> (pSelItem);
	if ( pSelTreeItem->toggleBookmark() )
		m_nBookmarkCount++;
	else
		m_nBookmarkCount--;

	if ( m_nBookmarkCount == 0 )
		emit sigNewBookmarkStatus(false);
	else if (fTmp)
		emit sigNewBookmarkStatus(true);
}

void KXE_TreeView::slotBookmarksPrev()
{
	// get selected item from tree view
	QListViewItem *pSelItem = selectedItem();
	if ( ! pSelItem )
	{
		kdDebug() << "KXE_TreeView::slotBookmarksPrev no item selected" << endl;
		return;
	}

	// Search above item with bookmark
	QListViewItem *pAboveItem;
	while ( (pAboveItem = pSelItem->itemAbove()) != 0 )
	{
		XmlTreeItem* pAboveTreeItem = static_cast <XmlTreeItem *> (pAboveItem);
		if ( pAboveTreeItem->hasBookmark() )
		{
			setCurrentItem(pAboveItem);
			ensureItemVisible(pAboveItem);
			return;
		}
		pSelItem = pAboveItem;
	}
}

void KXE_TreeView::slotBookmarksNext()
{
	// get selected item from tree view
	QListViewItem *pSelItem = selectedItem();
	if ( ! pSelItem )
	{
		kdDebug() << "KXE_TreeView::slotBookmarksNext no item selected" << endl;
		return;
	}

	// Search below item with bookmark
	QListViewItem *pBelowItem;
	while ( (pBelowItem = pSelItem->itemBelow()) != 0 )
	{
		XmlTreeItem* pBelowTreeItem = static_cast <XmlTreeItem *> (pBelowItem);
		if ( pBelowTreeItem->hasBookmark() )
		{
			setCurrentItem(pBelowItem);
			ensureItemVisible(pBelowItem);
			return;
		}
		pSelItem = pBelowTreeItem;
	}
}


bool KXE_TreeView::selectItem( const QString & szPath )
{
	// find root XML element
	XmlTreeItem * pTreeItem = static_cast <XmlTreeItem *> (firstChild());
	while ( (pTreeItem) && ( pTreeItem->itemType() != XmlTreeItem::itemElement ) )
	{
		pTreeItem = static_cast <XmlTreeItem *> (pTreeItem->nextSibling());
	}
	if ( ! pTreeItem )
		return false;

	XmlTreeItem * pFoundItem = pTreeItem->searchPath(szPath);
	if ( pFoundItem )
	{ // make new item visible and selected
		setCurrentItem(pFoundItem);
		ensureItemVisible(pFoundItem);
		return true;
	}
	else
		return false;
}


void KXE_TreeView::contentsMousePressEvent( QMouseEvent * pEvent )
{
	KListView::contentsMousePressEvent(pEvent);

	if ( pEvent->button() == RightButton )
	{
		QWidget * pTmpWidget = 0;

		QListViewItem * pItem = itemAt( contentsToViewport(pEvent->pos()) );
		if (pItem)
		{
			XmlTreeItem * pTreeItem = static_cast <XmlTreeItem*> (pItem);
			switch( pTreeItem->itemType() )
			{
				case  XmlTreeItem::itemElement:
					pTmpWidget = m_pGUIClient->factory()->container( "popupXmlElement", m_pGUIClient );
					break;
				case	XmlTreeItem::itemText:
				case	XmlTreeItem::itemCDATA:
				case	XmlTreeItem::itemComment:
					pTmpWidget = m_pGUIClient->factory()->container( "popupXmlContent", m_pGUIClient );
					break;
				case	XmlTreeItem::itemProcInstr:
					pTmpWidget = m_pGUIClient->factory()->container( "popupXmlProcInstr", m_pGUIClient );
					break;
				default:
					kdDebug() << "KXE_TreeView::contentsMousePressEvent unknown item type" << endl;
					return;
			}
		}
		else
			pTmpWidget = m_pGUIClient->factory()->container( "popupXmlTree", m_pGUIClient );

		if ( ! pTmpWidget || ! pTmpWidget->inherits("KPopupMenu") )
		{
			kdDebug() << "KXE_TreeView::contentsMousePressEvent wrong container widget" << endl;
			return;
		}

		KPopupMenu * pMenu = static_cast <KPopupMenu*> (pTmpWidget);
		pMenu->popup( QCursor::pos() );
	}

}

void KXE_TreeView::slotSelectionChanged( QListViewItem * pItem )
{
	if ( ! pItem )
	{
		kdDebug() << "KXE_TreeView::slotSelectionChanged given pointer is null" << endl;
		return;
	}

	XmlTreeItem * pSelectedTreeItem = static_cast <XmlTreeItem *> (pItem);

	// choose appropriate object kind
	switch ( pSelectedTreeItem->itemType() )
	{
		case XmlTreeItem::itemElement:
			emit sigSelectionChanged( static_cast <XmlElement *> (pItem) );
			break;

		case XmlTreeItem::itemText:
		case XmlTreeItem::itemCDATA:
		case XmlTreeItem::itemComment:
			emit sigSelectionChanged( static_cast <XmlContentsItem *> (pItem) );
			break;

		case XmlTreeItem::itemProcInstr:
			emit sigSelectionChanged( static_cast <XmlProcessingInstruction *> (pItem) );
			break;

			default:
				kdDebug() << "KXE_TreeView::slotSelectionChanged unknown object type selected" << endl;
				return;
		}
}
