/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PATTERNPROPERTIESDIALOG_H
#define PATTERNPROPERTIESDIALOG_H

#include "patternpropertiesdlg.h"

/** Wrapper class for PatternPropertiesDlg.ui
    @author Stephen P. Allewell
  */
class PatternPropertiesDialog : public PatternPropertiesDlg
{
  Q_OBJECT
public:
/** Constructor
    @param parent Pointer to the parent object
  */
  PatternPropertiesDialog(QWidget* parent);

/** Reimplemented from the base class.
    Called before the dialog is shown. Set the values of the dialog box
    to the member values stored in this class.
  */
  virtual void show();
/** Reset the member values to the users preferred values from the configuration
    object.
  */
  void reset();

/** Set the units to display the values in.
    @param sizeUnits The units to use (Stitches|CM|Inches)
  */
  void setUnits(QString sizeUnits);
/** Set the width in stitches of the pattern.
  */
  void setPatternWidth(int width);
/** Set the height in stitches of the pattern.
  */
  void setPatternHeight(int height);
/** Set the size in stitches of the pattern.
  */
  void setPatternSize(int width,int height);
/** Set the cloth count.
    @param clothCount Cloth count value (value/CM|value/Inch) dependant on the
    last setting of sizeUnits in CM or Inches.
  */
  void setClothCount(double clothCount);
/** Set the cloth count units.
    This will be cm or in.
    @param clothCountUnits The units to be used.
  */
  void setClothCountUnits(QString clothCountUnits);

  void setTitle(QString title);
  void setAuthor(QString author);
  void setCopyright(QString copyright);
  void setFabric(QString fabric);
  void setFabricColor(QColor fabricColor);
  void setScheme(QString scheme);
  void setInstructions(QString instructions);

  QString units();
  int patternWidth();
  int patternHeight();
  QSize patternSize();
  double clothCount();
  QString clothCountUnits();
  QString title();
  QString author();
  QString copyright();
  QString fabric();
  QColor fabricColor();
  QString scheme();
  QString instructions();

/** Write the values of the pattern properties to the stream
    [Non member function]
  */
  friend QDataStream& operator<<(QDataStream&,const PatternPropertiesDialog&);
/** Read the values of the pattern properties from the stream
    [Non member function]
  */
  friend QDataStream& operator>>(QDataStream&,PatternPropertiesDialog&);

protected slots:
/** Reimplemented from base class.
    Called when the Close button is selected.  It is used to check if the
    'Set as default' checkbox is set and if so will store the values in the
    dialog to the configuration object.
  */
  virtual void accept();
/** Invoke the context help for this dialog
  */
  void slotContextHelp();

private slots:
/** Called when the units are changed.
    Will update the values in width, height and possibly cloth count to relate
    to the new units.
    @param sizeUnits The new units to be used.
  */
  void slotUnitsChanged(const QString& sizeUnits);

private:
/** Calculate the values for display width and height for the dialog
    box, based on the display units and cloth count values.  Set the
    increment values for the spin boxes dependant on the display units
    and set the suffix for the cloth count.
  */
  void calculateSizes(int width,int height,double clothCount,QString clothCountUnits);

  QString m_sizeDisplayUnits;
  QString m_sizeUnits;
  int     m_sizeWidth;    // width in stitches
  int     m_sizeHeight;   // height in stitches
  double  m_clothCount;
  QString m_clothCountUnits;
  QString m_patternTitle;
  QString m_patternAuthor;
  QString m_patternCopyright;
  QString m_patternFabric;
  QColor  m_fabricColor;
  QString m_flossScheme;
  QString m_patternInstructions;
};

#endif // KXSTITCHVIEW_H
