/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __CONFIGURATION_H
#define __CONFIGURATION_H

#include <qstring.h>
#include <qstringlist.h>
#include <qcolor.h>

class QComboBox;

/** Store the configuration variables for KXStitch, these can be accessed via
    the KXSConfig() function which provides a reference to the object.
    @author Stephen P Allewell
  */
class Configuration
{
public:
/** Read the configuration variables from the KConfig object
  */
  void readSettings();
/** Display a configuration dialog and allow the user to change settings
  */
  void configure();
/** Write the configuration variables to the KConfig object
  */
  void writeSettings();

/** Set the current element of a QComboBox to the specified string
    @param cb A pointer to the combo box
    @param s The string value required
  */
  static void setComboBoxItem(QComboBox* cb,const QString& s);

  // Initial pattern settings
  QString       NewPattern_Units;
  int           NewPattern_Width;
  int           NewPattern_Height;
  double        NewPattern_ClothCount;
  QString       NewPattern_ClothCountUnits;
  QString       NewPattern_Title;
  QString       NewPattern_Author;
  QString       NewPattern_Copyright;
  QString       NewPattern_Fabric;
  QColor        NewPattern_Color;
  QString       NewPattern_FlossScheme;
  QString       NewPattern_Instructions;

  // file path settings
  QString       DefaultPath_Patterns;
  QString       DefaultPath_Motifs;
  QString       DefaultPath_FlossSchemes;

  // Import image settings
  bool          Import_UseMaxColors;
  int           Import_MaxColors;

  // Print options settings
  bool          Print_FrontPage;
  bool          Print_Instructions;
  int           Print_SquaresInch;
  int           Print_SpillOver;
  bool          Print_Pattern;
  bool          Print_FitSingle;
  bool          Print_SelectedArea;
  bool          Print_ColorKey;
  bool          Print_GridLines;
  bool          Print_Stitches;
  QString       Print_StitchesAs;
  bool          Print_Backstitches;
  QString       Print_BackstitchesAs;
  bool          Print_FlossUsage;
  bool          Print_StitchCount;
  bool          Print_CombineLengths;
  bool          Print_CombineFractionals;
  bool          Print_SeperateBackstitching;
  bool          Print_StitchTotals;
  bool          Print_StitchSummary;

  // Editor view settings
  bool          Editor_ShowStitches;
  QString       Editor_StitchesAs;
  bool          Editor_ShowBackstitches;
  QString       Editor_BackstitchesAs;
  bool          Editor_ShowGrid;
  int           Editor_CellSize;
  int           Editor_CellGrouping;
  QColor        Editor_GridMajorColor;
  QColor        Editor_GridMinorColor;
  bool          Editor_ShowScales;
  int           Editor_ScaleSize;
  QString       Editor_ScaleFormat;
  QString       Editor_SymbolFont;

  // Palette settings
  int           Palette_StitchStrands;
  int           Palette_BackstitchStrands;
  int           Palette_FlossStrands;       // should be part of floss scheme
  
private:
/** Constructor.
    calls readSettings to initialise the variables
  */
  Configuration();

  friend Configuration& KXSConfig();
};

/** Return a reference to the Configuration object */
Configuration& KXSConfig();

#endif // __CONFIGURATION_H
