/***************************************************************************
 *
 *  $Id: kzennavigationview.h,v 1.10 2005/05/31 06:54:03 muszilla Exp $
 *
 *  Copyright (C) 2005 by Andreas Mussgiller
 *  muszilla@users.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the
 *  Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef KZENNAVIGATIONVIEW_H
#define KZENNAVIGATIONVIEW_H

#include <klistview.h>

class KZenPlayList;

/**
@author Andreas Mussgiller
*/
class KZenNavigationView : public KListView
{
  friend class KListViewItem;

  Q_OBJECT
  
 public:
  
  KZenNavigationView(QWidget * parent = 0, const char *name = 0);
  ~KZenNavigationView();

  virtual void                contentsDragMoveEvent(QDragMoveEvent *event);
  virtual void                contentsDropEvent(QDropEvent * event);

  virtual bool                decode(QMimeSource *s, KZenPlayList *);
  virtual bool                decodeTracks(QMimeSource *s, KZenPlayList *);

 protected slots:

  virtual void                itemDoubleClicked(QListViewItem *, const QPoint &, int);

 private slots:
  
  void                        mousePressed(int, QListViewItem *, const QPoint &, int);
  
 signals:

  void                        filesDropped(const QStringList &, KZenPlayList *);
  void                        tracksDropped(const QStringList &, KZenPlayList *);
};

#endif
