package tests::LrRangegroupTest;

use strict;

use base qw/Lire::Test::TestCase/;

use Lire::SQLExt::LrRangegroup;

sub test_lr_rangegroup {
    my $self = $_[0];

    my @tests =
      (
       # Value, Start, Length, Min, Max, Result
       [ undef, 0, 10, undef, undef, undef ],
       [ 10, undef, 10, undef, undef, undef ],
       [ 10, 0, undef, undef, undef, undef ],
       [ 0,  0, 10, undef, undef, 0 ],
       [ 5,  0, 10, undef, undef, 0 ],
       [ 10,  0, 10, undef, undef, 10 ],
       [ 10_000,  0, 10, undef, 1_000, 1_000 ],
       [ -1, 0, 10, undef, undef, -10 ],
       [ -10, 0, 10, undef, undef, -10 ],
       [ -1, 0, 10, 0, undef, 0 ],
       [ 2, 1, 10, undef, undef, 1],
       [ 0, 1, 10, undef, undef, -9],
       [ 0, 1, 10, 1, undef, 1],
      );

    foreach my $t ( @tests ) {
        my ( $value, $start, $length, $min, $max, $result ) = @$t;
        my $r =
          Lire::SQLExt::LrRangegroup::lr_rangegroup( $value, $start, $length,
                                                     $min, $max );
        no warnings 'uninitialized';
        if ( ! defined $result ) {
            $self->assert_null( $r, "lr_rangegroup( $value, $start, $length, $min, $max ) should return undef, not $r" );
        } else {
            $self->assert_not_null( $r, "lr_rangegroup( $value, $start, $length, $min, $max ) should return $result, not undef" );
            $self->assert_equals( $result, $r,
                                  "lr_rangegroup( $value, $start, $length, $min, $max ) returned $r, expected $result" );
        }
    }
}

sub test_lr_rangegroup_geo {
    my $self = $_[0];

    my @tests =
      (
       # Value, Start, Length, Base, Min, Max, Result
       [ undef, 0, 10, 2, undef, undef, undef ],
       [ 10, undef, 10, 2, undef, undef, undef ],
       [ 10, 0, undef, 2, undef, undef, undef ],
       [ 10, 0, 2, undef, undef, undef, undef ],

       # [0-1000>
       # [1000-6000>
       # [6000-31000>
       # [31000,~
       [ -1,  0, 1000, 5, undef, undef, undef ],
       [ 0,  0, 1000, 5, undef, undef, 0 ],
       [ 1000,  0, 1000, 5, undef, undef, 1000 ],
       [ 6_000,  0, 1000, 5, undef, undef, 6_000 ],
       [ 23_000,  0, 1000, 5, undef, undef, 6_000 ],
       [ 30_000,  0, 1000, 5, undef, undef, 6_000 ],
       [ 31_000,  0, 1000, 5, undef, undef, 31_000 ],
       [ 200_000, 0, 1000, 5, undef, 50_000, 31_000 ],
       [ 10,  0, 1000, 5, 1000, undef, 1000 ],

       # [1-11>
       # [11-31>
       # [31-71>
       # [71-~
       [ 0, 1, 10, 2, undef, undef, undef ],
       [ 1, 1, 10, 2, undef, undef, 1 ],
       [ 10, 1, 10, 2, undef, undef, 1 ],
       [ 11, 1, 10, 2, undef, undef, 11 ],
       [ 30, 1, 10, 2, undef, undef, 11 ],
       [ 30.9999, 1, 10, 2, undef, undef, 11 ],
       [ 31, 1, 10, 2, undef, undef, 31 ],
       [ 40, 1, 10, 2, undef, undef, 31 ],
       [ 71, 1, 10, 2, undef, undef, 71 ],

       # [5-15>
       # [15-35>
       # [35-75>
       # [75-~
       [ 0, 5, 10, 2, undef, undef, undef ],
       [ 0, 5, 10, 2, 5, undef, 5 ],
       [ 5,  5, 10, 2, undef, undef, 5 ],
       [ 10, 5, 10, 2, undef, undef, 5 ],
       [ 11, 5, 10, 2, undef, undef, 5 ],
       [ 30, 5, 10, 2, undef, undef, 15 ],
       [ 40, 5, 10, 2, undef, undef, 35 ],
       [ 70, 5, 10, 2, undef, undef, 35 ],
       [ 75, 5, 10, 2, undef, undef, 75 ],
      );

    foreach my $t ( @tests ) {
        my ( $value, $start, $length, $base, $min, $max, $result ) = @$t;
        my $r =
          Lire::SQLExt::LrRangegroup::lr_rangegroup_geo( $value, $start, $length,
                                                         $base, $min, $max );
        no warnings 'uninitialized';
        if ( ! defined $result ) {
            $self->assert_null( $r, "lr_rangegroup( $value, $start, $length, $base, $min, $max ) should return undef, not $r" );
        } else {
            $self->assert_not_null( $r, "lr_rangegroup( $value, $start, $length, $base, $min, $max ) should return $result, not undef" );
            $self->assert_equals( $result, $r,
                                  "lr_rangegroup( $value, $start, $length, $base, $min, $max ) returned $r, expected $result" );
        }
    }
}

1;

