--***********************************************************************
--									*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that the above copyright notice and this paragraph are	*
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

--  modified for use with Adabindx 10.8.1997
--  Hans-Frieder Vogt (vogt@ilaws6.luftfahrt.uni-stuttgart.de)
--  modified for use with adabindx 0.7 29 Feb 2000

with
    BUG;

with System,
     X_Lib.Property;
use  X_Lib,
     X_Lib.Property;

package body GRAPHICS_WINDOW_MANAGER is

    DEBUGGING : BOOLEAN := False;
	pragma VOLATILE(DEBUGGING); -- so can be changed via debugger


    type COLOR_VECTOR_OF_GC_TYPE is array(COLOR) of GC_Pointer;

    type GRAPHICS_WINDOW_TYPE is
	record
	    Window  : Window_ID;
	    Pixmap  : Pixmap_ID;
	    Height  : Dimension;
	    Width   : Dimension;
	    GCs	    : COLOR_VECTOR_OF_GC_TYPE;
	end record;


    DISPLAY	    : Display_Pointer;
    GW		    : GRAPHICS_WINDOW_TYPE;
    COLORMAP	    : Colormap_ID;
    FONT	    : Font_ID;
    SCREEN	    : Screen_Pointer;
    VISUAL	    : Visual_Pointer;

    DEPTH	    : Color_Depth;
    HEIGHT	    : Dimension;
    SWA 	    : Set_Window_Attributes_Type;
    WIDTH	    : Dimension;
    WINDOW_MASKS    : Set_Window_Attributes_Mask;


    procedure ERASE is
    begin
       X_Fill_Rectangle
         (Display => Display,
          D       => GW.Pixmap,
          GC      => GW.GCs (Color_Background),
          X       => 0,
          Y       => 0,
          Width   => GW.Width,
          Height  => GW.Height);
    end;

    procedure CREATE_THE_WINDOW
    is separate;

    procedure FILL_CONVEX_POLYGON(
	COLOR : COLORS.COLOR;
	POINTS: POINTS_TYPE
	)
    is separate;

    procedure START_NEW_PICTURE
    is separate;	

    procedure STARTUP(NAME : STRING) is
    begin
	DISPLAY := X_Open_Display ("");
	if DISPLAY = Null_Display_Pointer then
	    BUG("Unable to open DISPLAY");
	end if;

	SCREEN	    := X_Default_Screen_Of_Display (DISPLAY);
	COLORMAP    := X_Default_Colormap_Of_Screen (SCREEN);
	HEIGHT	    := Dimension (X_Height_Of_Screen (SCREEN));
	WIDTH	    := Dimension (X_Width_Of_Screen (SCREEN));
	DEPTH	    := X_Default_Depth_Of_Screen (SCREEN);
	VISUAL	    := X_Default_Visual_Of_Screen (SCREEN);

	-- Load the font for text writing
	--
	FONT := X_Load_Font (Display => Display,
                             Name    => 
			"-Adobe-New Century Schoolbook-Medium-R-Normal" &
			"--*-140-*-*-P-*-ISO8859-1");

	-- Create the window
	--
	CREATE_THE_WINDOW;

	-- Define the name of the window
	--
	X_Set_WM_Name
          (Display      => Display,
	   W            => GW.Window,
	   Text_Prop    => To_Text_Property (NAME));

	-- Map the window
	--
	X_Map_Window (DISPLAY, GW.WINDOW);

	X_Flush (DISPLAY);
    end;


    function End_Requested return Boolean is
       Found : Boolean;
       Event : X_Event (Key_Press);
    begin
       X_Check_Typed_Window_Event (Display, GW.Window, Event, Found);
       return Found;
    end End_Requested;

end;
