/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.FixedAttribute;
import net.sf.saxon.instruct.FixedElement;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private boolean[] attributeChecked;
    private int numberOfAttributes;
    private boolean toplevel;
    private int[] namespaceCodes;
    private AttributeSet[] attributeSets;
    private SchemaType schemaType = null;
    private int validation = 4;

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n = this.attributeList.getLength();
        if (n == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new int[n];
            this.attributeValues = new Expression[n];
            this.attributeChecked = new boolean[n];
            this.numberOfAttributes = 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.attributeList.getNameCode(n2);
                short s = namePool.getURICode(n3);
                if (s == 2) {
                    int n4 = n3 & 0xFFFFF;
                    if (n4 != 232 && n4 != 230 && n4 != 229 && n4 != 234 && n4 != 228 && n4 != 231 && n4 != 233) {
                        this.compileError("Unknown XSL attribute " + namePool.getDisplayName(n3));
                    }
                } else {
                    Expression expression;
                    this.attributeNames[this.numberOfAttributes] = n3;
                    this.attributeValues[this.numberOfAttributes] = expression = this.makeAttributeValueTemplate(this.attributeList.getValue(n2));
                    this.attributeChecked[this.numberOfAttributes] = false;
                    boolean bl = false;
                    if (expression instanceof StringValue) {
                        String string = ((StringValue)expression).getStringValue();
                        int n5 = 0;
                        while (n5 < string.length()) {
                            char c = string.charAt(n5);
                            if (c < '!' || c > '~' || c == '<' || c == '>' || c == '&' || c == '\"') {
                                bl = true;
                                break;
                            }
                            ++n5;
                        }
                        this.attributeChecked[this.numberOfAttributes] = !bl;
                    }
                    ++this.numberOfAttributes;
                }
                ++n2;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                int[] nArray = new int[this.numberOfAttributes];
                System.arraycopy(this.attributeNames, 0, nArray, 0, this.numberOfAttributes);
                this.attributeNames = nArray;
                Expression[] expressionArray = new Expression[this.numberOfAttributes];
                System.arraycopy(this.attributeValues, 0, expressionArray, 0, this.numberOfAttributes);
                this.attributeValues = expressionArray;
                boolean[] blArray = new boolean[this.numberOfAttributes];
                System.arraycopy(this.attributeChecked, 0, blArray, 0, this.numberOfAttributes);
                this.attributeChecked = blArray;
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.toplevel = this.getParentNode() instanceof XSLStyleSheet;
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        short s = namePool.getURICode(this.resultNameCode);
        if (this.toplevel) {
            if (s == 0) {
                this.compileError("Top level elements must have a non-null namespace URI");
            }
        } else {
            int n;
            int n2;
            int n3;
            String string;
            String string2;
            String string3;
            boolean bl = false;
            if (this.getParent() instanceof LiteralResultElement && (this.namespaceList == null || this.namespaceList.length == 0) && s == namePool.getURICode(this.getParent().getFingerprint())) {
                bl = true;
            }
            if (bl) {
                int n4 = 0;
                while (n4 < this.attributeList.getLength()) {
                    if ((this.attributeList.getNameCode(n4) >> 20 & 0xFF) != 0) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
            }
            this.namespaceCodes = bl ? new int[0] : this.getNamespaceCodes();
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            if (xSLStyleSheet.hasNamespaceAliases()) {
                int n5;
                int n6 = 0;
                while (n6 < this.namespaceCodes.length) {
                    n5 = (short)(this.namespaceCodes[n6] & 0xFFFF);
                    int n7 = xSLStyleSheet.getNamespaceAlias((short)n5);
                    if (n7 != -1 && (n7 & 0xFFFF) != n5) {
                        this.namespaceCodes[n6] = n7;
                    }
                    ++n6;
                }
                n5 = xSLStyleSheet.getNamespaceAlias(s);
                if ((n5 & 0xFFFF) != s) {
                    s = (short)(n5 & 0xFFFF);
                    this.resultNameCode = namePool.allocate(namePool.getPrefixFromNamespaceCode(n5), namePool.getURIFromNamespaceCode(n5), this.getLocalPart());
                }
            }
            if ((string3 = this.getAttributeValue(232)) != null) {
                this.attributeSets = this.getAttributeSets(string3, null);
            }
            if ((string2 = this.getAttributeValue(231)) != null) {
                if (!this.getConfiguration().isSchemaAware()) {
                    this.compileError("The xsl:type attribute is available only with a schema-aware XSLT processor");
                }
                this.schemaType = this.getSchemaType(string2);
            }
            if ((string = this.getAttributeValue(233)) != null) {
                this.validation = Validation.getCode(string);
                if (this.validation != 4 && !this.getConfiguration().isSchemaAware()) {
                    this.compileError("To perform validation, a schema-aware XSLT processor is needed");
                }
                if (this.validation == -1) {
                    this.compileError("Invalid value for xsl:validation. Permitted values are (strict, lax, preserve, strip)");
                }
            } else {
                this.validation = this.getContainingStyleSheet().getDefaultValidation();
            }
            short[] sArray = new short[this.numberOfAttributes];
            if (this.numberOfAttributes > 0) {
                n3 = 0;
                while (n3 < this.numberOfAttributes) {
                    int n8;
                    n = n2 = this.attributeNames[n3];
                    short s2 = namePool.getURICode(n2);
                    if (s2 != 0 && ((n8 = xSLStyleSheet.getNamespaceAlias(s2)) & 0xFFFF) != s2) {
                        s2 = (short)(n8 & 0xFFFF);
                        n = namePool.allocate(namePool.getPrefixFromNamespaceCode(n8), namePool.getURIFromNamespaceCode(n8), this.attributeList.getLocalName(n3));
                    }
                    this.attributeNames[n3] = this.translate(n);
                    sArray[n3] = s2;
                    this.attributeValues[n3] = this.typeCheck(namePool.getDisplayName(n), this.attributeValues[n3]);
                    ++n3;
                }
            }
            n3 = 0;
            n2 = 0;
            while (n2 < this.namespaceCodes.length) {
                n = (short)(this.namespaceCodes[n2] & 0xFFFF);
                if (this.isExcludedNamespace((short)n) && !xSLStyleSheet.isAliasResultNamespace((short)n)) {
                    this.namespaceCodes[n2] = -1;
                    ++n3;
                }
                ++n2;
            }
            n = this.namespaceCodes.length - n3;
            NamePool namePool2 = this.getNamePool();
            NamePool namePool3 = this.getTargetNamePool();
            int[] nArray = new int[n];
            n = 0;
            int n9 = 0;
            while (n9 < this.namespaceCodes.length) {
                if (this.namespaceCodes[n9] != -1) {
                    String string4 = namePool2.getPrefixFromNamespaceCode(this.namespaceCodes[n9]);
                    String string5 = namePool2.getURIFromNamespaceCode(this.namespaceCodes[n9]);
                    nArray[n++] = namePool3.allocateNamespaceCode(string4, string5);
                }
                ++n9;
            }
            this.namespaceCodes = nArray;
        }
    }

    protected void validateChildren() throws TransformerConfigurationException {
        if (!this.toplevel) {
            super.validateChildren();
        }
    }

    private int translate(int n) {
        NamePool namePool = this.getNamePool();
        NamePool namePool2 = this.getTargetNamePool();
        String string = namePool.getPrefix(n);
        String string2 = namePool.getURI(n);
        String string3 = namePool.getLocalName(n);
        return namePool2.allocate(string, string2, string3);
    }

    public Instruction compile() throws TransformerConfigurationException {
        if (this.toplevel) {
            return null;
        }
        FixedElement fixedElement = new FixedElement(this.translate(this.resultNameCode), this.namespaceCodes, this.attributeSets, this.schemaType, this.validation);
        this.compileChildren(fixedElement);
        Instruction[] instructionArray = null;
        if (this.numberOfAttributes > 0) {
            Object object;
            instructionArray = new Instruction[this.attributeNames.length];
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            int n = 0;
            while (n < instructionArray.length) {
                object = new FixedAttribute(this.attributeNames[n], 4, null, -1);
                ((SimpleNodeConstructor)object).setSelect(this.attributeValues[n]);
                ((Instruction)object).setSourceLocation(xSLStyleSheet.putModuleNumber(this.getSystemId()), this.getLineNumber());
                if (this.attributeChecked[n]) {
                    ((FixedAttribute)object).setNoSpecialChars();
                }
                instructionArray[n] = object;
                ++n;
            }
            object = fixedElement.getChildren();
            Instruction[] instructionArray2 = new Instruction[instructionArray.length + ((Instruction[])object).length];
            System.arraycopy(instructionArray, 0, instructionArray2, 0, instructionArray.length);
            System.arraycopy(object, 0, instructionArray2, instructionArray.length, ((Object)object).length);
            fixedElement.setChildren(instructionArray2);
        }
        return fixedElement;
    }

    public DocumentImpl makeStyleSheet(PreparedStyleSheet preparedStyleSheet, StyleNodeFactory styleNodeFactory) throws TransformerConfigurationException {
        NamePool namePool = this.getNamePool();
        String string = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (string == null) {
            String string2 = this.getLocalPart().equals("stylesheet") || this.getLocalPart().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string2);
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        String string3 = this.getAttributeValue(234);
        if (string3 == null) {
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException("Literal Result Element As Stylesheet: xsl:version attribute is missing");
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        try {
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setDocumentLocator(null);
            treeBuilder.setNamePool(namePool);
            treeBuilder.setNodeFactory(styleNodeFactory);
            treeBuilder.setSystemId(this.getSystemId());
            treeBuilder.startDocument();
            int n = 180;
            treeBuilder.startElement(n, 0, 0);
            treeBuilder.namespace(2, 0);
            treeBuilder.attribute(namePool.allocate("", "", "version"), 0, string3, 0);
            treeBuilder.startContent();
            int n2 = 181;
            treeBuilder.startElement(n2, 0, 0);
            treeBuilder.attribute(namePool.allocate("", "", "match"), 0, "/", 0);
            treeBuilder.startContent();
            treeBuilder.graftElement(this);
            treeBuilder.endElement();
            treeBuilder.endElement();
            treeBuilder.endDocument();
            return (DocumentImpl)treeBuilder.getCurrentDocument();
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }
}

