package Authen::SASL::GSSAPI;

=head1 NAME

Authen::SASL::GSSAPI - GSSAPI interface to SASL

=head1 SYNOPSIS

See Authen::SASL.

=head1 DESCRIPTION

Provide a Authen::SASL compatible interface to the GSSAPI SASL
authentication method. Uses Authen::SASL::Cyrus to interface with the
Cyrus SASL library to provide this functionality.

=head1 METHODS

As detailed in Authen::SASL

=head1 OPTIONS

When creating the object, the following options are available.
fqdn - the name of the server being connected to
service - the name of the service being connected to
user - the username to connect as
=cut

use vars qw(@ISA, $VERSION);
use Authen::SASL::Cyrus;

@ISA = qw(Authen::SASL);


sub init {
  my ($self, $opt) = @_;
  $self->SUPER::init($opt);
  $self->{'fqdn'} = $opt->{'fqdn'};
  $self->{'service'} = $opt->{'service'};
  $self->{'myuser'} = $opt->{'user'};
  return($self);
}

sub initial {
  my ($self) = @_;
  $self->{'conn'} = 
    Authen::SASL::Cyrus::init_connection($self->{'service'},
					   $self->{'fqdn'},
					   $self->{'myuser'});
  require Carp and Carp::croak(Authen::SASL::Cyrus::error())
     if !defined($self->{'conn'});
  my $mesg=Authen::SASL::Cyrus::start($self->{'conn'},"GSSAPI");
  require Carp and Carp::croak(Authen::SASL::Cyrus::error())
     if !defined($mesg);
  return($mesg);
}

sub challenge {
  my ($self, $string) = @_;
  my $mesg=Authen::SASL::Cyrus::respond($self->{'conn'},$string);
  require Carp and Carp::croak(Authen::SASL::Cyrus::error())
     if !defined($mesg);
  return($mesg);
}

