#!/usr/bin/perl

use Business::ISBN::Data;

# I use the old data to grab the country names
# If there are new country prefixes, I just look them up
# and manually add them
# http://www.isbn-international.org/en/identifiers/allidentifiers.html
my %country_data = %Business::ISBN::country_data;

# I collect the updated data in this hash
my %new_hash = ();

while( <DATA> )
	{
	chomp;
	s/^\s+|\s+$//g;
	s/-//g;  # the data is dirty and some hyphens appear.  Trash them.
	
	# there should be a triplet, but the odd case has two numbers
	# meaning the range is a pseudo range, i.e. 0 to 0.  In that
	# case, make the second number the same as the first.  perl
	# won't care.
	my( $country, $first, $second ) = split /\s+/;
	$second ||= $first;

	my $name = $country_data{ $country };
	# some prefixes may be new.  Go back and add them by hand
	# later
	# http://www.isbn-international.org/en/identifiers/allidentifiers.html
	warn "Code $country does not have a name [$name]!\n" 
		unless $name;
	
	# If the strings (which you only think are numbers)
	# start with a 0, then we need to quote them so perl
	# doesn't think they are bad octal numbers, i.e. '09'
	# We treat them all as strings, although we cheat a
	# bit so our eyes don't cross: only quote when we have to.
	$first = "'$first'" if $first =~ /^0/;
	$second = "'$second'" if $second =~ /^0/;


	$new_hash{ $country } ||= [];
	
	push @{ $new_hash{ $country } }, [$first, $second];
	}

# If you read this comment and tell me so by emailing me, I'll
# buy you beer (although I get to choose the quantity).

foreach my $key ( sort { $a <=> $b } keys %new_hash )
	{
	my $array = $new_hash{ $key };
	my $name  = $country_data{ $key }[0];

	# 26 is a magic number I just know.  I counted the
	# characters between the start of the country name and
	# the start of the array that holds the publisher ranges in
	# the data structure representation.  26 makes everything
	# line up nicely.
	my $l = 26 - length $name;	
	
	# join ranges with a fat arrow, =>.
	my @pairs = map { "$_->[0] => $_->[1]" } @$array;
	
	my $pairs = join ", ", @pairs;
	
	printf "%5d => [ '%s',%${l}s[ %s ] ],\n", $key, $name, " ", $pairs;
	
	}
	
# For this data, i grabbed the prefix ranges as a PDF
# http://www.isbn-international.org/en/identifiers/List-of-Ranges.pdf
# I opened it by hand, selected all the text, and pasted it here.
# I did a little clean-up, and that's it.  I could automate this,
# but I don't think it would save any time.  The bug fixes and
# clean-up would take longer than doing it by hand.

__END__
0 00 19
0 200 699
0 7000 8499
0 85000 89999
0 900000 949999
0 9500000 9999999
1 00 09
1 100 399
1 4000 5499
1 55000 86979
1 869800 998999
2 00 19
2 200 349
2 35000 39999
2 400 699
2 7000 8399
2 84000 89999
2 900000 949999
2 9500000 9999999
3 00 02
3 030 033
3 0340 0369
3 03700 03999
3 04 19
3 200 699
3 7000 8499
3 85000 89999
3 900000 949999
3 9500000 9999999
4 00 19
4 200 699
4 7000 8499
4 85000 89999
4 900000 949999
4 9500000 9999999
5 00 19
5 200 699
5 7000 8499
5 85000 89999
5 900000 909999
5 91000 91999
5 9200 9299
5 93000 94999
5 9500 9799
5 98000 98999
5 9900000 9999999
7 00 09
7 100 499
7 5000 7999
7 80000 89999
7 900000 999999
80 00 19
80 200 699
80 7000 8499
80 85000 89999
80 900000 999999
81 00 19
81 200 699
81 7000 8499
81 85000 89999
81 900000 999999
82 00 19
82 200 699
82 7000 8999
82 90000 98999
82 990000 999999
83 00 19
83 200 599
83 60000 69999
83 7000 8499
83 85000 89999
83 900000 999999
84 00 19
84 200 699
84 7000 8499
84 85000 89999
84 9000 9199
84 920000 923999
84 92400 92999
84 930000 949999
84 95000 96999
84 9700 9999
85 00 19
85 200 699
85 7000 8499
85 85000 89999
85 900000 979999
85 98000 99999
86 00 29
86 300 699
86 7000 7999
86 80000 89999
86 900000 999999
87 00 29
87 400 649
87 7000 7999
87 85000 94999
87 970000 999999
88 00 19
88 200 599
88 6000 8499
88 85000 89999
88 900000 999999
89 00 24
89 250 549
89 5500 8499
89 85000 94999
89 950000 999999
90 00 19
90 200 499
90 5000 6999
90 70000 79999
90 800000 849999
90 8500 8999
90 900000 909999
90 940000 949999
91 0 1
91 20 49
91 500 649
91 7000 7999
91 85000 94999
91 970000 999999
92 0 - 5
92 60 - 79
92 800 - 899
92 9000 - 9499
92 95000 - 98999
92 990000 - 999999
950 00 49
950 500 899
950 9000 9899
950 99000 99999
951 0 1
951 20 54
951 550 889
951 8900 9499
951 95000 99999
952 00 19
952 200 499
952 5000 5999
952 60 65
952 6600 6699
952 67000 69999
952 7000 7999
952 89 94
952 9500 9899
952 99000 99999
953 0 0
953 10 14
953 150 599
953 6000 9499
953 95000 99999
954 00 29
954 300 799
954 8000 8999
954 90000 92999
954 9300 9999
955 0
955 1000 1999
955 20 54
955 550 799
955 8000 9499
955 95000 99999
956 00 19
956 200 699
956 7000 9999
957 00 02
957 0300 0499
957 05 19
957 2000 2099
957 21 27
957 28000 30999
957 31 43
957 440 819
957 8200 9699
957 97000 99999
958 00 59
958 600 799
958 8000 9499
958 95000 99999
959 00 19
959 200 699
959 7000 8499
960 00 19
960 200 659
960 6600 6899
960 690 699
960 7000 8499
960 85000 99999
961 00 19
961 200 599
961 6000 8999
961 90000 94999
962 00 19
962 200 699
962 7000 8499
962 85000 86999
962 8700 8999
962 900 999
963 00 19
963 200 699
963 7000 8499
963 85000 89999
963 9000 9999
964 00 29
964 300 549
964 5500 8999
964 90000 99999
965 00 19
965 200 599
965 7000 7999
965 90000 99999
966 00 29
966 300 699
966 7000 8999
966 90000 99999
967 0 5
967 60 89
967 900 989
967 9900 9989
967 99900 99999
968 01 39
968 400 499
968 5000 7999
968 800 899
969 0 1
969 20 39
969 400 799
969 8000 9999
970 01 59
970 600 899
970 9000 9099
970 91000 96999
970 9700 9999
971 000 019
971 02 02
971 0300 0599
971 06 09
971 10 49
971 500 849
971 8500 9099
971 91000 99999
972 0 1
972 20 54
972 550 799
972 8000 9499
972 95000 99999
973 0 1
973 20 54
973 550 769
973 7700 8499
973 85000 89999
973 9000 9499
973 95000 99999
974 00 19
974 200 699
974 7000 8499
974 85000 89999
974 90000 94999
974 9500 9999
975 00 24
975 250 599
975 6000 9199
975 92000 98999
976 0 3
976 40 59
976 600 799
976 8000 9499
976 95000 99999
977 00 19
977 200 499
977 5000 6999
977 700 999
978 000 199
978 2000 2999
978 30000 79999
978 8000 8999
978 900 999
979 0 0
979 20 29
979 3000 3999
979 400 799
979 8000 9499
979 95000 99999
980 00 19
980 200 599
980 6000 9999
981 00 19
981 200 299
981 3000 9999
982 00 09
982 100 699
982 70 89
982 9000 9999
983 00 01
983 020 199
983 2000 3999
983 40000 49999
983 50 79
983 800 899
983 9000 9899
983 99000 99999
984 00 39
984 400 799
984 8000 8999
984 90000 99999
985 00 39
985 400 599
985 6000 8999
985 90000 99999
986 00 11
986 120 559
986 5600 7999
986 80000 99999
987 00 09
987 1000 1999
987 20000 29999
987 30 49
987 500 899
987 9000 9499
987 95000 99999
988 00 19
988 200 799
988 8000 9699
988 97000 99999
989 0 1
989 20 54
989 550 799
989 8000 9499
989 95000 99999
9945 00 39
9945 400 849
9945 8500 9999
9946 0 1
9946 20 39
9946 400 899
9946 9000 9999
9947 0 1
9947 20 79
9947 800 999
9948 00 39
9948 400 849
9948 8500 9999
9949 0 0
9949 10 39
9949 400 899
9949 9000 9999
9950
9951 00 39
9951 400 849
9951 8500 9999
9952 0 1
9952 20 39
9952 400 799
9952 8000 9999
9953 0 0
9953 10 39
9953 400 599
9953 60 89
9953 9000 9999
9954 0 1
9954 20 39
9954 400 799
9954 8000 9999
9955 00 39
9955 400 929
9955 9300 9999
9956 0 0
9956 10 39
9956 400 899
9956 9000 9999
9957 00 39
9957 400 849
9957 8500 9999
9958 0 0
9958 10 49
9958 500 899
9958 9000 9999
9959 0 1
9959 20 79
9959 800 949
9959 9500 9999
9960 00 59
9960 600 899
9960 9000 9999
9961 0 2
9961 30 69
9961 700 949
9961 9500 9999
9962 00 54
9962 5500 5599
9962 56 59
9962 600 849
9962 8500 9999
9963 0 2
9963 30 54
9963 550 749
9963 7500 9999
9964 0 6
9964 70 94
9964 950 999
9965 00 39
9965 400 899
9965 9000 9999
9966 00 69
9966 7000 7499
9966 750 959
9966 9600 9999
9967 00 39
9967 400 899
9967 9000 9999
9968 00 49
9968 500 939
9968 9400 9999
9970 00 39
9970 400 899
9970 9000 9999
9971 0 5
9971 60 89
9971 900 989
9971 9900 9999
9972 00 09
9972 1
9972 200 249
9972 2500 2999
9972 30 59
9972 600 899
9972 9000 9999
9973 0 0
9973 10 69
9973 700 969
9973 9700 9999
9974 0 2
9974 30 54
9974 550 749
9974 7500 9499
9974 95 99
9975 0 4
9975 50 89
9975 900 949
9975 9500 9999
9976 0 5
9976 60 89
9976 900 989
9976 9990 9999
9977 00 89
9977 900 989
9977 9900 9999
9978 00 29
9978 300 399
9978 40 94
9978 950 989
9978 9900 9999
9979 0 4
9979 50 75
9979 760 899
9979 9000 9999
9980 0 3
9980 40 89
9980 900 989
9980 9900 9999
9981 00 09
9981 100 159
9981 1600 1999
9981 20 79
9981 800 949
9981 9500 9999
9982 00 79
9982 800 889
9982 9900 9999
9983 80 94
9983 950 989
9983 9900 9999
9984 00 49
9984 500 899
9984 9000 9999
9985 0 4
9985 50 79
9985 800 899
9985 9000 9999
9986 00 39
9986 400 899
9986 9000 9399
9986 940 969
9986 97 99
9987 00 39
9987 400 879
9987 8800 9999
9988 0 2
9988 30 54
9988 550 749
9988 7500 9999
9989 0 0
9989 100 199
9989 2000 2999
9989 30 59
9989 600 949
9989 9500 9999
99901 00 49
99901 500 799
99901 80 99
99903 0 1
99903 20 89
99903 900 999
99904 0 5
99904 60 89
99904 900 999
99905 0 3
99905 40 79
99905 800 999
99906 0 2
99906 30 59
99906 600 999
99908 0 0
99908 10 89
99908 900 999
99909 0 3
99909 40 94
99909 950 999
99910 0 2
99910 30 89
99910 900 999
99911 00 59
99911 600 999
99912 0 4
99912 500 599
99912 60 89
99912 900 999
99913 0 2
99913 30 35
99913 600 604
99914 0 4
99914 50 89
99914 900 949
99915 0 4
99915 50 79
99915 800 999
99916 0 2
99916 30 69
99916 700 999
99917 0 2
99917 30 89
99917 900 999
99918 0 3
99918 40 89
99918 900 999
99919 0 2
99919 40 69
99919 900 999
99920 0 4
99920 50 89
99920 900 999
99921 0 1
99921 20 69
99921 700 799
99921 8 8
99921 90 99
99922 0 3
99922 40 69
99922 700 999
99923 0 1
99923 20 79
99923 800 999
99924 0 2
99924 30 79
99924 800 900
99925 0 3
99925 40 79
99925 800 999
99926 0 0
99926 10 59
99926 600 999
99927 0 2
99927 30 59
99927 600 999
99928 0 0
99928 10 79
99928 800 999
99929
99930 0 4
99930 50 79
99930 800 999
99931 0 4
99931 50 79
99931 800 999
99932 0 0
99932 10 59
99932 600 699
99932 7 7
99932 80 99
99933 0 2
99933 30 59
99933 600 999
99934 0 1
99934 20 79
99934 800 999
99935 0 2
99935 30 59
99935 600 799
99935 8
99935 90 99
99936 0 0
99936 10 59
99936 600 999
99937 0 1
99937 20 59
99937 600 999
99938 0 2
99938 30 59
99938 600 999
99939 0 5
99939 60 89
99939 900 999
99940 0 0
99940 10 69
99940 700 999
99941 0 2
99941 30 89
99941 900 999
99942 0 4
99942 50 79
99942 800 999
99943 0 2
99943 30 59
99943 600 999
99944 0 4
99944 50 79
99944 800 999
99946 0 2
99946 30 59
99946 600 999