#if   !defined(__OBJECT_HPP)
#define  __OBJECT_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif


/**
Object is nothing really, I needed something for
the example.
*/

DECLARE_CLASS( Object );

class Object
{
public:

   //
   // Constructors and destructor
   //

                           /// Default constructor requires ID

                           Object( DwordIdentifierCref );
                           
                           /// Virtual destructor

   virtual                 ~Object( void );


   //
   // Operator overloads
   //

            /// Equality operator

            bool  operator==( ObjectCref ) const;         

   //
   // Accessors
   //

            /**
            Retrieves the identifier of the object instance
            @return Identifier const reference
            */

            DwordIdentifierCref getIdentity( void ) const;

protected:

   //
   // Constructors
   //
                           /// Default constructor

                           Object( void );

                           /// Copy constructor

                           Object( ObjectCref );

   //
   // Operator overloads
   //

            /// Assignment operator

            ObjectRef   operator=( ObjectCref );

private:

            DwordIdentifier  theIdentity;      /// The Object ID
};

#endif

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.3 $
   $Date: 2000/03/01 03:28:18 $
   $Locker:  $
*/


