/**
 * @file libgalago-gtk/galago-gdk-pixbuf-utils.h GdkPixbuf utility functions
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GDK_PIXBUF_H_
#define _GALAGO_GDK_PIXBUF_H_

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libgalago/galago.h>
#include <libgalago-gtk/galago-gtk-types.h>

G_BEGIN_DECLS

GdkPixbuf *galago_gdk_pixbuf_new_generic(int width, int height);

GdkPixbuf *galago_gdk_pixbuf_new_from_image(const GalagoImage *image,
											int width, int height);
GdkPixbuf *galago_gdk_pixbuf_new_from_image_with_size(
	const GalagoImage *image, GtkIconSize size);

GdkPixbuf *galago_gdk_pixbuf_new_from_service(
	const GalagoService *service, int width, int height);
GdkPixbuf *galago_gdk_pixbuf_new_from_service_with_size(
	const GalagoService *service, GtkIconSize size);

GdkPixbuf *galago_gdk_pixbuf_new_from_account(
	const GalagoAccount *account, int width, int height);
GdkPixbuf *galago_gdk_pixbuf_new_from_account_with_size(
	const GalagoAccount *account, GtkIconSize size);

GdkPixbuf *galago_gdk_pixbuf_new_from_presence(
	const GalagoPresence *presence, int width, int height,
	GalagoGtkIconPrecedence precedence);
GdkPixbuf *galago_gdk_pixbuf_new_from_presence_with_size(
	const GalagoPresence *presence, GtkIconSize size,
	GalagoGtkIconPrecedence precedence);

GdkPixbuf *galago_gdk_pixbuf_new_from_person(
	const GalagoPerson *person, int width, int height,
	GalagoGtkIconPrecedence precedence);
GdkPixbuf *galago_gdk_pixbuf_new_from_person_with_size(
	const GalagoPerson *person, GtkIconSize size,
	GalagoGtkIconPrecedence precedence);

G_END_DECLS

#endif /* _GALAGO_GDK_PIXBUF_H_ */
