/**
 * @file libgalago-gtk/galago-gtk-stock.c Stock icons
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libgalago-gtk/galago-gtk-stock.h>
#include <libgalago-gtk/galago-gtk-private.h>
#include <libgalago/galago.h>

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "prefix.h"

static struct StockIcon
{
	const char *name;
	gboolean existing_stock;
	const char *filename;

} const stock_icons[] =
{
	{ GALAGO_GTK_STOCK_PERSON, FALSE, "person.png" },
};

static char *
find_file(const char *basename)
{
	char *path;

	g_return_val_if_fail(basename  != NULL, NULL);
	g_return_val_if_fail(*basename != '\0', NULL);

#ifdef DATADIR
	path = g_build_filename(DATADIR, "pixmaps", "galago", "gtk",
							basename, NULL);

	if (g_file_test(path, G_FILE_TEST_EXISTS))
		return path;

	g_free(path);
#endif

	path = g_build_filename(PIXMAPDIR, basename, NULL);

	if (g_file_test(path, G_FILE_TEST_EXISTS))
		return path;

	g_free(path);

	g_warning(_("Unable to load stock pixmap %s"), basename);

	return NULL;
}

void
galago_gtk_stock_init(void)
{
	static gboolean initted = FALSE;
	GtkIconFactory *factory;
	GtkWidget *win;
	int i;

	if (initted)
		return;

	initted = TRUE;

	factory = gtk_icon_factory_new();

	/* Hack. Leave it alone for now, unless you have a better way. */
	win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize(win);

	for (i = 0; i < G_N_ELEMENTS(stock_icons); i++)
	{
		GdkPixbuf *pixbuf;
		GtkIconSet *iconset;
		gchar *filename;

		if (stock_icons[i].existing_stock)
		{
			iconset = gtk_style_lookup_icon_set(gtk_widget_get_style(win),
												stock_icons[i].filename);
		}
		else
		{
			filename = find_file(stock_icons[i].filename);

			if (filename == NULL)
				continue;

			pixbuf = gdk_pixbuf_new_from_file(filename, NULL);

			g_free(filename);

			iconset = gtk_icon_set_new_from_pixbuf(pixbuf);

			g_object_unref(G_OBJECT(pixbuf));
		}

		gtk_icon_factory_add(factory, stock_icons[i].name, iconset);

		gtk_icon_set_unref(iconset);
	}

	gtk_widget_destroy(win);

	gtk_icon_factory_add_default(factory);
}
