/* timsort.c generated by valac, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TIM_SORT (gee_tim_sort_get_type ())
#define GEE_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TIM_SORT, GeeTimSort))
#define GEE_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TIM_SORT, GeeTimSortClass))
#define GEE_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TIM_SORT))
#define GEE_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TIM_SORT))
#define GEE_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TIM_SORT, GeeTimSortClass))

typedef struct _GeeTimSort GeeTimSort;
typedef struct _GeeTimSortClass GeeTimSortClass;
typedef struct _GeeTimSortPrivate GeeTimSortPrivate;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;
typedef struct _GeeTimSortSlice GeeTimSortSlice;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;

struct _GeeTimSort {
	GObject parent_instance;
	GeeTimSortPrivate * priv;
};

struct _GeeTimSortClass {
	GObjectClass parent_class;
};

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	void** list;
	gint index;
	gint size;
	GeeTimSortSlice** pending;
	gint pending_length1;
	gint _pending_size_;
	gint minimum_gallop;
	GCompareFunc compare;
	GCompareDataFunc compare_data;
	gpointer compare_data_target;
	GDestroyNotify compare_data_target_destroy_notify;
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeArrayList {
	GeeAbstractList parent_instance;
	GeeArrayListPrivate * priv;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _size;
};

struct _GeeArrayListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeTimSortSlice {
	void** list;
	void** new_list;
	gint index;
	gint length;
};

typedef gboolean (*GeeTimSortLowerFunc) (gconstpointer left, gconstpointer right, void* user_data);

static gpointer gee_tim_sort_parent_class = NULL;

GType gee_tim_sort_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_slice_free (GeeTimSortSlice* self);
#define GEE_TIM_SORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TIM_SORT, GeeTimSortPrivate))
enum  {
	GEE_TIM_SORT_DUMMY_PROPERTY,
	GEE_TIM_SORT_G_TYPE,
	GEE_TIM_SORT_G_DUP_FUNC,
	GEE_TIM_SORT_G_DESTROY_FUNC
};
#define GEE_TIM_SORT_MINIMUM_GALLOP 7
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_array_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target);
static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target);
void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare);
void gee_tim_sort_sort_with_data (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare_data, void* compare_data_target);
GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
static void gee_tim_sort_do_sort (GeeTimSort* self);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length);
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending);
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self);
static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset);
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n);
static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value);
static void gee_tim_sort_merge_collapse (GeeTimSort* self);
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self);
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right);
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right);
static void gee_tim_sort_merge_at (GeeTimSort* self, gint index);
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self);
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self);
static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n);
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j);
static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self);
static void gee_tim_sort_finalize (GObject* obj);
static void gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);



#line 49 "timsort.vala"
void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare) {
#line 49 "timsort.vala"
	g_return_if_fail (list != NULL);
#line 50 "timsort.vala"
	if (GEE_IS_ARRAY_LIST (list)) {
#line 51 "timsort.vala"
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, GEE_ARRAY_LIST (list), compare, NULL, NULL);
#line 359 "timsort.c"
	} else {
#line 53 "timsort.vala"
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, list, compare, NULL, NULL);
#line 363 "timsort.c"
	}
}


#line 57 "timsort.vala"
void gee_tim_sort_sort_with_data (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare_data, void* compare_data_target) {
#line 57 "timsort.vala"
	g_return_if_fail (list != NULL);
#line 58 "timsort.vala"
	if (GEE_IS_ARRAY_LIST (list)) {
#line 59 "timsort.vala"
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, GEE_ARRAY_LIST (list), NULL, compare_data, compare_data_target);
#line 376 "timsort.c"
	} else {
#line 61 "timsort.vala"
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, list, NULL, compare_data, compare_data_target);
#line 380 "timsort.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 65 "timsort.vala"
static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target) {
#line 392 "timsort.c"
	GeeTimSort* helper;
	GeeList* _tmp0_;
	gpointer* _tmp2_;
	gint _tmp1_;
	GCompareDataFunc _tmp3_;
#line 65 "timsort.vala"
	g_return_if_fail (list != NULL);
#line 66 "timsort.vala"
	g_assert ((compare != NULL) || (compare_data != NULL));
#line 68 "timsort.vala"
	helper = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 70 "timsort.vala"
	helper->priv->list_collection = (_tmp0_ = _g_object_ref0 (list), _g_object_unref0 (helper->priv->list_collection), _tmp0_);
#line 71 "timsort.vala"
	helper->priv->array = (_tmp2_ = gee_collection_to_array ((GeeCollection*) list, &_tmp1_), helper->priv->array = (_vala_array_free (helper->priv->array, helper->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL), helper->priv->array_length1 = _tmp1_, helper->priv->_array_size_ = helper->priv->array_length1, _tmp2_);
#line 72 "timsort.vala"
	helper->priv->list = helper->priv->array;
#line 73 "timsort.vala"
	helper->priv->index = 0;
#line 74 "timsort.vala"
	helper->priv->size = gee_collection_get_size ((GeeCollection*) list);
#line 75 "timsort.vala"
	helper->priv->compare = compare;
#line 76 "timsort.vala"
	helper->priv->compare_data = (_tmp3_ = compare_data, ((helper->priv->compare_data_target_destroy_notify == NULL) ? NULL : (helper->priv->compare_data_target_destroy_notify (helper->priv->compare_data_target), NULL), helper->priv->compare_data = NULL, helper->priv->compare_data_target = NULL, helper->priv->compare_data_target_destroy_notify = NULL), helper->priv->compare_data_target = compare_data_target, helper->priv->compare_data_target_destroy_notify = NULL, _tmp3_);
#line 78 "timsort.vala"
	gee_tim_sort_do_sort (helper);
#line 81 "timsort.vala"
	gee_collection_clear ((GeeCollection*) list);
#line 422 "timsort.c"
	{
		gpointer* item_collection;
		int item_collection_length1;
		int item_it;
#line 82 "timsort.vala"
		item_collection = helper->priv->array;
#line 429 "timsort.c"
		item_collection_length1 = helper->priv->array_length1;
		for (item_it = 0; item_it < helper->priv->array_length1; item_it = item_it + 1) {
			gconstpointer _tmp4_;
			gpointer item;
			item = (_tmp4_ = item_collection[item_it], ((_tmp4_ == NULL) || (g_dup_func == NULL)) ? ((gpointer) _tmp4_) : g_dup_func ((gpointer) _tmp4_));
			{
#line 83 "timsort.vala"
				gee_collection_add ((GeeCollection*) list, item);
#line 438 "timsort.c"
				_g_destroy_func0 (item);
			}
		}
	}
	_g_object_unref0 (helper);
}


#line 87 "timsort.vala"
static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareFunc compare, GCompareDataFunc compare_data, void* compare_data_target) {
#line 449 "timsort.c"
	GeeTimSort* helper;
	GeeList* _tmp0_;
	GCompareDataFunc _tmp1_;
#line 87 "timsort.vala"
	g_return_if_fail (list != NULL);
#line 88 "timsort.vala"
	g_assert ((compare != NULL) || (compare_data != NULL));
#line 90 "timsort.vala"
	helper = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 92 "timsort.vala"
	helper->priv->list_collection = (_tmp0_ = _g_object_ref0 ((GeeList*) list), _g_object_unref0 (helper->priv->list_collection), _tmp0_);
#line 93 "timsort.vala"
	helper->priv->list = list->_items;
#line 94 "timsort.vala"
	helper->priv->index = 0;
#line 95 "timsort.vala"
	helper->priv->size = list->_size;
#line 96 "timsort.vala"
	helper->priv->compare = compare;
#line 97 "timsort.vala"
	helper->priv->compare_data = (_tmp1_ = compare_data, ((helper->priv->compare_data_target_destroy_notify == NULL) ? NULL : (helper->priv->compare_data_target_destroy_notify (helper->priv->compare_data_target), NULL), helper->priv->compare_data = NULL, helper->priv->compare_data_target = NULL, helper->priv->compare_data_target_destroy_notify = NULL), helper->priv->compare_data_target = compare_data_target, helper->priv->compare_data_target_destroy_notify = NULL, _tmp1_);
#line 99 "timsort.vala"
	gee_tim_sort_do_sort (helper);
#line 473 "timsort.c"
	_g_object_unref0 (helper);
}


static void _vala_array_add1 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GeeTimSortSlice*, *array, *size);
	}
	(*array)[(*length)++] = value;
}


#line 114 "timsort.vala"
static void gee_tim_sort_do_sort (GeeTimSort* self) {
#line 489 "timsort.c"
	GeeTimSortSlice** _tmp0_;
	GeeTimSortSlice* remaining;
	gint minimum_length;
#line 114 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 115 "timsort.vala"
	if (self->priv->size < 2) {
#line 116 "timsort.vala"
		return;
#line 499 "timsort.c"
	}
#line 119 "timsort.vala"
	self->priv->pending = (_tmp0_ = g_new0 (GeeTimSortSlice*, 0 + 1), self->priv->pending = (g_free (self->priv->pending), NULL), self->priv->pending_length1 = 0, self->priv->_pending_size_ = self->priv->pending_length1, _tmp0_);
#line 120 "timsort.vala"
	self->priv->minimum_gallop = GEE_TIM_SORT_MINIMUM_GALLOP;
#line 122 "timsort.vala"
	remaining = gee_tim_sort_slice_new (self->priv->list, self->priv->index, self->priv->size);
#line 123 "timsort.vala"
	minimum_length = gee_tim_sort_compute_minimum_run_length (self, remaining->length);
#line 125 "timsort.vala"
	while (TRUE) {
#line 511 "timsort.c"
		gboolean descending = FALSE;
		GeeTimSortSlice* run;
#line 125 "timsort.vala"
		if (!(remaining->length > 0)) {
#line 125 "timsort.vala"
			break;
#line 518 "timsort.c"
		}
#line 128 "timsort.vala"
		run = gee_tim_sort_compute_longest_run (self, remaining, &descending);
#line 133 "timsort.vala"
		if (descending) {
#line 134 "timsort.vala"
			gee_tim_sort_slice_reverse (run);
#line 526 "timsort.c"
		}
#line 138 "timsort.vala"
		if (run->length < minimum_length) {
#line 530 "timsort.c"
			gint sorted_count;
#line 139 "timsort.vala"
			sorted_count = run->length;
#line 140 "timsort.vala"
			run->length = MIN (minimum_length, remaining->length);
#line 141 "timsort.vala"
			gee_tim_sort_insertion_sort (self, run, sorted_count);
#line 538 "timsort.c"
		}
#line 149 "timsort.vala"
		gee_tim_sort_slice_shorten_start (remaining, run->length);
#line 152 "timsort.vala"
		_vala_array_add1 (&self->priv->pending, &self->priv->pending_length1, &self->priv->_pending_size_, run);
#line 153 "timsort.vala"
		gee_tim_sort_merge_collapse (self);
#line 546 "timsort.c"
	}
#line 156 "timsort.vala"
	g_assert (remaining->index == self->priv->size);
#line 158 "timsort.vala"
	gee_tim_sort_merge_force_collapse (self);
#line 160 "timsort.vala"
	g_assert (self->priv->pending_length1 == 1);
#line 161 "timsort.vala"
	g_assert (self->priv->pending[0]->index == 0);
#line 162 "timsort.vala"
	g_assert (self->priv->pending[0]->length == self->priv->size);
#line 164 "timsort.vala"
	gee_tim_sort_slice_free (remaining);
#line 165 "timsort.vala"
	gee_tim_sort_slice_free (self->priv->pending[0]);
#line 562 "timsort.c"
}


#line 170 "timsort.vala"
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right) {
#line 568 "timsort.c"
	gboolean result = FALSE;
#line 170 "timsort.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 171 "timsort.vala"
	if (self->priv->compare != NULL) {
#line 574 "timsort.c"
		result = self->priv->compare (left, right) < 0;
#line 172 "timsort.vala"
		return result;
#line 578 "timsort.c"
	} else {
		result = self->priv->compare_data (left, right, self->priv->compare_data_target) < 0;
#line 174 "timsort.vala"
		return result;
#line 583 "timsort.c"
	}
}


#line 178 "timsort.vala"
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right) {
#line 590 "timsort.c"
	gboolean result = FALSE;
#line 178 "timsort.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 179 "timsort.vala"
	if (self->priv->compare != NULL) {
#line 596 "timsort.c"
		result = self->priv->compare (left, right) <= 0;
#line 180 "timsort.vala"
		return result;
#line 600 "timsort.c"
	} else {
		result = self->priv->compare_data (left, right, self->priv->compare_data_target) <= 0;
#line 182 "timsort.vala"
		return result;
#line 605 "timsort.c"
	}
}


#line 186 "timsort.vala"
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length) {
#line 612 "timsort.c"
	gint result = 0;
	gint run_length;
#line 186 "timsort.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 187 "timsort.vala"
	run_length = 0;
#line 188 "timsort.vala"
	while (TRUE) {
#line 188 "timsort.vala"
		if (!(length >= 64)) {
#line 188 "timsort.vala"
			break;
#line 625 "timsort.c"
		}
#line 189 "timsort.vala"
		run_length = run_length | (length & 1);
#line 190 "timsort.vala"
		length = length >> 1;
#line 631 "timsort.c"
	}
	result = length + run_length;
#line 192 "timsort.vala"
	return result;
#line 636 "timsort.c"
}


#line 195 "timsort.vala"
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending) {
#line 642 "timsort.c"
	GeeTimSortSlice* result = NULL;
	gint run_length = 0;
#line 195 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 197 "timsort.vala"
	if (a->length <= 1) {
#line 198 "timsort.vala"
		run_length = a->length;
#line 199 "timsort.vala"
		*descending = FALSE;
#line 653 "timsort.c"
	} else {
#line 201 "timsort.vala"
		run_length = 2;
#line 202 "timsort.vala"
		if (gee_tim_sort_lower_than (self, a->list[a->index + 1], a->list[a->index])) {
#line 203 "timsort.vala"
			*descending = TRUE;
#line 661 "timsort.c"
			{
				gint i;
#line 204 "timsort.vala"
				i = a->index + 2;
#line 666 "timsort.c"
				{
					gboolean _tmp0_;
#line 204 "timsort.vala"
					_tmp0_ = TRUE;
#line 204 "timsort.vala"
					while (TRUE) {
#line 204 "timsort.vala"
						if (!_tmp0_) {
#line 204 "timsort.vala"
							i++;
#line 677 "timsort.c"
						}
#line 204 "timsort.vala"
						_tmp0_ = FALSE;
#line 204 "timsort.vala"
						if (!(i < (a->index + a->length))) {
#line 204 "timsort.vala"
							break;
#line 685 "timsort.c"
						}
#line 205 "timsort.vala"
						if (gee_tim_sort_lower_than (self, a->list[i], a->list[i - 1])) {
#line 206 "timsort.vala"
							run_length++;
#line 691 "timsort.c"
						} else {
#line 208 "timsort.vala"
							break;
#line 695 "timsort.c"
						}
					}
				}
			}
		} else {
#line 212 "timsort.vala"
			*descending = FALSE;
#line 703 "timsort.c"
			{
				gint i;
#line 213 "timsort.vala"
				i = a->index + 2;
#line 708 "timsort.c"
				{
					gboolean _tmp1_;
#line 213 "timsort.vala"
					_tmp1_ = TRUE;
#line 213 "timsort.vala"
					while (TRUE) {
#line 213 "timsort.vala"
						if (!_tmp1_) {
#line 213 "timsort.vala"
							i++;
#line 719 "timsort.c"
						}
#line 213 "timsort.vala"
						_tmp1_ = FALSE;
#line 213 "timsort.vala"
						if (!(i < (a->index + a->length))) {
#line 213 "timsort.vala"
							break;
#line 727 "timsort.c"
						}
#line 214 "timsort.vala"
						if (gee_tim_sort_lower_than (self, a->list[i], a->list[i - 1])) {
#line 215 "timsort.vala"
							break;
#line 733 "timsort.c"
						} else {
#line 217 "timsort.vala"
							run_length++;
#line 737 "timsort.c"
						}
					}
				}
			}
		}
	}
	result = gee_tim_sort_slice_new (a->list, a->index, run_length);
#line 222 "timsort.vala"
	return result;
#line 747 "timsort.c"
}


#line 225 "timsort.vala"
static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset) {
#line 225 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 755 "timsort.c"
	{
		gint start;
#line 229 "timsort.vala"
		start = a->index + offset;
#line 760 "timsort.c"
		{
			gboolean _tmp0_;
#line 229 "timsort.vala"
			_tmp0_ = TRUE;
#line 229 "timsort.vala"
			while (TRUE) {
#line 767 "timsort.c"
				gint left;
				gint right;
				void* pivot;
#line 229 "timsort.vala"
				if (!_tmp0_) {
#line 229 "timsort.vala"
					start++;
#line 775 "timsort.c"
				}
#line 229 "timsort.vala"
				_tmp0_ = FALSE;
#line 229 "timsort.vala"
				if (!(start < (a->index + a->length))) {
#line 229 "timsort.vala"
					break;
#line 783 "timsort.c"
				}
#line 230 "timsort.vala"
				left = a->index;
#line 231 "timsort.vala"
				right = start;
#line 232 "timsort.vala"
				pivot = a->list[right];
#line 234 "timsort.vala"
				while (TRUE) {
#line 793 "timsort.c"
					gint p;
#line 234 "timsort.vala"
					if (!(left < right)) {
#line 234 "timsort.vala"
						break;
#line 799 "timsort.c"
					}
#line 235 "timsort.vala"
					p = left + ((right - left) >> 1);
#line 236 "timsort.vala"
					if (gee_tim_sort_lower_than (self, pivot, a->list[p])) {
#line 237 "timsort.vala"
						right = p;
#line 807 "timsort.c"
					} else {
#line 239 "timsort.vala"
						left = p + 1;
#line 811 "timsort.c"
					}
				}
#line 242 "timsort.vala"
				g_assert (left == right);
#line 244 "timsort.vala"
				g_memmove (&a->list[left + 1], &a->list[left], (gsize) (sizeof (gpointer) * (start - left)));
#line 245 "timsort.vala"
				a->list[left] = pivot;
#line 820 "timsort.c"
			}
		}
	}
}


#line 249 "timsort.vala"
static void gee_tim_sort_merge_collapse (GeeTimSort* self) {
#line 829 "timsort.c"
	gint count;
#line 249 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 253 "timsort.vala"
	count = self->priv->pending_length1;
#line 254 "timsort.vala"
	while (TRUE) {
#line 837 "timsort.c"
		gboolean _tmp0_ = FALSE;
#line 254 "timsort.vala"
		if (!(count > 1)) {
#line 254 "timsort.vala"
			break;
#line 843 "timsort.c"
		}
#line 262 "timsort.vala"
		if (count >= 3) {
#line 262 "timsort.vala"
			_tmp0_ = self->priv->pending[count - 3]->length <= (self->priv->pending[count - 2]->length + self->priv->pending[count - 1]->length);
#line 849 "timsort.c"
		} else {
#line 262 "timsort.vala"
			_tmp0_ = FALSE;
#line 853 "timsort.c"
		}
#line 262 "timsort.vala"
		if (_tmp0_) {
#line 263 "timsort.vala"
			if (self->priv->pending[count - 3]->length < self->priv->pending[count - 1]->length) {
#line 264 "timsort.vala"
				gee_tim_sort_merge_at (self, count - 3);
#line 861 "timsort.c"
			} else {
#line 266 "timsort.vala"
				gee_tim_sort_merge_at (self, count - 2);
#line 865 "timsort.c"
			}
		} else {
#line 268 "timsort.vala"
			if (self->priv->pending[count - 2]->length <= self->priv->pending[count - 1]->length) {
#line 269 "timsort.vala"
				gee_tim_sort_merge_at (self, count - 2);
#line 872 "timsort.c"
			} else {
#line 271 "timsort.vala"
				break;
#line 876 "timsort.c"
			}
		}
#line 273 "timsort.vala"
		count = self->priv->pending_length1;
#line 881 "timsort.c"
	}
}


#line 280 "timsort.vala"
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self) {
#line 888 "timsort.c"
	gint count;
#line 280 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 284 "timsort.vala"
	count = self->priv->pending_length1;
#line 288 "timsort.vala"
	while (TRUE) {
#line 896 "timsort.c"
		gboolean _tmp0_ = FALSE;
#line 288 "timsort.vala"
		if (!(count > 1)) {
#line 288 "timsort.vala"
			break;
#line 902 "timsort.c"
		}
#line 289 "timsort.vala"
		if (count >= 3) {
#line 289 "timsort.vala"
			_tmp0_ = self->priv->pending[count - 3]->length < self->priv->pending[count - 1]->length;
#line 908 "timsort.c"
		} else {
#line 289 "timsort.vala"
			_tmp0_ = FALSE;
#line 912 "timsort.c"
		}
#line 289 "timsort.vala"
		if (_tmp0_) {
#line 290 "timsort.vala"
			gee_tim_sort_merge_at (self, count - 3);
#line 918 "timsort.c"
		} else {
#line 292 "timsort.vala"
			gee_tim_sort_merge_at (self, count - 2);
#line 922 "timsort.c"
		}
#line 294 "timsort.vala"
		count = self->priv->pending_length1;
#line 926 "timsort.c"
	}
}


#line 301 "timsort.vala"
static void gee_tim_sort_merge_at (GeeTimSort* self, gint index) {
#line 933 "timsort.c"
	GError * _inner_error_;
	GeeTimSortSlice* a;
	GeeTimSortSlice* b;
#line 301 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 939 "timsort.c"
	_inner_error_ = NULL;
#line 305 "timsort.vala"
	a = self->priv->pending[index];
#line 306 "timsort.vala"
	b = self->priv->pending[index + 1];
#line 945 "timsort.c"
	{
		gint sorted_count;
#line 308 "timsort.vala"
		g_assert (a->length > 0);
#line 309 "timsort.vala"
		g_assert (b->length > 0);
#line 310 "timsort.vala"
		g_assert ((a->index + a->length) == b->index);
#line 312 "timsort.vala"
		self->priv->pending[index] = gee_tim_sort_slice_new (self->priv->list, a->index, a->length + b->length);
#line 313 "timsort.vala"
		_vala_array_move (self->priv->pending, sizeof (GeeTimSortSlice*), index + 2, index + 1, (self->priv->pending_length1 - index) - 2);
#line 314 "timsort.vala"
		self->priv->pending_length1 = self->priv->pending_length1 - 1;
#line 316 "timsort.vala"
		sorted_count = gee_tim_sort_gallop_rightmost (self, gee_tim_sort_slice_peek_first (b), a, 0);
#line 317 "timsort.vala"
		gee_tim_sort_slice_shorten_start (a, sorted_count);
#line 318 "timsort.vala"
		if (a->length == 0) {
#line 966 "timsort.c"
			{
#line 333 "timsort.vala"
				gee_tim_sort_slice_free (a);
#line 334 "timsort.vala"
				gee_tim_sort_slice_free (b);
#line 972 "timsort.c"
			}
#line 319 "timsort.vala"
			return;
#line 976 "timsort.c"
		}
#line 322 "timsort.vala"
		b->length = gee_tim_sort_gallop_leftmost (self, gee_tim_sort_slice_peek_last (a), b, b->length - 1);
#line 323 "timsort.vala"
		if (b->length == 0) {
#line 982 "timsort.c"
			{
#line 333 "timsort.vala"
				gee_tim_sort_slice_free (a);
#line 334 "timsort.vala"
				gee_tim_sort_slice_free (b);
#line 988 "timsort.c"
			}
#line 324 "timsort.vala"
			return;
#line 992 "timsort.c"
		}
#line 327 "timsort.vala"
		if (a->length <= b->length) {
#line 328 "timsort.vala"
			gee_tim_sort_merge_low (self, a, b);
#line 998 "timsort.c"
		} else {
#line 330 "timsort.vala"
			gee_tim_sort_merge_high (self, a, b);
#line 1002 "timsort.c"
		}
	}
	__finally0:
	{
#line 333 "timsort.vala"
		gee_tim_sort_slice_free (a);
#line 334 "timsort.vala"
		gee_tim_sort_slice_free (b);
#line 1011 "timsort.c"
	}
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 338 "timsort.vala"
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
#line 1023 "timsort.c"
	gint result = 0;
	gint p;
	gint last_offset;
	gint offset;
#line 338 "timsort.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 342 "timsort.vala"
	g_assert (0 <= hint);
#line 343 "timsort.vala"
	g_assert (hint < a->length);
#line 345 "timsort.vala"
	p = a->index + hint;
#line 346 "timsort.vala"
	last_offset = 0;
#line 347 "timsort.vala"
	offset = 1;
#line 348 "timsort.vala"
	if (gee_tim_sort_lower_than (self, a->list[p], key)) {
#line 1042 "timsort.c"
		gint max_offset;
#line 349 "timsort.vala"
		max_offset = a->length - hint;
#line 350 "timsort.vala"
		while (TRUE) {
#line 350 "timsort.vala"
			if (!(offset < max_offset)) {
#line 350 "timsort.vala"
				break;
#line 1052 "timsort.c"
			}
#line 351 "timsort.vala"
			if (gee_tim_sort_lower_than (self, a->list[p + offset], key)) {
#line 352 "timsort.vala"
				last_offset = offset;
#line 353 "timsort.vala"
				offset = offset << 1;
#line 354 "timsort.vala"
				offset++;
#line 1062 "timsort.c"
			} else {
#line 356 "timsort.vala"
				break;
#line 1066 "timsort.c"
			}
		}
#line 360 "timsort.vala"
		if (offset > max_offset) {
#line 361 "timsort.vala"
			offset = max_offset;
#line 1073 "timsort.c"
		}
#line 364 "timsort.vala"
		last_offset = hint + last_offset;
#line 365 "timsort.vala"
		offset = hint + offset;
#line 1079 "timsort.c"
	} else {
		gint max_offset;
		gint temp_last_offset;
		gint temp_offset;
#line 367 "timsort.vala"
		max_offset = hint + 1;
#line 368 "timsort.vala"
		while (TRUE) {
#line 368 "timsort.vala"
			if (!(offset < max_offset)) {
#line 368 "timsort.vala"
				break;
#line 1092 "timsort.c"
			}
#line 369 "timsort.vala"
			if (gee_tim_sort_lower_than (self, a->list[p - offset], key)) {
#line 370 "timsort.vala"
				break;
#line 1098 "timsort.c"
			} else {
#line 372 "timsort.vala"
				last_offset = offset;
#line 373 "timsort.vala"
				offset = offset << 1;
#line 374 "timsort.vala"
				offset++;
#line 1106 "timsort.c"
			}
		}
#line 378 "timsort.vala"
		if (offset > max_offset) {
#line 379 "timsort.vala"
			offset = max_offset;
#line 1113 "timsort.c"
		}
#line 382 "timsort.vala"
		temp_last_offset = last_offset;
#line 383 "timsort.vala"
		temp_offset = offset;
#line 384 "timsort.vala"
		last_offset = hint - temp_offset;
#line 385 "timsort.vala"
		offset = hint - temp_last_offset;
#line 1123 "timsort.c"
	}
#line 388 "timsort.vala"
	g_assert ((-1) <= last_offset);
#line 389 "timsort.vala"
	g_assert (last_offset < offset);
#line 390 "timsort.vala"
	g_assert (offset <= a->length);
#line 392 "timsort.vala"
	last_offset = last_offset + 1;
#line 393 "timsort.vala"
	while (TRUE) {
#line 1135 "timsort.c"
		gint m;
#line 393 "timsort.vala"
		if (!(last_offset < offset)) {
#line 393 "timsort.vala"
			break;
#line 1141 "timsort.c"
		}
#line 394 "timsort.vala"
		m = last_offset + ((offset - last_offset) >> 1);
#line 395 "timsort.vala"
		if (gee_tim_sort_lower_than (self, a->list[a->index + m], key)) {
#line 396 "timsort.vala"
			last_offset = m + 1;
#line 1149 "timsort.c"
		} else {
#line 398 "timsort.vala"
			offset = m;
#line 1153 "timsort.c"
		}
	}
#line 402 "timsort.vala"
	g_assert (last_offset == offset);
#line 1158 "timsort.c"
	result = offset;
#line 403 "timsort.vala"
	return result;
#line 1162 "timsort.c"
}


#line 406 "timsort.vala"
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
#line 1168 "timsort.c"
	gint result = 0;
	gint p;
	gint last_offset;
	gint offset;
#line 406 "timsort.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 410 "timsort.vala"
	g_assert (0 <= hint);
#line 411 "timsort.vala"
	g_assert (hint < a->length);
#line 413 "timsort.vala"
	p = a->index + hint;
#line 414 "timsort.vala"
	last_offset = 0;
#line 415 "timsort.vala"
	offset = 1;
#line 416 "timsort.vala"
	if (gee_tim_sort_lower_than_or_equal_to (self, a->list[p], key)) {
#line 1187 "timsort.c"
		gint max_offset;
#line 417 "timsort.vala"
		max_offset = a->length - hint;
#line 418 "timsort.vala"
		while (TRUE) {
#line 418 "timsort.vala"
			if (!(offset < max_offset)) {
#line 418 "timsort.vala"
				break;
#line 1197 "timsort.c"
			}
#line 419 "timsort.vala"
			if (gee_tim_sort_lower_than_or_equal_to (self, a->list[p + offset], key)) {
#line 420 "timsort.vala"
				last_offset = offset;
#line 421 "timsort.vala"
				offset = offset << 1;
#line 422 "timsort.vala"
				offset++;
#line 1207 "timsort.c"
			} else {
#line 424 "timsort.vala"
				break;
#line 1211 "timsort.c"
			}
		}
#line 428 "timsort.vala"
		if (offset > max_offset) {
#line 429 "timsort.vala"
			offset = max_offset;
#line 1218 "timsort.c"
		}
#line 432 "timsort.vala"
		last_offset = hint + last_offset;
#line 433 "timsort.vala"
		offset = hint + offset;
#line 1224 "timsort.c"
	} else {
		gint max_offset;
		gint temp_last_offset;
		gint temp_offset;
#line 435 "timsort.vala"
		max_offset = hint + 1;
#line 436 "timsort.vala"
		while (TRUE) {
#line 436 "timsort.vala"
			if (!(offset < max_offset)) {
#line 436 "timsort.vala"
				break;
#line 1237 "timsort.c"
			}
#line 437 "timsort.vala"
			if (gee_tim_sort_lower_than_or_equal_to (self, a->list[p - offset], key)) {
#line 438 "timsort.vala"
				break;
#line 1243 "timsort.c"
			} else {
#line 440 "timsort.vala"
				last_offset = offset;
#line 441 "timsort.vala"
				offset = offset << 1;
#line 442 "timsort.vala"
				offset++;
#line 1251 "timsort.c"
			}
		}
#line 446 "timsort.vala"
		if (offset > max_offset) {
#line 447 "timsort.vala"
			offset = max_offset;
#line 1258 "timsort.c"
		}
#line 450 "timsort.vala"
		temp_last_offset = last_offset;
#line 451 "timsort.vala"
		temp_offset = offset;
#line 452 "timsort.vala"
		last_offset = hint - temp_offset;
#line 453 "timsort.vala"
		offset = hint - temp_last_offset;
#line 1268 "timsort.c"
	}
#line 456 "timsort.vala"
	g_assert ((-1) <= last_offset);
#line 457 "timsort.vala"
	g_assert (last_offset < offset);
#line 458 "timsort.vala"
	g_assert (offset <= a->length);
#line 460 "timsort.vala"
	last_offset = last_offset + 1;
#line 461 "timsort.vala"
	while (TRUE) {
#line 1280 "timsort.c"
		gint m;
#line 461 "timsort.vala"
		if (!(last_offset < offset)) {
#line 461 "timsort.vala"
			break;
#line 1286 "timsort.c"
		}
#line 462 "timsort.vala"
		m = last_offset + ((offset - last_offset) >> 1);
#line 463 "timsort.vala"
		if (gee_tim_sort_lower_than_or_equal_to (self, a->list[a->index + m], key)) {
#line 464 "timsort.vala"
			last_offset = m + 1;
#line 1294 "timsort.c"
		} else {
#line 466 "timsort.vala"
			offset = m;
#line 1298 "timsort.c"
		}
	}
#line 470 "timsort.vala"
	g_assert (last_offset == offset);
#line 1303 "timsort.c"
	result = offset;
#line 471 "timsort.vala"
	return result;
#line 1307 "timsort.c"
}


#line 474 "timsort.vala"
static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
#line 1313 "timsort.c"
	GError * _inner_error_;
	gint minimum_gallop;
	gint dest;
#line 474 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 1319 "timsort.c"
	_inner_error_ = NULL;
#line 478 "timsort.vala"
	g_assert (a->length > 0);
#line 479 "timsort.vala"
	g_assert (b->length > 0);
#line 480 "timsort.vala"
	g_assert ((a->index + a->length) == b->index);
#line 482 "timsort.vala"
	minimum_gallop = self->priv->minimum_gallop;
#line 483 "timsort.vala"
	dest = a->index;
#line 484 "timsort.vala"
	gee_tim_sort_slice_copy (a);
#line 1333 "timsort.c"
	{
		gboolean _tmp0_ = FALSE;
#line 487 "timsort.vala"
		self->priv->list[dest++] = gee_tim_sort_slice_pop_first (b);
#line 488 "timsort.vala"
		if (a->length == 1) {
#line 488 "timsort.vala"
			_tmp0_ = TRUE;
#line 1342 "timsort.c"
		} else {
#line 488 "timsort.vala"
			_tmp0_ = b->length == 0;
#line 1346 "timsort.c"
		}
#line 488 "timsort.vala"
		if (_tmp0_) {
#line 1350 "timsort.c"
			{
#line 563 "timsort.vala"
				g_assert (a->length >= 0);
#line 564 "timsort.vala"
				g_assert (b->length >= 0);
#line 565 "timsort.vala"
				gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
				gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1360 "timsort.c"
			}
#line 489 "timsort.vala"
			return;
#line 1364 "timsort.c"
		}
#line 492 "timsort.vala"
		while (TRUE) {
#line 1368 "timsort.c"
			gint a_count;
			gint b_count;
#line 493 "timsort.vala"
			a_count = 0;
#line 494 "timsort.vala"
			b_count = 0;
#line 496 "timsort.vala"
			while (TRUE) {
#line 497 "timsort.vala"
				if (gee_tim_sort_lower_than (self, gee_tim_sort_slice_peek_first (b), gee_tim_sort_slice_peek_first (a))) {
#line 498 "timsort.vala"
					self->priv->list[dest++] = gee_tim_sort_slice_pop_first (b);
#line 499 "timsort.vala"
					if (b->length == 0) {
#line 1383 "timsort.c"
						{
#line 563 "timsort.vala"
							g_assert (a->length >= 0);
#line 564 "timsort.vala"
							g_assert (b->length >= 0);
#line 565 "timsort.vala"
							gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
							gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1393 "timsort.c"
						}
#line 500 "timsort.vala"
						return;
#line 1397 "timsort.c"
					}
#line 503 "timsort.vala"
					b_count++;
#line 504 "timsort.vala"
					a_count = 0;
#line 505 "timsort.vala"
					if (b_count >= minimum_gallop) {
#line 506 "timsort.vala"
						break;
#line 1407 "timsort.c"
					}
				} else {
#line 509 "timsort.vala"
					self->priv->list[dest++] = gee_tim_sort_slice_pop_first (a);
#line 510 "timsort.vala"
					if (a->length == 1) {
#line 1414 "timsort.c"
						{
#line 563 "timsort.vala"
							g_assert (a->length >= 0);
#line 564 "timsort.vala"
							g_assert (b->length >= 0);
#line 565 "timsort.vala"
							gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
							gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1424 "timsort.c"
						}
#line 511 "timsort.vala"
						return;
#line 1428 "timsort.c"
					}
#line 514 "timsort.vala"
					a_count++;
#line 515 "timsort.vala"
					b_count = 0;
#line 516 "timsort.vala"
					if (a_count >= minimum_gallop) {
#line 517 "timsort.vala"
						break;
#line 1438 "timsort.c"
					}
				}
			}
#line 522 "timsort.vala"
			minimum_gallop++;
#line 524 "timsort.vala"
			while (TRUE) {
#line 1446 "timsort.c"
				gint _tmp1_ = 0;
				gboolean _tmp2_ = FALSE;
#line 525 "timsort.vala"
				if (minimum_gallop > 1) {
#line 525 "timsort.vala"
					_tmp1_ = 1;
#line 1453 "timsort.c"
				} else {
#line 525 "timsort.vala"
					_tmp1_ = 0;
#line 1457 "timsort.c"
				}
#line 525 "timsort.vala"
				minimum_gallop = minimum_gallop - _tmp1_;
#line 526 "timsort.vala"
				self->priv->minimum_gallop = minimum_gallop;
#line 528 "timsort.vala"
				a_count = gee_tim_sort_gallop_rightmost (self, gee_tim_sort_slice_peek_first (b), a, 0);
#line 529 "timsort.vala"
				gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest, a_count);
#line 530 "timsort.vala"
				dest = dest + a_count;
#line 531 "timsort.vala"
				gee_tim_sort_slice_shorten_start (a, a_count);
#line 532 "timsort.vala"
				if (a->length <= 1) {
#line 1473 "timsort.c"
					{
#line 563 "timsort.vala"
						g_assert (a->length >= 0);
#line 564 "timsort.vala"
						g_assert (b->length >= 0);
#line 565 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1483 "timsort.c"
					}
#line 533 "timsort.vala"
					return;
#line 1487 "timsort.c"
				}
#line 536 "timsort.vala"
				self->priv->list[dest++] = gee_tim_sort_slice_pop_first (b);
#line 537 "timsort.vala"
				if (b->length == 0) {
#line 1493 "timsort.c"
					{
#line 563 "timsort.vala"
						g_assert (a->length >= 0);
#line 564 "timsort.vala"
						g_assert (b->length >= 0);
#line 565 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1503 "timsort.c"
					}
#line 538 "timsort.vala"
					return;
#line 1507 "timsort.c"
				}
#line 541 "timsort.vala"
				b_count = gee_tim_sort_gallop_leftmost (self, gee_tim_sort_slice_peek_first (a), b, 0);
#line 542 "timsort.vala"
				gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b_count);
#line 543 "timsort.vala"
				dest = dest + b_count;
#line 544 "timsort.vala"
				gee_tim_sort_slice_shorten_start (b, b_count);
#line 545 "timsort.vala"
				if (b->length == 0) {
#line 1519 "timsort.c"
					{
#line 563 "timsort.vala"
						g_assert (a->length >= 0);
#line 564 "timsort.vala"
						g_assert (b->length >= 0);
#line 565 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1529 "timsort.c"
					}
#line 546 "timsort.vala"
					return;
#line 1533 "timsort.c"
				}
#line 549 "timsort.vala"
				self->priv->list[dest++] = gee_tim_sort_slice_pop_first (a);
#line 550 "timsort.vala"
				if (a->length == 1) {
#line 1539 "timsort.c"
					{
#line 563 "timsort.vala"
						g_assert (a->length >= 0);
#line 564 "timsort.vala"
						g_assert (b->length >= 0);
#line 565 "timsort.vala"
						gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
						gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1549 "timsort.c"
					}
#line 551 "timsort.vala"
					return;
#line 1553 "timsort.c"
				}
#line 554 "timsort.vala"
				if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
#line 554 "timsort.vala"
					_tmp2_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
#line 1559 "timsort.c"
				} else {
#line 554 "timsort.vala"
					_tmp2_ = FALSE;
#line 1563 "timsort.c"
				}
#line 554 "timsort.vala"
				if (_tmp2_) {
#line 555 "timsort.vala"
					break;
#line 1569 "timsort.c"
				}
			}
#line 559 "timsort.vala"
			minimum_gallop++;
#line 560 "timsort.vala"
			self->priv->minimum_gallop = minimum_gallop;
#line 1576 "timsort.c"
		}
	}
	__finally1:
	{
#line 563 "timsort.vala"
		g_assert (a->length >= 0);
#line 564 "timsort.vala"
		g_assert (b->length >= 0);
#line 565 "timsort.vala"
		gee_tim_sort_slice_merge_in (b, self->priv->list, b->index, dest, b->length);
#line 566 "timsort.vala"
		gee_tim_sort_slice_merge_in (a, self->priv->list, a->index, dest + b->length, a->length);
#line 1589 "timsort.c"
	}
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 570 "timsort.vala"
static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
#line 1601 "timsort.c"
	GError * _inner_error_;
	gint minimum_gallop;
	gint dest;
#line 570 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 1607 "timsort.c"
	_inner_error_ = NULL;
#line 574 "timsort.vala"
	g_assert (a->length > 0);
#line 575 "timsort.vala"
	g_assert (b->length > 0);
#line 576 "timsort.vala"
	g_assert ((a->index + a->length) == b->index);
#line 578 "timsort.vala"
	minimum_gallop = self->priv->minimum_gallop;
#line 579 "timsort.vala"
	dest = b->index + b->length;
#line 580 "timsort.vala"
	gee_tim_sort_slice_copy (b);
#line 1621 "timsort.c"
	{
		gboolean _tmp0_ = FALSE;
#line 583 "timsort.vala"
		self->priv->list[dest = dest - 1] = gee_tim_sort_slice_pop_last (a);
#line 584 "timsort.vala"
		if (a->length == 0) {
#line 584 "timsort.vala"
			_tmp0_ = TRUE;
#line 1630 "timsort.c"
		} else {
#line 584 "timsort.vala"
			_tmp0_ = b->length == 1;
#line 1634 "timsort.c"
		}
#line 584 "timsort.vala"
		if (_tmp0_) {
#line 1638 "timsort.c"
			{
#line 661 "timsort.vala"
				g_assert (a->length >= 0);
#line 662 "timsort.vala"
				g_assert (b->length >= 0);
#line 663 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1648 "timsort.c"
			}
#line 585 "timsort.vala"
			return;
#line 1652 "timsort.c"
		}
#line 588 "timsort.vala"
		while (TRUE) {
#line 1656 "timsort.c"
			gint a_count;
			gint b_count;
#line 589 "timsort.vala"
			a_count = 0;
#line 590 "timsort.vala"
			b_count = 0;
#line 592 "timsort.vala"
			while (TRUE) {
#line 593 "timsort.vala"
				if (gee_tim_sort_lower_than (self, gee_tim_sort_slice_peek_last (b), gee_tim_sort_slice_peek_last (a))) {
#line 594 "timsort.vala"
					self->priv->list[dest = dest - 1] = gee_tim_sort_slice_pop_last (a);
#line 595 "timsort.vala"
					if (a->length == 0) {
#line 1671 "timsort.c"
						{
#line 661 "timsort.vala"
							g_assert (a->length >= 0);
#line 662 "timsort.vala"
							g_assert (b->length >= 0);
#line 663 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1681 "timsort.c"
						}
#line 596 "timsort.vala"
						return;
#line 1685 "timsort.c"
					}
#line 599 "timsort.vala"
					a_count++;
#line 600 "timsort.vala"
					b_count = 0;
#line 601 "timsort.vala"
					if (a_count >= minimum_gallop) {
#line 602 "timsort.vala"
						break;
#line 1695 "timsort.c"
					}
				} else {
#line 605 "timsort.vala"
					self->priv->list[dest = dest - 1] = gee_tim_sort_slice_pop_last (b);
#line 606 "timsort.vala"
					if (b->length == 1) {
#line 1702 "timsort.c"
						{
#line 661 "timsort.vala"
							g_assert (a->length >= 0);
#line 662 "timsort.vala"
							g_assert (b->length >= 0);
#line 663 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
							gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1712 "timsort.c"
						}
#line 607 "timsort.vala"
						return;
#line 1716 "timsort.c"
					}
#line 610 "timsort.vala"
					b_count++;
#line 611 "timsort.vala"
					a_count = 0;
#line 612 "timsort.vala"
					if (b_count >= minimum_gallop) {
#line 613 "timsort.vala"
						break;
#line 1726 "timsort.c"
					}
				}
			}
#line 618 "timsort.vala"
			minimum_gallop++;
#line 620 "timsort.vala"
			while (TRUE) {
#line 1734 "timsort.c"
				gint _tmp1_ = 0;
				gint k;
				gboolean _tmp2_ = FALSE;
#line 621 "timsort.vala"
				if (minimum_gallop > 1) {
#line 621 "timsort.vala"
					_tmp1_ = 1;
#line 1742 "timsort.c"
				} else {
#line 621 "timsort.vala"
					_tmp1_ = 0;
#line 1746 "timsort.c"
				}
#line 621 "timsort.vala"
				minimum_gallop = minimum_gallop - _tmp1_;
#line 622 "timsort.vala"
				self->priv->minimum_gallop = minimum_gallop;
#line 624 "timsort.vala"
				k = gee_tim_sort_gallop_rightmost (self, gee_tim_sort_slice_peek_last (b), a, a->length - 1);
#line 625 "timsort.vala"
				a_count = a->length - k;
#line 626 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index + k, dest - a_count, a_count);
#line 627 "timsort.vala"
				dest = dest - a_count;
#line 628 "timsort.vala"
				gee_tim_sort_slice_shorten_end (a, a_count);
#line 629 "timsort.vala"
				if (a->length == 0) {
#line 1764 "timsort.c"
					{
#line 661 "timsort.vala"
						g_assert (a->length >= 0);
#line 662 "timsort.vala"
						g_assert (b->length >= 0);
#line 663 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1774 "timsort.c"
					}
#line 630 "timsort.vala"
					return;
#line 1778 "timsort.c"
				}
#line 633 "timsort.vala"
				self->priv->list[dest = dest - 1] = gee_tim_sort_slice_pop_last (b);
#line 634 "timsort.vala"
				if (b->length == 1) {
#line 1784 "timsort.c"
					{
#line 661 "timsort.vala"
						g_assert (a->length >= 0);
#line 662 "timsort.vala"
						g_assert (b->length >= 0);
#line 663 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1794 "timsort.c"
					}
#line 635 "timsort.vala"
					return;
#line 1798 "timsort.c"
				}
#line 638 "timsort.vala"
				k = gee_tim_sort_gallop_leftmost (self, gee_tim_sort_slice_peek_last (a), b, b->length - 1);
#line 639 "timsort.vala"
				b_count = b->length - k;
#line 640 "timsort.vala"
				gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index + k, dest - b_count, b_count);
#line 641 "timsort.vala"
				dest = dest - b_count;
#line 642 "timsort.vala"
				gee_tim_sort_slice_shorten_end (b, b_count);
#line 643 "timsort.vala"
				if (b->length <= 1) {
#line 1812 "timsort.c"
					{
#line 661 "timsort.vala"
						g_assert (a->length >= 0);
#line 662 "timsort.vala"
						g_assert (b->length >= 0);
#line 663 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1822 "timsort.c"
					}
#line 644 "timsort.vala"
					return;
#line 1826 "timsort.c"
				}
#line 647 "timsort.vala"
				self->priv->list[dest = dest - 1] = gee_tim_sort_slice_pop_last (a);
#line 648 "timsort.vala"
				if (a->length == 0) {
#line 1832 "timsort.c"
					{
#line 661 "timsort.vala"
						g_assert (a->length >= 0);
#line 662 "timsort.vala"
						g_assert (b->length >= 0);
#line 663 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
						gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1842 "timsort.c"
					}
#line 649 "timsort.vala"
					return;
#line 1846 "timsort.c"
				}
#line 652 "timsort.vala"
				if (a_count < GEE_TIM_SORT_MINIMUM_GALLOP) {
#line 652 "timsort.vala"
					_tmp2_ = b_count < GEE_TIM_SORT_MINIMUM_GALLOP;
#line 1852 "timsort.c"
				} else {
#line 652 "timsort.vala"
					_tmp2_ = FALSE;
#line 1856 "timsort.c"
				}
#line 652 "timsort.vala"
				if (_tmp2_) {
#line 653 "timsort.vala"
					break;
#line 1862 "timsort.c"
				}
			}
#line 657 "timsort.vala"
			minimum_gallop++;
#line 658 "timsort.vala"
			self->priv->minimum_gallop = minimum_gallop;
#line 1869 "timsort.c"
		}
	}
	__finally2:
	{
#line 661 "timsort.vala"
		g_assert (a->length >= 0);
#line 662 "timsort.vala"
		g_assert (b->length >= 0);
#line 663 "timsort.vala"
		gee_tim_sort_slice_merge_in_reversed (a, self->priv->list, a->index, dest - a->length, a->length);
#line 664 "timsort.vala"
		gee_tim_sort_slice_merge_in_reversed (b, self->priv->list, b->index, (dest - a->length) - b->length, b->length);
#line 1882 "timsort.c"
	}
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 47 "timsort.vala"
GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
#line 1894 "timsort.c"
	GeeTimSort * self;
#line 47 "timsort.vala"
	self = (GeeTimSort*) g_object_new (object_type, NULL);
#line 47 "timsort.vala"
	self->priv->g_type = g_type;
#line 47 "timsort.vala"
	self->priv->g_dup_func = g_dup_func;
#line 47 "timsort.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 1904 "timsort.c"
	return self;
}


#line 47 "timsort.vala"
GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
#line 47 "timsort.vala"
	return gee_tim_sort_construct (GEE_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
#line 1913 "timsort.c"
}


#line 676 "timsort.vala"
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length) {
#line 1919 "timsort.c"
	GeeTimSortSlice* self;
	self = g_slice_new0 (GeeTimSortSlice);
	gee_tim_sort_slice_instance_init (self);
#line 677 "timsort.vala"
	self->list = list;
#line 678 "timsort.vala"
	self->index = index;
#line 679 "timsort.vala"
	self->length = length;
#line 1929 "timsort.c"
	return self;
}


#line 682 "timsort.vala"
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self) {
#line 682 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 683 "timsort.vala"
	self->new_list = g_memdup (&self->list[self->index], ((guint) sizeof (gpointer)) * self->length);
#line 684 "timsort.vala"
	self->list = self->new_list;
#line 685 "timsort.vala"
	self->index = 0;
#line 1944 "timsort.c"
}


#line 688 "timsort.vala"
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
#line 688 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 689 "timsort.vala"
	g_memmove (&dest_array[dest_index], &self->list[index], (gsize) (sizeof (gpointer) * count));
#line 1954 "timsort.c"
}


#line 692 "timsort.vala"
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
#line 692 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 693 "timsort.vala"
	g_memmove (&dest_array[dest_index], &self->list[index], (gsize) (sizeof (gpointer) * count));
#line 1964 "timsort.c"
}


#line 696 "timsort.vala"
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n) {
#line 696 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 697 "timsort.vala"
	self->index = self->index + n;
#line 698 "timsort.vala"
	self->length = self->length - n;
#line 1976 "timsort.c"
}


#line 701 "timsort.vala"
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n) {
#line 701 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 702 "timsort.vala"
	self->length = self->length - n;
#line 1986 "timsort.c"
}


#line 705 "timsort.vala"
static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self) {
#line 1992 "timsort.c"
	void* result = NULL;
#line 705 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 706 "timsort.vala"
	self->length--;
#line 1998 "timsort.c"
	result = self->list[self->index++];
#line 707 "timsort.vala"
	return result;
#line 2002 "timsort.c"
}


#line 710 "timsort.vala"
static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self) {
#line 2008 "timsort.c"
	void* result = NULL;
#line 710 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 711 "timsort.vala"
	self->length--;
#line 2014 "timsort.c"
	result = self->list[self->index + self->length];
#line 712 "timsort.vala"
	return result;
#line 2018 "timsort.c"
}


#line 715 "timsort.vala"
static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self) {
#line 2024 "timsort.c"
	void* result = NULL;
#line 715 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2028 "timsort.c"
	result = self->list[self->index];
#line 716 "timsort.vala"
	return result;
#line 2032 "timsort.c"
}


#line 719 "timsort.vala"
static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self) {
#line 2038 "timsort.c"
	void* result = NULL;
#line 719 "timsort.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2042 "timsort.c"
	result = self->list[(self->index + self->length) - 1];
#line 720 "timsort.vala"
	return result;
#line 2046 "timsort.c"
}


#line 723 "timsort.vala"
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self) {
#line 2052 "timsort.c"
	gint low;
	gint high;
#line 723 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 724 "timsort.vala"
	low = self->index;
#line 725 "timsort.vala"
	high = (self->index + self->length) - 1;
#line 726 "timsort.vala"
	while (TRUE) {
#line 726 "timsort.vala"
		if (!(low < high)) {
#line 726 "timsort.vala"
			break;
#line 2067 "timsort.c"
		}
#line 727 "timsort.vala"
		gee_tim_sort_slice_swap (self, low++, high--);
#line 2071 "timsort.c"
	}
}


#line 731 "timsort.vala"
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j) {
#line 2078 "timsort.c"
	void* temp;
#line 731 "timsort.vala"
	g_return_if_fail (self != NULL);
#line 732 "timsort.vala"
	temp = self->list[i];
#line 733 "timsort.vala"
	self->list[i] = self->list[j];
#line 734 "timsort.vala"
	self->list[j] = temp;
#line 2088 "timsort.c"
}


static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self) {
}


static void gee_tim_sort_slice_free (GeeTimSortSlice* self) {
	g_slice_free (GeeTimSortSlice, self);
}


static void gee_tim_sort_class_init (GeeTimSortClass * klass) {
	gee_tim_sort_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTimSortPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_tim_sort_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tim_sort_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tim_sort_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tim_sort_instance_init (GeeTimSort * self) {
	self->priv = GEE_TIM_SORT_GET_PRIVATE (self);
}


static void gee_tim_sort_finalize (GObject* obj) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (obj);
	_g_object_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (g_free (self->priv->pending), NULL);
	(self->priv->compare_data_target_destroy_notify == NULL) ? NULL : (self->priv->compare_data_target_destroy_notify (self->priv->compare_data_target), NULL);
	self->priv->compare_data = NULL;
	self->priv->compare_data_target = NULL;
	self->priv->compare_data_target_destroy_notify = NULL;
	G_OBJECT_CLASS (gee_tim_sort_parent_class)->finalize (obj);
}


/**
 * A stable, adaptive, iterative mergesort that requires far fewer than n*lg(n)
 * comparisons when running on partially sorted arrays, while offering
 * performance comparable to a traditional mergesort when run on random arrays.
 * Like all proper mergesorts, this sort is stable and runs O(n*log(n)) time
 * (worst case). In the worst case, this sort requires temporary storage space
 * for n/2 object references; in the best case, it requires only a small
 * constant amount of space.
 *
 * This implementation was adapted from Tim Peters's list sort for Python,
 * which is described in detail here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listsort.txt]]
 *
 * Tim's C code may be found here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listobject.c]]
 *
 * The underlying techniques are described in this paper (and may have even
 * earlier origins):
 *
 *   "Optimistic Sorting and Information Theoretic Complexity"
 *   Peter McIlroy
 *   SODA (Fourth Annual ACM-SIAM Symposium on Discrete Algorithms), pp
 *   467-474, Austin, Texas, 25-27 January 1993.
 */
GType gee_tim_sort_get_type (void) {
	static volatile gsize gee_tim_sort_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tim_sort_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTimSort), 0, (GInstanceInitFunc) gee_tim_sort_instance_init, NULL };
		GType gee_tim_sort_type_id;
		gee_tim_sort_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTimSort", &g_define_type_info, 0);
		g_once_init_leave (&gee_tim_sort_type_id__volatile, gee_tim_sort_type_id);
	}
	return gee_tim_sort_type_id__volatile;
}


static void gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = GEE_TIM_SORT (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TIM_SORT_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TIM_SORT_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TIM_SORT_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if (src < dest) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	}
}




