/*******************************************************************************************************************************************
 cmetamodule.h
 
 Metamodule definition i.e. an object that is to be described in a dynamic linked library and to be explicitly loaded by an application
 kernel from a specified API.

 The metamodules libraries should be compiled as follow :
 	c++ -shared [-nostartfiles if _init() et _fini() are exported] -o libname.so f1.o f2.o fn.o
*******************************************************************************************************************************************/

#ifndef __CMETAMODULE_H__
#define __CMETAMODULE_H__

#include "cserialized.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// CMetaModule class
//------------------------------------------------------------------------------------------------------------------------------------------
class CMetaModule : public CSerialized
{
	// instanciation section 
	public :

		CMetaModule			();
		virtual ~CMetaModule		()=0;

		// generic metaclass
		SECTION_GENERIC_METACLASS;
};

//------------------------------------------------------------------------------------------------------------------------------------------
// metaclass and class tag declaration
//------------------------------------------------------------------------------------------------------------------------------------------
DECLARE_GENERIC_METACLASS ('mtmx', CMetaModule, CSerialized);

//------------------------------------------------------------------------------------------------------------------------------------------
// object export declaration macro
//------------------------------------------------------------------------------------------------------------------------------------------
#define DECLARE_METAMODULE_EXPORT(classname) const CMetaClass * GetModuleMetaClass () { return __metaclass(classname); }

#endif
