/*
******************************************************************************

   LibGGIMisc implementation for "svgalib" target -- API functions.
  
   Copyright (c) 2001 Brian S. Julin		bri@calyx.com
   Copyright (c) 1998-1999 Marcus Sundberg      marcus@ggi-project.org   
   Copyright (c) 1998      Steve Cheng          steve@ggi-project.org
   Copyright (c) 1997      Jason McMullan       jmcc@ggi-project.org
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


******************************************************************************
*/

#include <stdio.h>
#include <vga.h>
#include "svgalibggimisc.h"


/* _All_ non-local (ie not declared 'static') functions and variables _must_
   be prefixed with the extension name, and for sublibs also with a unique
   sublib identifier. This is to keep the namespace clean on systems where
   all symbols are exported by default.
*/

/*-* API Implementation */

int GGIMISC_Svgalib_WaitRayPos(ggi_visual *vis, sint32 *x, sint32 *y) {
        if (*y == GGI_RP_SYNC && *x == GGI_RP_DONTCARE) {
	  vga_waitretrace();
	  return 0;
	}
	*x = GGI_RP_DONTCARE;
	*y = GGI_RP_SYNC;

	return 1;
}

/* Not implemented 
int GGIMISC_Svgalib_GetRayPos(ggi_visual *vis, sint32 *x, sint32 *y) {
	return(0);
}
*/

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
#include <asm/io.h>
int GGIMISC_Svgalib_SetSplitline(ggi_visual *vis, int y) {
{
#define CRT_LINECOMPARE      0x18
#define CR07_LINECOMPARE_B8  0x10
#define CR09_LINECOMPARE_B9  0x40
#define outbCRT(val,reg) outw(((val) << 8) | (reg), CRTI)
        register uint8 foo;
	unsigned short CRTI,CRTD;
	
	if (y<0 || y>LIBGGI_MODE(vis)->visible.y) return -1;
	if (LIBGGI_MODE(vis)->visible.y<0x100) y <<= 1;
	
	CRTI=SVGAMISC_PRIV(vis)->CRTI;
	CRTD=SVGAMISC_PRIV(vis)->CRTD;
	
	outbCRT(y & 0xFF, CRT_LINECOMPARE);
	
	outb(0x07, CRTI);
	
	foo = (y & 0x0100)
	  ? inb(CRTD) | CR07_LINECOMPARE_B8
	  : inb(CRTD) & ~CR07_LINECOMPARE_B8;
	outbCRT(foo, 0x07);
	outb(0x09, CRTI);
	foo = (y & 0x0200)
	  ? inb(CRTD) | CR09_LINECOMPARE_B9
	  : inb(CRTD) & ~CR09_LINECOMPARE_B9;
	outbCRT(foo, 0x09);
        
	return(0);
}
#endif



