// CHN_INFO.CPP

// Copyright (C) 1998 Tommi Hassinen, Geoff Hutchison.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "chn_info.h"

#include "v3d.h"

#include <string.h>

#include <iomanip>
#include <iostream>
#include <sstream>
using namespace std;

/*################################################################################################*/

chn_info::chn_info(void)
{
	type = chn_info::not_defined;
	
	id_mol = NOT_DEFINED;
	id_chn = NOT_DEFINED;
	
	length = NOT_DEFINED;
	
	sequence1 = NULL;
	sequence3 = NULL;
	
	ss_state = NULL;
	p_state = NULL;
	
	description = NULL;
}

chn_info::chn_info(chn_type p1, i32s p2)
{
	type = p1;
	
	id_mol = NOT_DEFINED;
	id_chn = NOT_DEFINED;
	
	length = p2;
	
	sequence1 = new char[length + 1];
	for (i32s n1 = 0;n1 < length;n1++) sequence1[n1] = 0;
	sequence1[length] = 0;
	
	sequence3 = new char*[length + 1];
	for (i32s n1 = 0;n1 < length;n1++) sequence3[n1] = NULL;
	sequence3[length] = NULL;
	
	ss_state = NULL;
	p_state = NULL;
	
	description = NULL;
}

chn_info::chn_info(const chn_info & p1)
{
	type = p1.type;
	
	id_mol = p1.id_mol;
	id_chn = p1.id_chn;
	
	length = p1.length;
	
	if (p1.sequence1 != NULL)
	{
		sequence1 = new char[length + 1];
		for (i32s n1 = 0;n1 < length;n1++) sequence1[n1] = p1.sequence1[n1];
		sequence1[length] = 0;
	}
	else sequence1 = NULL;
	
	if (p1.sequence3 != NULL)
	{
		sequence3 = new char*[length + 1];
		for (i32s n1 = 0;n1 < length;n1++) sequence3[n1] = p1.sequence3[n1];
		sequence3[length] = 0;
	}
	else sequence3 = NULL;
	
	if (p1.ss_state != NULL)
	{
		ss_state = new char[length + 1];
		for (i32s n1 = 0;n1 < length;n1++) ss_state[n1] = p1.ss_state[n1];
		ss_state[length] = 0;
	}
	else ss_state = NULL;

	if (p1.p_state != NULL)
	{
		p_state = new char[length + 1];
		for (i32s n1 = 0;n1 < length;n1++) p_state[n1] = p1.p_state[n1];
		p_state[length] = 0;
	}
	else p_state = NULL;
	
	if (p1.description != NULL)
	{
		description = new char[strlen(p1.description) + 1];
		strcpy(description, p1.description);
	}
	else description = NULL;
}

chn_info::~chn_info(void)
{
	if (sequence1 != NULL) delete[] sequence1;

	if (sequence3 != NULL)
	{
		for (i32s n1 = 0;n1 < length;n1++) delete[] sequence3[n1];
		delete[] sequence3;
	}
	
	if (ss_state != NULL) delete[] ss_state;
	if (p_state != NULL) delete[] p_state;
	
	if (description != NULL) delete[] description;
}

/*################################################################################################*/

// eof
