/* $Id: gii_debug.h,v 1.1.1.1 2001/05/12 23:00:14 cegger Exp $
******************************************************************************

   LibGII debugging macros

   Copyright (C) 1998-1999 Marcus Sundberg	[marcus@ggi-project.org]
  
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#ifndef _GGI_INTERNAL_GII_DEBUG_H
#define _GGI_INTERNAL_GII_DEBUG_H

#include <stdio.h>
#include <stdarg.h>
#include <ggi/system.h>
#include <ggi/gg.h>

__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_LIBGII
extern uint32 _giiDebugState;
extern int    _giiDebugSync;
#else
IMPORTVAR uint32 _giiDebugState;
IMPORTVAR int    _giiDebugSync;
#endif

__END_DECLS

/* Debugging types
 * bit 0 is reserved! */

#define GIIDEBUG_CORE		(1<<1)	/*   2 */
#define GIIDEBUG_MISC		(1<<5)	/*  32 */
#define GIIDEBUG_LIBS		(1<<6)	/*  64 */
#define GIIDEBUG_EVENTS		(1<<7)	/* 128 */

#define GIIDEBUG_ALL	0xffffffff

#ifdef __GNUC__

#ifdef DEBUG
#define GIIDPRINT(args...)        if (_giiDebugState) { ggDPrintf(_giiDebugSync,"LibGII",args); }
#define GIIDPRINT_CORE(args...)   if (_giiDebugState & GIIDEBUG_CORE) { ggDPrintf(_giiDebugSync,"LibGII",args); }
#define GIIDPRINT_MISC(args...)   if (_giiDebugState & GIIDEBUG_MISC) { ggDPrintf(_giiDebugSync,"LibGII",args); }
#define GIIDPRINT_LIBS(args...)   if (_giiDebugState & GIIDEBUG_LIBS) { ggDPrintf(_giiDebugSync,"LibGII",args); }
#define GIIDPRINT_EVENTS(args...) if (_giiDebugState & GIIDEBUG_EVENTS) { ggDPrintf(_giiDebugSync,"LibGII",args); }
#else /* DEBUG */
#define GIIDPRINT(form,args...)		do{}while(0)
#define GIIDPRINT_CORE(form,args...)	do{}while(0)
#define GIIDPRINT_MISC(form,args...)	do{}while(0)
#define GIIDPRINT_LIBS(form,args...)	do{}while(0)
#define GIIDPRINT_EVENTS(form,args...)	do{}while(0)
#endif /* DEBUG */

#else /* __GNUC__ */

__BEGIN_DECLS

static inline void GIIDPRINT(const char *form,...)
{
#ifdef DEBUG
	if (_giiDebugState) {
		va_list args;

		fprintf(stderr, "LibGII: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_giiDebugSync) fflush(stderr);
	}
#endif
}

static inline void GIIDPRINT_CORE(const char *form,...)
{
#ifdef DEBUG
	if (_giiDebugState & GIIDEBUG_CORE) {
		va_list args;

		fprintf(stderr, "LibGII: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_giiDebugSync) fflush(stderr);
	}
#endif
}

static inline void GIIDPRINT_MISC(const char *form,...)
{
#ifdef DEBUG
	if (_giiDebugState & GIIDEBUG_MISC) {
		va_list args;

		fprintf(stderr, "LibGII: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_giiDebugSync) fflush(stderr);
	}
#endif
}

static inline void GIIDPRINT_LIBS(const char *form,...)
{
#ifdef DEBUG
	if (_giiDebugState & GIIDEBUG_LIBS) {
		va_list args;

		fprintf(stderr, "LibGII: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_giiDebugSync) fflush(stderr);
	}
#endif
}

static inline void GIIDPRINT_EVENTS(const char *form,...)
{
#ifdef DEBUG
	if (_giiDebugState & GIIDEBUG_EVENTS) {
		va_list args;

		fprintf(stderr, "LibGII: ");
		va_start(args, form);
		vfprintf(stderr, form, args);
		va_end(args);
		if (_giiDebugSync) fflush(stderr);
	}
#endif
}

__END_DECLS

#endif /* __GNUC__ */


#ifdef DEBUG
#define LIBGII_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGII:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define LIBGII_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGII:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else 
#define LIBGII_ASSERT(x,str)	do{}while(0)
#define LIBGII_APPASSERT(x,str)	do{}while(0)
#endif /* DEBUG */

#ifdef DEBUG
# define GIID0(x)	x
#else
# define GIID0(x)	/* empty */
#endif

#ifdef GIIDLEV
# if GIIDLEV == 1
#  define GIID1(x)	x
#  define GIID2(x)	/* empty */
#  define GIID3(x)	/* empty */
# elif GIIDLEV == 2
#  define GIID1(x)	x
#  define GIID2(x)	x
#  define GIID3(x)	/* empty */
# elif GIIDLEV > 2
#  define GIID1(x)	x
#  define GIID2(x)	x
#  define GIID3(x)	x
# endif
#else
# define GIID1(x)	/* empty */
# define GIID2(x)	/* empty */
# define GIID3(x)	/* empty */
#endif

#endif /* _GGI_INTERNAL_GII_DEBUG_H */
