--TEST -Pdummy.gpr

-------
-- C --
-------

--  Check that from an "enum" type we can correctly retrieve the valid
--  valid.

DECL _enum1:enum.c
#  1> _enum1:enum.c:1:14

LITERALS _enum1:enum.c
#  1> BAR:enum.c:3:3
#  2> FOO:enum.c:2:3

--  Check through the typedef
DECL enum1:enum.c
#  1> enum1:enum.c:4:3
TYPE enum1:enum.c
#  1> _enum1:enum.c:1:14
LITERALS enum1:enum.c

--  Check that an enumeration literal is properly reported as such, and
--  that we can find its parent enumeration
DOC FOO:enum.c
#enumeration literal declared at enum.c:2:3
#
#Type
#   _enum1
#

TYPE FOO:enum.c
#  1> _enum1:enum.c:1:14

--------
-- Ada --
---------

LITERALS Enum1:a.ads:2:9
#  1> Value1:a.ads:3:7
#  2> Value2:a.ads:4:7

TYPE Value1:a.ads
#  1> Enum1:a.ads:2:9

---------
-- C++ --
---------

LITERALS color:enums.cc:3
#  1> blue:enums.cc:6:9
#  2> green:enums.cc:5:9
#  3> red:enums.cc:4:9

LITERALS new_bool_enum:enums.cc:1
#  1> new_false:enums.cc:1:44
#  2> new_true:enums.cc:1:30

--  a typedef
LITERALS new_bool:enums.cc:1

TYPE a:enums.cc
#  1> new_bool:enums.cc:1:60
TYPE b:enums.cc
#  1> new_bool_enum:enums.cc:1:14
TYPE c:enums.cc
#  1> color:enums.cc:3:6
