=begin

= Ruby/GSL Reference
(See also ((<GSL reference manual|URL:http://www.gnu.org/software/gsl/manual/gsl-ref_toc.html>)))

  (1) ((<Introduction|URL:intro.html>))
  (2) ((<Using RubyGSL|URL:use.html>))
  (3) ((<Error Handling|URL:ehandling.html>))
  (4) ((<Mathematical Functions|URL:math.html>))
  (5) ((<Complex Numbers|URL:complex.html>))
  (6) ((<Polynomials|URL:poly.html>))
  (7) ((<Special Functions|URL:sf.html>))
  (8) ((<Vectors|URL:vector.html>)) and ((<Matrices|URL:matrix.html>))
  (9) ((<Permutations|URL:perm.html>))
  (10) ((<Combinations|URL:combi.html>))
  (11) ((<Sorting|URL:sort.html>))
  (12) ((<BLAS Support|URL:blas.html>))
  (13) ((<Linear Algebra|URL:linalg.html>))
  (14) ((<Eigen Systems|URL:eigen.html>))
  (15) ((<Fast Fourier Transform|URL:fft.html>))
  (16) ((<Numerical Integration|URL:integration.html>))
  (17) ((<Random Numbers|URL:rng.html>))
  (18) ((<Quasi-Random Sequences|URL:qrng.html>))
  (19) ((<Random Number Distributions|URL:randist.html>))
  (20) ((<Statistics|URL:stats.html>))
  (21) ((<1d-Histograms|URL:hist.html>)), ((<2d-Histograms|URL:hist2d.html>)) and ((<3d-Histograms|URL:hist3d.html>))
  (22) ((<N-tuples|URL:ntuple.html>))
  (23) ((<Monte-Carlo Integration|URL:monte.html>))
  (24) ((<Simulated Annealing|URL:siman.html>))
  (25) ((<Ordinary Differential Equations|URL:odeiv.html>))
  (26) ((<Interpolation|URL:interp.html>))
  (27) ((<Numerical Differentiation|URL:diff.html>))
  (28) ((<Chebyshev Approximations|URL:cheb.html>))
  (29) ((<Series Acceleration|URL:sum.html>))
  (30) ((<Wavelet Transforms|URL:wavelet.html>)) (GSL-1.6 feature)
  (31) ((<Discrete Hankel Transforms|URL:dht.html>))
  (32) ((<One dimensional Root-Finding|URL:roots.html>))
  (33) ((<One dimensional Minimization|URL:min.html>))
  (34) ((<Multidimensional Root-Finding|URL:multiroot.html>))
  (35) ((<Multidimensional Minimization|URL:multimin.html>))
  (36) ((<Least-Squares Fitting|URL:fit.html>))
  (37) ((<Nonlinear Least-Squares Fitting|URL:nonlinearfit.html>))
  (38) ((<Physical Constants|URL:const.html>))
  (39) ((<Graphics|URL:graph.html>))
  (40) GSL add-on packages
       (1) ((<rngextra|URL:rngextra.html>))
       (2) ((<Tensor manipulations|URL:tensor.html>))
  (41) ((<NArray compatibilities|URL:narray.html>))

((<next|URL:intro.html>))

((<top|URL:index.html>))
=end
