/*******************************************************************************************************************************************
 cmainform.c
*******************************************************************************************************************************************/

#include <ctype.h>
#include "cmainform.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// treeview item activation handling
//------------------------------------------------------------------------------------------------------------------------------------------
void CMainFormDemoTreeViewListener::OnItemActivated (CObject *, CObject *inItem)
{
	// retreive our treeview item instance
	CMainFormDemoModuleTreeViewItem *inDemoModuleTreeViewItem = static_cast <CMainFormDemoModuleTreeViewItem *> (inItem);

	// and launch the execution of the associated demo module, passing it the CApplication instance as a given owner
	inDemoModuleTreeViewItem -> m_DemoModule -> Run (static_cast <CApplication *> (CComponent::GetComponent(1L)));
}

//------------------------------------------------------------------------------------------------------------------------------------------
// treeview item selection
//------------------------------------------------------------------------------------------------------------------------------------------
void CMainFormDemoTreeViewListener::OnItemQuerySelect (CObject *inSender, CObject *inItem, const Bool inCurrent, Bool &)
{
	// retreive our treeview item instance
	CMainFormDemoModuleTreeViewItem *inDemoModuleTreeViewItem = static_cast <CMainFormDemoModuleTreeViewItem *> (inItem);

	// get the module associated description
	TDemoModuleDescription inDemoModuleDescription (inDemoModuleTreeViewItem -> m_DemoModule -> GetDescription());

	// get the main form instance that owns this tree view item
	CMainForm *inMainForm = static_cast <CMainForm *> (static_cast <CTreeView *> (inSender) -> GetOwner (__metaclass(CForm)));

	// is it a selection ?
	if (!inCurrent)
	{
		// open the given associated file
		CFile inModuleFile (inDemoModuleDescription.FileName, CString("rb"));

		// set the text view from the given source file
		*(inMainForm -> m_TextViewCode) << inModuleFile;

		// use a monospace font on the whole buffer on the code part
		inMainForm -> m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagMonospace);

		// set the description text properties
		inMainForm -> m_TextViewDesc -> SetText  (inDemoModuleDescription.Name + "\n\n" + inDemoModuleDescription.Description +
							  "\n\nDouble click on the left tree view item to start the demo or click the " +
							  "appropriate top tool button.");
		inMainForm -> m_TextViewDesc -> ApplyTag (CTextView::m_GtkTextTagScaleXXLarge, 0, inDemoModuleDescription.Name.GetLength());
		inMainForm -> m_TextViewDesc -> ApplyTag (CTextView::m_GtkTextTagWeightUltraBold, 0, 
							  inDemoModuleDescription.Name.GetLength());
		inMainForm -> m_TextViewDesc -> ApplyTag (CTextView::m_GtkTextTagItalic, inDemoModuleDescription.Name.GetLength() +
							  inDemoModuleDescription.Description.GetLength()+4, -1);
		inMainForm -> m_TextViewDesc -> ApplyTag (CTextView::m_GtkTextTagScaleSmall, inDemoModuleDescription.Name.GetLength() +
							  inDemoModuleDescription.Description.GetLength()+4, -1);

		// affect the new extra layout if any
		if (inDemoModuleDescription.Layout != NULL)
			inDemoModuleDescription.Layout -> SetOwner (inMainForm -> m_VBoxExtra);
		else
			inMainForm -> m_UnusedLabel -> SetOwner (inMainForm -> m_VBoxExtra);

		// just do a little code painting...
		inMainForm -> PaintTextViewCode ();
	}
	// it is a deselection
	else
	{
		// stop the associated demo module
		inDemoModuleTreeViewItem -> m_DemoModule -> Stop ();

		// unset the potential extra widgets parent
		if (inDemoModuleDescription.Layout != NULL) 
			inDemoModuleDescription.Layout -> SetOwner (NULL);
		else
			inMainForm -> m_UnusedLabel -> SetOwner (NULL);
	}
}

//------------------------------------------------------------------------------------------------------------------------------------------
// module tree view item constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CMainFormDemoModuleTreeViewItem::CMainFormDemoModuleTreeViewItem (CTreeView *inOwner, const CDemoModule *inDemoModule)
				:CTreeViewItem		 	 (inOwner, 
						  		  CItemFieldValues (1, 
									new CItemFieldValueString (inDemoModule->GetDescription().Name))),
				 m_DemoModule			 (const_cast <CDemoModule *> (inDemoModule))
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// module tree view item constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CMainFormDemoModuleTreeViewItem::CMainFormDemoModuleTreeViewItem (CTreeViewItem *inOwner, const CDemoModule *inDemoModule)
				:CTreeViewItem		 	 (inOwner,
						 		  CItemFieldValues (1, 
									new CItemFieldValueString (inDemoModule->GetDescription().Name))),
				 m_DemoModule			 (const_cast <CDemoModule *> (inDemoModule))
{ }

//------------------------------------------------------------------------------------------------------------------------------------------
// main form close request
//------------------------------------------------------------------------------------------------------------------------------------------
void CMainFormListener::OnQueryClose (CObject *inSender, Bool &ioDoClose)
{
	// just ask for user confirmation
	switch (CMessageDialog (static_cast <CForm *> (inSender), CString("Confirmation"), 
		CString("You are about to close the GtkOL demo.\n\nAre you sure you want to quit ?"), _DBYesNo_, 
		MESSAGEDIALOG_QUESTION, true).Run ())
	{
		// close ?
		case DIALOG_YES : 
			{
				// delete the potential modula extra widgets, so get the implemented related treeview items
				CComponents inItems = static_cast <CMainForm *> (inSender) -> m_TreeView -> 
									GetSubComponents (__metaclass(CTreeViewItem));

				// go through the items
				for (size_t i=0; i<inItems.GetLength(); i++)
				{
					// get the associated demo module
					CDemoModule *inDemoModule = 
						static_cast <CMainFormDemoModuleTreeViewItem *>	(*inItems[i]) -> m_DemoModule;

					// check it defines a layout and delete it
					if (inDemoModule -> GetDescription().Layout != NULL) 
						delete inDemoModule -> GetDescription().Layout;
				}

				// ok, let the libgtkol exist
				ioDoClose = true;  
			}
			break;

		// do not close
		default	:
			{
				// do not authorize libgtkol to close the form
				ioDoClose = false; 
			}
			break;
	}
}

//------------------------------------------------------------------------------------------------------------------------------------------
// file -> quit menu item click handling
//------------------------------------------------------------------------------------------------------------------------------------------
void CMainFormMenuItemQuitListener::OnClick (CObject *inSender)
{
	// request to close the form owner
	static_cast <CForm *> (static_cast <CMenuItem *> (inSender) -> GetOwner (__metaclass(CForm))) -> Close ();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// execute tool button
//------------------------------------------------------------------------------------------------------------------------------------------
void CMainFormToolButtonExecListener::OnClick (CObject *inSender)
{
	// retreive the main form owner of the specified toolbutton
	CMainForm *inMainForm = static_cast <CMainForm *> (static_cast <CToolButton *> (inSender) -> GetOwner (__metaclass(CForm)));

	// get the treeview selection
	CTreeViewItems inSelection (inMainForm -> m_TreeView -> GetSelection());

	// check an item is selected and start the associated demo module execution
	if (inSelection.GetLength() > 0 && static_cast <CMainFormDemoModuleTreeViewItem *> (*inSelection[0]) -> m_DemoModule != NULL)
		static_cast <CMainFormDemoModuleTreeViewItem *> (*inSelection[0]) -> m_DemoModule -> 
			Run (static_cast <CApplication *> (CComponent::GetComponent(1L)));
}

//------------------------------------------------------------------------------------------------------------------------------------------
// stop tool button
//------------------------------------------------------------------------------------------------------------------------------------------
void CMainFormToolButtonStopListener::OnClick (CObject *inSender)
{
	// retreive the main form owner of the specified toolbutton
	CMainForm *inMainForm = static_cast <CMainForm *> (static_cast <CToolButton *> (inSender) -> GetOwner (__metaclass(CForm)));

	// get the treeview selection
	CTreeViewItems inSelection (inMainForm -> m_TreeView -> GetSelection());

	// check an item is selected and stop the associated demo module execution
	if (inSelection.GetLength() > 0 && static_cast <CMainFormDemoModuleTreeViewItem *> (*inSelection[0]) -> m_DemoModule != NULL)
		static_cast <CMainFormDemoModuleTreeViewItem *> (*inSelection[0]) -> m_DemoModule -> Stop ();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// constructor
//------------------------------------------------------------------------------------------------------------------------------------------
CMainForm::CMainForm 	     (CApplication *inApplication)
	  :CForm     	     (inApplication, new CMainFormListener()),
	   m_VBoxLayout      (NULL),
	   m_MenuBar	     (NULL),
	   m_MenuItemFile    (NULL),
	   m_MenuItemQuit    (NULL),
	   m_ToolBar	     (NULL),
	   m_ToolButtonExec  (NULL),
	   m_ToolButtonStop  (NULL),
	   m_HPaned	     (NULL),
	   m_ScrollViewL     (NULL),
	   m_TreeView	     (NULL),
	   m_ScrollViewR     (NULL),
	   m_TextViewDesc    (NULL),
	   m_TextViewCode    (NULL),
	   m_VBoxExtra	     (NULL),
	   m_UnusedLabel     (NULL)
{
	// default bounds affectation, center the form
	SetBounds (TBounds (TBounds ((CApplication::GetScreenSize().w-640)/2, (CApplication::GetScreenSize().h-480)/2, 640, 480)));

	// caption affectation
	SetCaption (CString("GtkOL Demo"));

	// global vbox layout
	m_VBoxLayout   = new CVBoxLayout    (this);
	m_VBoxLayout -> SetHomogeneous      (false);
	m_VBoxLayout -> SetBoxPack 	    (BOXPACK_START, false, false, 0);

	// menu components
	m_MenuBar      = new CMenuBar	    (m_VBoxLayout);
	m_MenuItemFile = new CMenuItem	    (m_MenuBar, CString("_File"));
	m_MenuItemQuit = new CMenuItemImage (m_MenuItemFile, CString("_Quit"), _HKQuit_, new CMainFormMenuItemQuitListener());
			 new CImage	    (m_MenuItemQuit, GTK_STOCK_QUIT);

	// instanciate the toolbar
	m_ToolBar = new CToolBar	    (m_VBoxLayout);
	m_ToolBar -> SetStyle 		    (GTK_TOOLBAR_ICONS);
	m_ToolBar -> SetIconSize 	    (GTK_ICON_SIZE_SMALL_TOOLBAR);

	// instanciate the tool buttons
	m_ToolButtonExec = new CToolButton  (m_ToolBar, CString(GTK_STOCK_APPLY), NULL, new CMainFormToolButtonExecListener());
	m_ToolButtonExec -> SetToolTips	    (CString("Start the selected module execution"));
	m_ToolButtonStop = new CToolButton  (m_ToolBar, CString(GTK_STOCK_CANCEL), NULL, new CMainFormToolButtonStopListener());
	m_ToolButtonStop -> SetToolTips	    (CString("Stop the selected module execution"));

	// horizontal paned
	m_VBoxLayout -> SetBoxPack 	    (BOXPACK_START, true, true, 0);
	m_HPaned       = new CHPaned 	    (m_VBoxLayout);

	// left paned owns a treeview
	m_ScrollViewL  = new CScrollView    (m_HPaned);
	m_ScrollViewL -> SetPolicies 	    (GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	m_TreeView     = new CTreeView      (m_ScrollViewL, _IFVString_, new CMainFormDemoTreeViewListener());

	// right paned owns textviews and module specifics
	m_NoteBook     = new CNoteBook	    (m_HPaned);
	m_TextViewDesc = new CTextView      (m_NoteBook);
	m_ScrollViewR  = new CScrollView    (m_NoteBook);
	m_TextViewCode = new CTextView      (m_ScrollViewR);
	m_VBoxExtra    = new CVBoxLayout    (m_NoteBook);

	// instanciate the unused label
	m_UnusedLabel  = new CLabel	    (m_VBoxExtra, CString("Not used by this demo module."));

	// notbook caption tabs
	m_NoteBook -> SetTabCaption (CString("Description"), (UInt16)0);
	m_NoteBook -> SetTabCaption (CString("Source code"), (UInt16)1);
	m_NoteBook -> SetTabCaption (CString("Extra"), 	     (UInt16)2);

	// get the list of potential modules names from given path
	CStrings inModuleNames (CMetaModuleImporter::GetLibNames (DEMO_MODULES_PATH));

	// sort the libraries by name
	inModuleNames.Sort();

	// ok, go through the potential modules names and try to load them
	for (size_t i=0; i<inModuleNames.GetLength(); i++)
	{
		// be sure to request a demo module API
		CMetaModuleImporter *inDemoModuleImporter = new CMetaModuleImporter (*inModuleNames[i], __metaclass(CDemoModule));

		// keep the newly allocated importer into the buffer list
		m_DemoModuleImporters += inDemoModuleImporter;

		// get a default instance of the demo module and instanciate the associated tree view item
		new CMainFormDemoModuleTreeViewItem (m_TreeView, static_cast <CDemoModule *> (inDemoModuleImporter -> InstanciateModule()));
	}

	// select the first available demo module
	CComponents inItems (m_TreeView -> GetChildren (__metaclass(CTreeViewItem)));
	if (inItems.GetLength() > 0) static_cast <CTreeViewItem *> (*inItems[0]) -> Select ();

	// show the form
	Show();

	// maximize it
	Maximize ();
}

//------------------------------------------------------------------------------------------------------------------------------------------
// destructor
//------------------------------------------------------------------------------------------------------------------------------------------
CMainForm::~CMainForm ()
{
	// delete the importers; i.e. unlink the modules code and automatically free the allocated module instances
	for (size_t i=0; i<m_DemoModuleImporters.GetLength(); i++) delete *m_DemoModuleImporters[i];
}

//------------------------------------------------------------------------------------------------------------------------------------------
// constant declarations
//------------------------------------------------------------------------------------------------------------------------------------------

// green syntax
const static char * BasicGreenWords[] =
{
	"unsigned", "char", "short", "int", "size_t", "long", "float", "void", "bool", "static", "virtual", "class", "struct", "const",
	"typedef ", "enum", "CString", "template", "TBounds", "TSize", "TPoint"
}; const static int BASICGREENWORDS = 21;

// red syntax
const static char * BasicRedWords[] =
{
	"for", "switch", "while", "break", "continue", "do", "metaclass_cast", "classtag_cast", "__metaclass", "static_cast",
	"reinterpret_cast", "const_cast", "dynamic_cast", "public", "protected", "private", "new", "delete", "true", "false", 
	"return", "NULL", "if", "else", "this"
}; const static int BASICREDWORDS = 25;

//------------------------------------------------------------------------------------------------------------------------------------------
// syntax color
//------------------------------------------------------------------------------------------------------------------------------------------
void CMainForm::PaintTextViewCode ()
{
	// check pointer
	if (m_TextViewCode == NULL) return;
	
	// get the text view loaded text
	CString inText (m_TextViewCode-> GetText ());

	// first of all, go through the text buffer and try to find the gtkol specific referenced types i.e. the metaclasses
	size_t i=0, j=0; for (i=METACLASSESLENGTH, j=0; i>0; i--, j++)
	{
		size_t k=0, l=0; while (inText.Find (METACLASSES(j)->ClassName, k, &l)) 
		{
			if (CMainForm::IsIsolated (inText, l, l+METACLASSES(j)->ClassName.GetLength()))
				m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgDarkGreen, 
							   (SInt32)l, l+METACLASSES(j)->ClassName.GetLength());
			k = l+1;
		}
	}

	// check for the given green key words
	i=0; j=0; for (i=BASICGREENWORDS, j=0; i>0; i--, j++)
	{
		size_t k=0, l=0; while (inText.Find (CString(BasicGreenWords[j]), k, &l))
		{
			if (CMainForm::IsIsolated (inText, l, l+CString(BasicGreenWords[j]).GetLength()))
				m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgDarkGreen, 
							   (SInt32)l, l+CString(BasicGreenWords[j]).GetLength());
			k = l+1;
		}
	}

	// check for the given red key words
	i=0; j=0; for (i=BASICREDWORDS, j=0; i>0; i--, j++)
	{
		size_t k=0, l=0; while (inText.Find (CString(BasicRedWords[j]), k, &l))
		{
			if (CMainForm::IsIsolated (inText, l, l+CString(BasicRedWords[j]).GetLength()))
				m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgDarkRed, 
							   (SInt32)l, l+CString(BasicRedWords[j]).GetLength());
			k = l+1;
		}
	}

	// check for the " specifications
	i=0; j=0; while (inText.Find (CString("\""), i, &j))
	{
		size_t k=0; if (inText.Find (CString("\""), j+1, &k))
			m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgRed, (SInt32)j, k+1);
		i = k+1;
	}	

	// check for the ' specifications
	i=0; j=0; while (inText.Find (CString("'"), i, &j))
	{
		size_t k=0; if (inText.Find (CString("'"), j+1, &k))
			m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgRed, (SInt32)j, k+1);
		i = k+1;
	}

	// check for digits
	for (i=inText.GetLength(), j=0; i>0; i--, j++)
		if (::isdigit(*inText[j])) m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgRed, (SInt32)j, j+1);

	// check for the preprocessor directives
	i=0; j=0; while (inText.Find (CString("#"), i, &j))
	{
		if (j>0 && ::isspace((*inText[j-1])))
		{
			size_t k=0; if (inText.Find (CString("\n"), j, &k))
				m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgRed, (SInt32)j, k);
		}
		i = j+1;
	}

	// check for the /* comments
	i=0; j=0; while (inText.Find (CString("/*"), i, &j))
	{
		size_t k=0; if (inText.Find (CString("*/"), j, &k))
			m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgDarkBlue, (SInt32)j, k+2);
		i = k+2;
	}

	// check for the // comments
	i=0; j=0; while (inText.Find (CString("//"), i, &j))
	{
		size_t k=0; if (inText.Find (CString("\n"), j, &k))
			m_TextViewCode -> ApplyTag (CTextView::m_GtkTextTagFgDarkBlue, (SInt32)j, k);
		i = k+1;
	}
}

//------------------------------------------------------------------------------------------------------------------------------------------
// check string isolation
//------------------------------------------------------------------------------------------------------------------------------------------
inline bool CMainForm::IsIsolated (const CString &inString, const size_t inFrom, const size_t inTo)
{
	if (inFrom > 0)
	{
		if (inTo < inString.GetLength())
		{
			if ((::isspace(*inString[inFrom-1]) || ::ispunct(*inString[inFrom-1])) && *inString[inFrom-1] != '#' &&
			    (::isspace(*inString[inTo])     || ::ispunct(*inString[inTo]) && *inString[inTo] != '_')) return true;
		}
		else
		{
			if ((::isspace(*inString[inFrom-1]) || ::ispunct(*inString[inFrom-1])) && *inString[inFrom-1] != '#') return true;
		}
	}
	else
	{
		if (inTo < inString.GetLength())
		{
			if (::isspace(*inString[inTo]) || ::ispunct(*inString[inTo]) && *inString[inTo] != '_') return true;
		}
	}

	// ok
	return false;
}



