/*******************************************************************************************************************************************
 centry.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CEntry			    |--CEntryListener

 The centry is a single line text entry widget.
*******************************************************************************************************************************************/

#ifndef __CENTRY_H__
#define __CENTRY_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CEntryListener class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CEntryListener : public CWidgetListener
{
	// instanciation section
	public :

		CEntryListener			();
		virtual ~CEntryListener		() =0;

	// listening specifics
	public :

		// called when the inSender text is going to be modified with the specified ioString at the given ioPosition
                virtual void                    OnQueryInsert   	(CObject *inSender, CString &ioString, UInt16 &ioPosition,
                                                                	 Bool &ioAccept)					{ }

                // called when the inSender text is about to be deleted between the specified indices
                virtual void                    OnQueryDelete   	(CObject *inSender, UInt16 &ioStart, UInt16 &ioEnd,
                                                                	 Bool &ioAccept)					{ }

                // called when the inSender text has been modified
                virtual void                    OnChange        	(CObject *inSender)					{ }

		// called when the inSender text editing is done
		virtual void			OnEditingDone		(CObject *inSender)					{ }

		// metaclass section
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_nty', CEntryListener, CWidgetListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// centry xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <centry text="string" max-length="UInt16" visibility="true|false" invisible-char="SInt8" has-frame="true|false" editable="true|false"
//  position="SInt16" selection-beg="UInt16" selection-end="UInt16">
//    ...
// </centry>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_ENTRY_ELEMENT 		("centry");
static CString XML_ENTRY_ATTR_TEXT		("text");
static CString XML_ENTRY_ATTR_MAX_LENGTH	("max-length");
static CString XML_ENTRY_ATTR_VISIBILITY	("visibility");
static CString XML_ENTRY_ATTR_INVISIBLE_CHAR	("invisible-char");
static CString XML_ENTRY_ATTR_HAS_FRAME		("has-frame");
static CString XML_ENTRY_ATTR_EDITABLE		("editable");
static CString XML_ENTRY_ATTR_POSITION		("position");
/*
static CString XML_ENTRY_ATTR_SELECTION_BEG	("selection-beg");
static CString XML_ENTRY_ATTR_SELECTION_END	("selection-end");
*/
//-----------------------------------------------------------------------------------------------------------------------------------------
// CEntry class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CEntry : public CWidget
{
	// instanciation section
	public :

		CEntry				(CContainer *inOwner=NULL, const CEntryListener *inListener=NULL);
		virtual ~CEntry			();

	// protected requests handling
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// CObject redefinition
	protected :

		// listener affectation, must be derived from CEntryListener
		virtual const CMetaClass *	ListenerMustBe			() const;

	// CComponent redefinition
	public :

		// expected owner type : __metaclasses(CContainer)
		virtual CMetaClasses		OwnerMustBe			() const;

	// CEntry specifics
	public :

		// entry text access
		virtual void			SetText				(const CString &inText);
		virtual CString			GetText				() const;

		// entry max length
		virtual void			SetMaxLength			(const SInt16 inMaxLength=0);
		virtual SInt16			GetMaxLength			() const;

		// text visibility
		virtual void			SetVisibility			(const bool inVisibility);
		virtual bool			GetVisibility			() const;

		// invisible character
		virtual void			SetInvisibleChar		(const SInt8 inChar);
		virtual SInt8			GetInvisibleChar		() const;

		// entry frame decoration
		virtual void			SetHasFrame			(const bool inFrame);
		virtual bool			GetHasFrame			() const;

		// editable entry state
		virtual void			SetEditable			(const bool);
                virtual bool			GetEditable			() const;

		// entry text selection
		virtual void			Select				(const SInt16 inStart, const SInt16 inEnd=-1L);
                virtual CString			GetSelection			(SInt16 *outStart=NULL, SInt16 *outEnd=NULL) const;

		// entry cursor position
		virtual void			SetPosition			(const SInt16 =-1L);
                virtual SInt16			GetPosition			() const;

	// clipboard operations
	public :

		// copy, cut, paste to clipboard
                virtual void                    Cut                             ();
                virtual void                    Copy                            ();
                virtual void                    Paste                           ();

	// CSerialized overloading
	public :

		// CEntry serialization definition
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode)
										 THROWABLE;

	// static to dynamic listening section
	protected :

		static void                     OnInsertText                    (GtkEditable *, gchar *, gint, gint *, gpointer);
                static void                     OnDeleteText                    (GtkEditable *, gint, gint, gpointer);
                static void                     OnChange                        (GtkEditable *, gpointer);
		static void			OnEditingDone			(GtkCellEditable *, gpointer);
	
		// dynamic metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('ntry', CEntry, CWidget);

#endif

