/*******************************************************************************************************************************************
 cimage.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CImage

 CImage uses the GtkImage widget to display an image.
*******************************************************************************************************************************************/

#ifndef __CIMAGE_H__
#define __CIMAGE_H__

#include "ccontainer.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// cimage xml serialization constant definition
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cimage [file-name="string"] [stock-id="string" icon-size="menu|small-toolbar|large-toolbar|button|dnd|dialog"]>
//   ...
// </cimage>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_IMAGE_ELEMENT		("cimage");
static CString XML_IMAGE_ATTR_FILENAME		("file-name");
static CString XML_IMAGE_ATTR_STOCK_ID		("stock-id");
static CString XML_IMAGE_ATTR_ICON_SIZE		("icon-size");

//-----------------------------------------------------------------------------------------------------------------------------------------
// CImage class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CImage : public CWidget
{
	// instanciation section
	public :

		CImage				(CContainer *inOwner=NULL, const CString &inFileName=CString(), 
						 const CWidgetListener *inListener=NULL);
		CImage				(CContainer *inOwner, const char *inStockId, 
						 const GtkIconSize inGtkIconSize=GTK_ICON_SIZE_MENU, 
						 const CWidgetListener *inListener=NULL);
		virtual ~CImage			();

	// protected redefinition
	protected :

		// gtk image instanciation and initialization
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// cimage specifics
	public :

		// set the image from the given file / get the image's file name if any
		virtual void			SetFromFile			(const CString &inFileName);
		virtual CString			GetFileName			() const;

		// set the image from stock id
		virtual void			SetFromStock			(const char *inStockId, 
										 const GtkIconSize inGtkIconSize=GTK_ICON_SIZE_MENU);
		virtual bool			GetFromStock			(CString &outStockId, GtkIconSize &outGtkIconSize) const;

	// serialization specifics
	public :

		// cimage xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode) 
										 THROWABLE;

	// protected attributes
	protected :

		// associated file name if any, stock local specifications
		CString				m_FileName;
		CString				m_StockId;
		GtkIconSize			m_GtkIconSize;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('imge', CImage, CWidget);

#endif
