/* GNOME Transcript
 * Copyright (C) 1999 the Free Software Foundation
 * Authors : Jos Miguel Ronquillo
 *           Matias Mutchinick   
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __GTRANS_IFASE_PLUGIN_H__
#define __GTRANS_IFASE_PLUGIN_H__

#include <glib.h>
#include <gmodule.h>
#include "gtrans_ifase_conn.h"



/**
 * GTransIFasePlugin is the type we use to hold
 * info needed to work with a plugin.
 */
typedef struct _GTransIFasePlugin GTransIFasePlugin;
struct _GTransIFasePlugin 
{
	/* Name of the plugin */
	gchar             *name;
	
	/* The function that connects to the server */
	GTransIFaseConn   *(*connect) (gchar   *,
				       gchar   *,
				       gchar   *,
				       gchar   *,
				       gchar   *);
	
	/* Absolute path of the plugin filename */
	gchar             *filename;

	/* gmodule */
	GModule           *plugin;
};





/**
 * gtrans_ifase_plugin_list:
 * @dirname : the directory name to sarch for plugins.
 *
 * Returns a GList of the valid (but not repited) GTransIFasePlugin's
 * foun in @dirname.
 */
GList *
gtrans_ifase_plugin_list (gchar *dirname);


#endif /* __GTRANS_IFASE_PLUGIN_H__ */





