@echo OFF
rem /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
rem * Copyright by The HDF Group.                                               *
rem * Copyright by the Board of Trustees of the University of Illinois.         *
rem * All rights reserved.                                                      *
rem *                                                                           *
rem * This file is part of HDF.  The full HDF copyright notice, including       *
rem * terms governing use, modification, and redistribution, is contained in    *
rem * the files COPYING and Copyright.html.  COPYING can be found at the root   *
rem * of the source code distribution tree; Copyright.html can be found at      *
rem * http://hdfgroup.org/products/hdf4/doc/Copyright.html.  If you do not have *
rem * access to either file, you may request a copy from help@hdfgroup.org.     *
rem * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
rem
rem  File Name: testncgen.bat
rem  This batch file is used to test mfhdf and netCDF interface
rem  This script has the following options:
rem    testinterface (release / debug)
rem             Test either the release or debug version of mfhdf and netCDF interface
rem  Created:       Scott Wegner, 6/11/08
rem  Last Updated:  Scott Wegner, 6/13/08

setlocal enabledelayedexpansion
pushd %~dp0

set srcdir=%CD%
set ncdump=..\ncdump\%1\ncdump
set diff=fc /w

goto main

rem Test the "-b" option of ncgen
:b-check
    %CD%\%1\ncgen -b test1.cdl
    %ncdump% test1.nc > test2.cdl
    %diff% test1.cdl test2.cdl > nul
    if %errorlevel% equ 0 (
        echo.*** ncgen -b test successful ***
    ) else (
        echo.*** ncgen -b test failed ***
        exit /b 1
    )
    exit /b 0
    
 
rem Test the "-c" option of ncgen
:c-check
    rem tests `-c' option, creates ctest0.nc
    rem Only test if ctest0 is available.  It isn't built by default on
    rem Visual Studio 6 because source code needs to be generated by hand.
    rem --SJW 6/13/08
    if not exist %CD%\%1\ctest0 (
        echo.*** ncgen -c test skipped -- ctest0 not available ***
        exit /b 0
    )
    
    %CD%\%1\ctest0
    %ncdump% -n test1 ctest0.nc > ctest1.cdl
    %diff% test1.cdl ctest1.cdl > nul
    if %errorlevel% equ 0 (
        echo.*** ncgen -c test successful ***
    ) else (
        echo.*** ncgen -c test failed  ***
        exit /b 1
    )
    exit /b 0
    
    
rem Test the "-f" option of ncgen
:f-check
    %CD%\%1\ftest0
    %ncdump% -n test1 ftest0.nc > ftest1.cdl
    %diff% test1.cdl ftest1.cdl > nul
    if %errorlevel% equ 0 (
        echo.*** ncgen -f test successful ***
    ) else (
        echo.*** ncgen -f test failed ^(but roundoff differences are OK^) ***
        exit /b 1
    )
    exit /b 0


:main

    rem Generate test0.nc
    %CD%\%1\ncgen -b -o test0.nc %srcdir%\test0.cdl
    
    rem Generate test1.cdl
    %ncdump% -n test1 test0.nc > test1.cdl

    if defined build_fortran_conditional (
        set tests=b-check c-check f-check
    ) else (
        set tests=b-check c-check
    )
    for %%a in (%tests%) do (
        call :%%a %1
        if !errorlevel! neq 0 (
            popd
            endlocal & exit /b
        )
    )
    
    rem And the cleanup
    del /f test0.nc ctest0.nc ftest0.nc test1.cdl test1.nc ctest1.cdl ftest1.cdl test2.cdl

    popd
    endlocal & exit /b 0
