package org.jboss.cache.factories;

import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;

/**
 * Buddy manager factory
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.1.0
 */
@DefaultFactoryFor(classes = {BuddyManager.class})
public class BuddyManagerFactory extends EmptyConstructorFactory
{
   @Override
   public <T> T construct(Class<T> componentType)
   {
      if (configuration.getBuddyReplicationConfig() != null && configuration.getBuddyReplicationConfig().isEnabled() && configuration.getCacheMode() != Configuration.CacheMode.LOCAL)
      {
         return super.construct(componentType);
      }
      else
      {
         return null;
      }
   }
}
