/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.util.HashMap;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.ObjectFactory;

public class SimpleObjectFactory
implements ObjectFactory {
    private HashMap objectMappings = new HashMap();
    private HashMap manualMappings = new HashMap();
    private HashMap multiplexMappings = new HashMap();

    public void addGenericHandler(GenericObjectFactory handler) {
        this.objectMappings.put(handler.getBaseClass(), handler);
    }

    public void addManualMapping(ManualMappingDefinition mapping) {
        this.manualMappings.put(mapping.getBaseClass(), mapping);
    }

    public void addMultiplexMapping(MultiplexMappingDefinition mplex) {
        this.multiplexMappings.put(mplex.getBaseClass(), mplex);
    }

    public void clear() {
        this.objectMappings.clear();
        this.manualMappings.clear();
        this.multiplexMappings.clear();
    }

    public GenericObjectFactory getFactoryForClass(Class c) {
        GenericObjectFactory factory = (GenericObjectFactory)this.objectMappings.get(c);
        if (factory == null) {
            return null;
        }
        return factory.getInstance();
    }

    public ManualMappingDefinition getManualMappingDefinition(Class c) {
        return (ManualMappingDefinition)this.manualMappings.get(c);
    }

    public MultiplexMappingDefinition getMultiplexDefinition(Class c) {
        MultiplexMappingDefinition definition = (MultiplexMappingDefinition)this.multiplexMappings.get(c);
        return definition;
    }

    public boolean isGenericHandler(Class c) {
        return this.objectMappings.containsKey(c);
    }
}

